/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib.allocator;

import java.util.ArrayList;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.Metrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Allocator {
    private static Logger logger = Logger.getLogger(Allocator.class.getName());
    protected Metrics metrics = null;
    protected long minSizeInB;
    protected long maxSizeInB;
    protected ArrayList<FreeList> freeLists;
    protected boolean allowSplitting;
    protected boolean allowCoalescing;

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public long getMinSizeInB() {
        return this.minSizeInB;
    }

    public void setMinSizeInB(long minSizeInB) {
        this.minSizeInB = minSizeInB;
    }

    public long getMaxSizeInB() {
        return this.maxSizeInB;
    }

    public void setMaxSizeInB(long maxSizeInB) {
        this.maxSizeInB = maxSizeInB;
    }

    public ArrayList<FreeList> getFreeLists() {
        return this.freeLists;
    }

    public boolean isAllowSplitting() {
        return this.allowSplitting;
    }

    public boolean isAllowCoalescing() {
        return this.allowCoalescing;
    }

    public Allocator(long minSizeInB, long maxSizeInB, boolean allowSplitting, boolean allowCoalescing) {
        this.minSizeInB = minSizeInB;
        this.maxSizeInB = maxSizeInB;
        this.allowSplitting = allowSplitting;
        this.allowCoalescing = allowCoalescing;
        minSizeInB = Long.MAX_VALUE;
        maxSizeInB = Long.MIN_VALUE;
        this.freeLists = new ArrayList();
    }

    public void add(FreeList freeList) {
        if (freeList.getMinSizeInB() < this.minSizeInB) {
            logger.severe("FreeList min size is less than allocator min size: " + freeList.getMinSizeInB() + "<" + this.minSizeInB);
            return;
        }
        freeList.setIndex(this.freeLists.size());
        this.freeLists.add(freeList);
    }

    public boolean canManage(long sizeInB) {
        return sizeInB > this.minSizeInB && sizeInB <= this.maxSizeInB;
    }

    public abstract void setup(FreeList.DATA_STRUCTURE var1, FreeList.ALLOCATION_MECHANISM var2, FreeList.ALLOCATION_POLICY var3);

    public abstract Block malloc(long var1, Block var3);
}

