/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib.allocator;

import java.util.Iterator;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.allocator.StrictSegregatedFit;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.FreeList;

public class BuddySystem
extends StrictSegregatedFit {
    private static Logger logger = Logger.getLogger(BuddySystem.class.getName());
    private static final double phi = (1.0 + Math.sqrt(5.0)) / 2.0;
    protected TYPE type;
    protected int baseIndex = 0;

    public TYPE getType() {
        return this.type;
    }

    public BuddySystem(TYPE type, long minSizeInB, long maxSizeInB, boolean allowSplitting, boolean allowCoalescing) {
        super(minSizeInB, maxSizeInB, allowSplitting, allowCoalescing);
        this.type = type;
    }

    @Override
    public void setup(FreeList.DATA_STRUCTURE dataStructure, FreeList.ALLOCATION_MECHANISM allocationMechanism, FreeList.ALLOCATION_POLICY allocationPolicy) {
        FreeList freeList = null;
        switch (this.type) {
            case BINARY: {
                long tempMinSizeInB = this.minSizeInB;
                this.baseIndex = tempMinSizeInB == 0L ? 0 : (int)Math.ceil(Math.log(tempMinSizeInB) / Math.log(2.0));
                long tempMaxSizeInB = (long)Math.pow(2.0, this.baseIndex - 1);
                while (tempMaxSizeInB < this.maxSizeInB) {
                    tempMaxSizeInB = tempMaxSizeInB == 0L ? 1L : (tempMaxSizeInB *= 2L);
                    freeList = new FreeList(dataStructure, allocationMechanism, allocationPolicy, tempMinSizeInB, tempMaxSizeInB);
                    super.add(freeList);
                    tempMinSizeInB = tempMaxSizeInB;
                }
                break;
            }
            case FIBONACCI: {
                long tempMinSizeInB = this.minSizeInB;
                long tempMaxSizeInB = 0L;
                while (tempMaxSizeInB <= tempMinSizeInB) {
                    tempMaxSizeInB = BuddySystem.fibonacci(++this.baseIndex);
                }
                --this.baseIndex;
                int tempIndex = this.baseIndex;
                tempMaxSizeInB = tempMinSizeInB;
                while (tempMaxSizeInB < this.maxSizeInB) {
                    tempMaxSizeInB = BuddySystem.fibonacci(++tempIndex);
                    freeList = new FreeList(dataStructure, allocationMechanism, allocationPolicy, tempMinSizeInB, tempMaxSizeInB);
                    super.add(freeList);
                    tempMinSizeInB = tempMaxSizeInB;
                }
                break;
            }
        }
    }

    @Override
    public int computeFreeListIndex(long sizeInB) {
        int index = 0;
        switch (this.type) {
            case BINARY: {
                this.metrics.addExecutionTime(1L);
                index = (int)Math.ceil(Math.log(sizeInB) / Math.log(2.0)) - this.baseIndex;
                break;
            }
            case FIBONACCI: {
                index = this.baseIndex;
                while (BuddySystem.fibonacci(index) < sizeInB) {
                    this.metrics.addExecutionTime(1L);
                    ++index;
                }
                index -= this.baseIndex + 1;
            }
        }
        return index;
    }

    public static long fibonacci(int n) {
        return (long)((Math.pow(phi, n) - Math.pow(-phi, -n)) / Math.sqrt(5.0));
    }

    @Override
    public Block coalesce(long sizeInB) {
        this.metrics.incCoalescings(1);
        int index = this.computeFreeListIndex(sizeInB);
        int indexI = 0;
        int indexJ = 0;
        switch (this.type) {
            case BINARY: {
                if (index == 0) {
                    return null;
                }
                indexI = index - 1;
                indexJ = index - 1;
                break;
            }
            case FIBONACCI: {
                if (index <= 1) {
                    return null;
                }
                indexI = index - 1;
                indexJ = index - 2;
            }
        }
        FreeList freeListI = (FreeList)this.freeLists.get(indexI);
        FreeList freeListJ = (FreeList)this.freeLists.get(indexJ);
        Block leftBlock = null;
        Block blockIJ = null;
        long finalSizeInB = 0L;
        for (Block blockI : freeListI.getFreeBlocks()) {
            for (Block blockJ : freeListJ.getFreeBlocks()) {
                leftBlock = blockI.getPosition() == blockJ.getPosition() ? null : (blockI.getPosition() < blockJ.getPosition() ? blockI : blockJ);
                if (leftBlock == null || Math.abs(blockI.getPosition() - blockJ.getPosition()) != leftBlock.getSizeInB()) continue;
                this.metrics.addExecutionTime(1L);
                finalSizeInB = blockI.getSizeInB() + blockJ.getSizeInB();
                FreeList freeList = (FreeList)this.freeLists.get(index);
                this.metrics.incSuccessCoalescings(1);
                blockI.getFreeList().removeBlockByPosition(blockI.getPosition());
                blockJ.getFreeList().removeBlockByPosition(blockJ.getPosition());
                blockIJ = new Block(freeList, blockI.getPosition(), finalSizeInB);
                return blockIJ;
            }
        }
        return null;
    }

    @Override
    public Block split(long sizeInB) {
        this.metrics.incSplittings(1);
        int index = this.computeFreeListIndex(sizeInB) + 1;
        int indexI = 0;
        int indexJ = 0;
        if (index >= this.freeLists.size()) {
            return null;
        }
        switch (this.type) {
            case BINARY: {
                indexI = index - 1;
                indexJ = index - 1;
                break;
            }
            case FIBONACCI: {
                if (index <= 1) {
                    return null;
                }
                indexI = index - 1;
                indexJ = index - 2;
            }
        }
        FreeList freeList = (FreeList)this.freeLists.get(index);
        FreeList freeListI = (FreeList)this.freeLists.get(indexI);
        Block newBlockI = new Block(freeListI, 0L, freeListI.getMaxSizeInB());
        FreeList freeListJ = (FreeList)this.freeLists.get(indexJ);
        Iterator<Block> iterator = freeList.getFreeBlocks().iterator();
        if (iterator.hasNext()) {
            Block currentBlock = iterator.next();
            this.metrics.addExecutionTime(1L);
            this.metrics.incSuccessSplittings(1);
            currentBlock.getFreeList().removeBlockByPosition(currentBlock.getPosition());
            currentBlock.setFreeList(freeListJ);
            currentBlock.setSizeInB(freeListJ.getMaxSizeInB());
            freeListJ.getFreeBlocks().add(currentBlock);
            newBlockI.setPosition(currentBlock.getPosition() + currentBlock.getSizeInB());
            return newBlockI;
        }
        return null;
    }

    public static enum TYPE {
        BINARY,
        FIBONACCI;

    }
}

