/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib.freelist;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.BlockConsistentComparatorByDataSize;
import jeco.dmm.sim2.util.Metrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeList {
    private static Logger logger = Logger.getLogger(FreeList.class.getName());
    protected Metrics metrics = null;
    protected int index;
    protected ALLOCATION_MECHANISM allocationMechanism;
    protected DATA_STRUCTURE dataStructure;
    protected ALLOCATION_POLICY allocationPolicy;
    protected long minSizeInB;
    protected long maxSizeInB;
    protected Collection<Block> freeBlocks;

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ALLOCATION_MECHANISM getAllocationMechanism() {
        return this.allocationMechanism;
    }

    public DATA_STRUCTURE getDataStructure() {
        return this.dataStructure;
    }

    public ALLOCATION_POLICY getAllocationPolicy() {
        return this.allocationPolicy;
    }

    public long getMinSizeInB() {
        return this.minSizeInB;
    }

    public long getMaxSizeInB() {
        return this.maxSizeInB;
    }

    public Collection<Block> getFreeBlocks() {
        return this.freeBlocks;
    }

    public FreeList(DATA_STRUCTURE dataStructure, ALLOCATION_MECHANISM allocationMechanism, ALLOCATION_POLICY allocationPolicy, long minSizeInB, long maxSizeInB) {
        this.dataStructure = dataStructure;
        this.allocationMechanism = allocationMechanism;
        this.allocationPolicy = allocationPolicy;
        this.minSizeInB = minSizeInB;
        this.maxSizeInB = maxSizeInB;
        this.freeBlocks = !dataStructure.equals((Object)DATA_STRUCTURE.BTREE) ? new LinkedList<Block>() : new TreeSet<Block>(new BlockConsistentComparatorByDataSize());
    }

    public Block malloc(long sizeInB, Block hottest) {
        if (this.freeBlocks.isEmpty()) {
            return new Block(this, -1L, sizeInB);
        }
        Block block = null;
        if (this.allocationMechanism.equals((Object)ALLOCATION_MECHANISM.FIRST)) {
            block = this.firstFit(sizeInB);
        } else if (this.allocationMechanism.equals((Object)ALLOCATION_MECHANISM.BEST)) {
            block = this.bestFit(sizeInB);
        } else if (this.allocationMechanism.equals((Object)ALLOCATION_MECHANISM.EXACT)) {
            block = this.exactFit(sizeInB);
        } else if (this.allocationMechanism.equals((Object)ALLOCATION_MECHANISM.FARTHEST)) {
            block = hottest != null ? this.farthestFit(sizeInB, hottest) : this.firstFit(sizeInB);
        }
        if (block == null) {
            block = new Block(this, -1L, sizeInB);
        }
        return block;
    }

    public void free(Block block) {
        if (this.dataStructure.equals((Object)DATA_STRUCTURE.BTREE)) {
            if (this.freeBlocks.isEmpty()) {
                this.metrics.addExecutionTime(1L);
                this.metrics.addMemoryAccesses(1L);
            } else {
                this.metrics.addExecutionTime((long)(Math.log(this.freeBlocks.size()) / Math.log(2.0)));
                this.metrics.addMemoryAccesses((long)(Math.log(this.freeBlocks.size()) / Math.log(2.0)));
            }
        } else {
            this.metrics.addExecutionTime(1L);
            this.metrics.addMemoryAccesses(1L);
        }
        block.freeList = this;
        if (this.dataStructure.equals((Object)DATA_STRUCTURE.BTREE)) {
            this.freeBlocks.add(block);
        } else {
            LinkedList linkedList = (LinkedList)this.freeBlocks;
            switch (this.allocationPolicy) {
                case LIFO: {
                    linkedList.addFirst(block);
                    break;
                }
                default: {
                    linkedList.add(block);
                }
            }
        }
    }

    public boolean canManage(long sizeInB) {
        return sizeInB > this.minSizeInB && sizeInB <= this.maxSizeInB;
    }

    public void removeBlockByPosition(long position) {
        Block block = null;
        Iterator<Block> iterator = this.freeBlocks.iterator();
        while (iterator.hasNext()) {
            block = iterator.next();
            if (block.position != position) continue;
            iterator.remove();
            break;
        }
    }

    private Block farthestFit(long sizeInB, Block hottest) {
        Block bestBlock = null;
        int bestIndex = -1;
        long maxDist = 0L;
        Iterator<Block> iterator = this.freeBlocks.iterator();
        int currentIndex = 0;
        while (iterator.hasNext()) {
            Block currentBlock = iterator.next();
            if (sizeInB <= currentBlock.sizeInB && Math.abs(currentBlock.position - hottest.position) > maxDist) {
                maxDist = Math.abs(currentBlock.position - hottest.position);
                bestBlock = currentBlock;
                bestIndex = currentIndex;
            }
            ++currentIndex;
            this.metrics.addExecutionTime(1L);
            this.metrics.addMemoryAccesses(1L);
        }
        if (bestBlock != null) {
            iterator = this.freeBlocks.iterator();
            Block temp = null;
            for (int i = 0; i <= bestIndex; ++i) {
                temp = iterator.next();
            }
            iterator.remove();
            if (this.dataStructure.equals((Object)DATA_STRUCTURE.SLL)) {
                this.metrics.addExecutionTime(bestIndex);
                this.metrics.addMemoryAccesses(bestIndex);
            } else {
                this.metrics.addExecutionTime(1L);
                this.metrics.addMemoryAccesses(1L);
            }
        }
        return bestBlock;
    }

    private Block firstFit(long sizeInB) {
        Block block = null;
        block = this.dataStructure.equals((Object)DATA_STRUCTURE.BTREE) ? this.firstFitTree(sizeInB) : this.firstFitList(sizeInB);
        return block;
    }

    private Block firstFitList(long sizeInB) {
        Block block = null;
        int counterForMetrics = 0;
        Iterator<Block> iterator = this.freeBlocks.iterator();
        Block currentBlock = null;
        while (iterator.hasNext()) {
            ++counterForMetrics;
            currentBlock = iterator.next();
            if (currentBlock.sizeInB < sizeInB) continue;
            block = currentBlock;
            iterator.remove();
            break;
        }
        this.metrics.addExecutionTime(counterForMetrics);
        this.metrics.addMemoryAccesses(counterForMetrics);
        if (block != null) {
            if (this.dataStructure.equals((Object)DATA_STRUCTURE.DLL)) {
                this.metrics.addExecutionTime(1L);
                this.metrics.addMemoryAccesses(1L);
            } else if (this.dataStructure.equals((Object)DATA_STRUCTURE.SLL)) {
                this.metrics.addExecutionTime(counterForMetrics);
                this.metrics.addMemoryAccesses(counterForMetrics);
            }
        }
        return block;
    }

    private Block firstFitTree(long sizeInB) {
        Block block = null;
        int counterForMetrics = 0;
        Iterator<Block> iterator = this.freeBlocks.iterator();
        Block currentBlock = null;
        while (iterator.hasNext()) {
            ++counterForMetrics;
            currentBlock = iterator.next();
            if (currentBlock.sizeInB < sizeInB) continue;
            block = currentBlock;
            iterator.remove();
            break;
        }
        this.metrics.addExecutionTime(counterForMetrics);
        this.metrics.addMemoryAccesses(counterForMetrics);
        if (block != null) {
            this.metrics.addExecutionTime(1L);
            this.metrics.addMemoryAccesses(1L);
        }
        return block;
    }

    private Block bestFit(long sizeInB) {
        Block block = null;
        block = this.dataStructure.equals((Object)DATA_STRUCTURE.BTREE) ? this.bestFitTree(sizeInB) : this.bestFitList(sizeInB);
        return block;
    }

    private Block bestFitList(long sizeInB) {
        Block bestBlock = null;
        int bestIndex = -1;
        int counterForMetrics = 0;
        ListIterator iterator = ((LinkedList)this.freeBlocks).listIterator();
        Block currentBlock = null;
        int currentIndex = 0;
        while (iterator.hasNext()) {
            ++counterForMetrics;
            currentIndex = iterator.nextIndex();
            currentBlock = (Block)iterator.next();
            if (currentBlock.sizeInB < sizeInB) continue;
            if (bestBlock == null) {
                bestIndex = currentIndex;
                bestBlock = currentBlock;
                continue;
            }
            if (currentBlock.sizeInB >= bestBlock.sizeInB) continue;
            bestIndex = currentIndex;
            bestBlock = currentBlock;
        }
        if (bestIndex >= 0) {
            ((LinkedList)this.freeBlocks).remove(bestIndex);
        }
        this.metrics.addExecutionTime(counterForMetrics);
        this.metrics.addMemoryAccesses(counterForMetrics);
        if (bestBlock != null) {
            if (this.dataStructure.equals((Object)DATA_STRUCTURE.DLL)) {
                this.metrics.addExecutionTime(1L);
                this.metrics.addMemoryAccesses(1L);
            } else if (this.dataStructure.equals((Object)DATA_STRUCTURE.SLL)) {
                this.metrics.addExecutionTime(counterForMetrics);
                this.metrics.addMemoryAccesses(counterForMetrics);
            }
        }
        return bestBlock;
    }

    private Block bestFitTree(long sizeInB) {
        return this.firstFitTree(sizeInB);
    }

    private Block exactFit(long sizeInB) {
        Block block = null;
        block = this.dataStructure.equals((Object)DATA_STRUCTURE.BTREE) ? this.exactFitTree(sizeInB) : this.exactFitList(sizeInB);
        return block;
    }

    private Block exactFitList(long sizeInB) {
        Block block = null;
        Iterator<Block> iterator = this.freeBlocks.iterator();
        Block currentBlock = null;
        int counterForMetrics = 0;
        while (iterator.hasNext()) {
            ++counterForMetrics;
            currentBlock = iterator.next();
            if (currentBlock.sizeInB != sizeInB) continue;
            block = currentBlock;
            iterator.remove();
            break;
        }
        this.metrics.addExecutionTime(counterForMetrics);
        this.metrics.addMemoryAccesses(counterForMetrics);
        if (block != null) {
            if (this.dataStructure.equals((Object)DATA_STRUCTURE.DLL)) {
                this.metrics.addExecutionTime(1L);
                this.metrics.addMemoryAccesses(1L);
            } else if (this.dataStructure.equals((Object)DATA_STRUCTURE.SLL)) {
                this.metrics.addExecutionTime(counterForMetrics);
                this.metrics.addMemoryAccesses(counterForMetrics);
            }
        }
        return block;
    }

    private Block exactFitTree(long sizeInB) {
        Block block = null;
        Iterator<Block> iterator = this.freeBlocks.iterator();
        Block currentBlock = null;
        int counterForMetrics = 0;
        while (iterator.hasNext()) {
            ++counterForMetrics;
            currentBlock = iterator.next();
            if (currentBlock.sizeInB == sizeInB) {
                block = currentBlock;
                iterator.remove();
                break;
            }
            if (currentBlock.sizeInB <= sizeInB) continue;
        }
        this.metrics.addExecutionTime(counterForMetrics);
        this.metrics.addMemoryAccesses(counterForMetrics);
        if (block != null) {
            this.metrics.addExecutionTime(1L);
            this.metrics.addMemoryAccesses(1L);
        }
        return block;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ALLOCATION_POLICY {
        FIFO,
        LIFO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATA_STRUCTURE {
        SLL,
        DLL,
        BTREE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ALLOCATION_MECHANISM {
        FIRST,
        BEST,
        EXACT,
        FARTHEST;

    }
}

