/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.util.LoggerFormatter;

public class GrammarGenerator {
    public void setLevel(Level level) {
        try {
            FileHandler fh = new FileHandler(this.getClass().getSimpleName() + ".txt", false);
            Logger.getLogger("").addHandler(fh);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
    }

    private void printHelp() {
        System.out.println("Usage:");
        System.out.println("java -jar " + this.getClass().getSimpleName() + ".jar <PathToProfilingReport>");
        System.out.println("where:");
        System.out.println("<ProfilingReport>: Relative path to the profiling report including malloc/free entries");
    }

    public void generateGrammar(String profilePath) throws InterruptedException, IOException {
        ProfilingReport profilingReport = new ProfilingReport(profilePath);
        profilingReport.start();
        profilingReport.join();
        String baseName = null;
        int pos = profilePath.lastIndexOf(".mem");
        baseName = pos < 0 ? profilePath : profilePath.substring(0, pos);
        String grammarPath = baseName + ".bnf";
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(grammarPath)));
        writer.write("<DynamicMemoryManager> ::= <Allocators>\n");
        writer.write("<Allocators> ::= <AllocatorMaxSize>|<AllocatorSize>\n");
        writer.write("<AllocatorSize> ::= <AllocatorClass><AllowSplitting><AllowCoalescing><Size><DataStructure><AllocationMechanism><AllocationPolicy><Allocators>\n");
        writer.write("<AllocatorMaxSize> ::= <AllocatorClass><AllowSplitting><AllowCoalescing><MaxSize><DataStructure><AllocationMechanism><AllocationPolicy>\n");
        writer.write("<AllocatorClass> ::= SegregatedFreeList|SimpleSegregatedStorage|ExactSegregatedFit|BuddySystemBinary|BuddySystemFibonacci\n");
        writer.write("<Size> ::= ");
        TreeSet<Long> sizes = profilingReport.getSizesInB();
        boolean first = true;
        for (Long size : sizes) {
            if (size.longValue() == profilingReport.getMaxSizeInB()) continue;
            if (first) {
                first = false;
            } else {
                writer.write("|");
            }
            writer.write("" + size);
        }
        writer.write("\n");
        writer.write("<MaxSize> ::= " + profilingReport.getMaxSizeInB() + "\n");
        writer.write("<AllowSplitting> ::= true|false\n");
        writer.write("<AllowCoalescing> ::= true|false\n");
        writer.write("<DataStructure> ::= SLL|DLL|BTREE\n");
        writer.write("<AllocationMechanism> ::= FIRST|BEST|EXACT\n");
        writer.write("<AllocationPolicy> ::= FIFO|LIFO\n");
        writer.flush();
        writer.close();
    }

    public static void main(String[] args) {
        GrammarGenerator generator = new GrammarGenerator();
        generator.setLevel(Level.INFO);
        if (args.length != 1) {
            generator.printHelp();
            return;
        }
        try {
            generator.generateGrammar(args[0]);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(GrammarGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GrammarGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

