/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Logger;

public class Metrics {
    private static Logger logger = Logger.getLogger(Metrics.class.getName());
    protected long mallocs = 0L;
    protected long mallocsLost = 0L;
    protected long frees = 0L;
    protected long freesLost = 0L;
    protected long splittings = 0L;
    protected long successSplittings = 0L;
    protected long coalescings = 0L;
    protected long successCoalescings = 0L;
    protected long internalFragmentation = 0L;
    protected long executionTime = 0L;
    private long memoryUsage = 0L;
    protected long maxMemoryUsage = Long.MIN_VALUE;
    protected long memoryAccesses = 0L;
    protected long startTime;
    protected long endTime;
    protected BufferedWriter writer = null;

    public void incMallocs(int inc) {
        this.mallocs += (long)inc;
    }

    public void incMallocsLost(int inc) {
        this.mallocsLost += (long)inc;
    }

    public void incFrees(int inc) {
        this.frees += (long)inc;
    }

    public void incFreesLost(int inc) {
        this.freesLost += (long)inc;
    }

    public void incSplittings(int inc) {
        this.splittings += (long)inc;
    }

    public void incSuccessSplittings(int inc) {
        this.successSplittings += (long)inc;
    }

    public void incCoalescings(int inc) {
        this.coalescings += (long)inc;
    }

    public void incSuccessCoalescings(int inc) {
        this.successCoalescings += (long)inc;
    }

    public void incInternalFragmentation(long inc) {
        this.internalFragmentation += inc;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void open(String tracePath) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(new File(tracePath)));
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public void writeAccess(String access) throws IOException {
        this.writer.write(access + "\n");
    }

    public void addExecutionTime(long inc) {
        this.executionTime += inc;
    }

    public void addMemoryUsage(long inc) {
        this.memoryUsage += inc;
        if (this.memoryUsage > this.maxMemoryUsage) {
            this.maxMemoryUsage = this.memoryUsage;
        }
    }

    public void addMemoryAccesses(long inc) {
        this.memoryAccesses += inc;
    }

    public double computeEnergy() {
        return 0.7 * (double)this.memoryAccesses + 0.2 * (double)this.executionTime + 0.1 * (double)this.maxMemoryUsage;
    }

    public double computeSimulationTime() {
        return 1.0 * (double)(this.endTime - this.startTime) / 1000.0;
    }

    public double computeFitness() {
        return (double)(this.executionTime + this.memoryUsage) + this.computeEnergy();
    }

    public String report() {
        DecimalFormat formatter = new DecimalFormat("0.##E0");
        StringBuffer summary = new StringBuffer();
        String simpleLine = "------------------------------------------------------------------\n";
        String doubleLine = "==================================================================\n";
        summary.append("\n");
        summary.append(doubleLine);
        summary.append("REPORT:\n");
        summary.append(doubleLine);
        summary.append(simpleLine);
        summary.append("MALLOCS:\t");
        summary.append(formatter.format(this.mallocs));
        summary.append("\t\tLOST:\t\t");
        summary.append(formatter.format(this.mallocsLost));
        summary.append("\n");
        summary.append("FREES:\t\t");
        summary.append(formatter.format(this.frees));
        summary.append("\t\tLOST:\t\t");
        summary.append(formatter.format(this.freesLost));
        summary.append("\n");
        summary.append(simpleLine);
        summary.append("SPLITTINGS:\t\t");
        summary.append(formatter.format(this.splittings));
        summary.append("\t\tSUCCESS:\t");
        summary.append(formatter.format(this.successSplittings));
        summary.append("\n");
        summary.append("COALESCINGS:\t");
        summary.append(formatter.format(this.coalescings));
        summary.append("\t\tSUCCESS:\t");
        summary.append(formatter.format(this.successCoalescings));
        summary.append("\n");
        summary.append("INTERNAL FRAGMENTATION:\t" + formatter.format(this.internalFragmentation) + "B");
        summary.append("\n");
        summary.append(simpleLine);
        summary.append("SIMULATION TIME:\t" + formatter.format(this.computeSimulationTime()) + " s");
        summary.append("\nEXECUTION TIME:\t\t" + formatter.format(this.executionTime));
        summary.append("\nMEMORY USAGE:\t\t" + formatter.format(this.maxMemoryUsage) + " B");
        summary.append("\nENERGY:\t\t\t\t" + formatter.format(this.computeEnergy()));
        summary.append("\nFITNESS:\t\t\t" + formatter.format((double)(this.executionTime + this.memoryUsage) + this.computeEnergy()));
        summary.append("\n");
        summary.append(simpleLine);
        return summary.toString();
    }
}

