/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;

public class DMMHeap {
    private static int initialNumerOfBlocks = 2000;
    protected static HashMap<String, DMMBlock> blocks = new HashMap(initialNumerOfBlocks);
    protected static DMMBlock lastBlock = null;

    public static void reset() {
        blocks.clear();
        lastBlock = null;
    }

    public static DMMBlock newBlock(AbstractHeader header, DMMData dataObject, long BlockAddress) {
        DMMBlock block = new DMMBlock(header, dataObject);
        block.setAddress(BlockAddress);
        block.setIndex(blocks.size());
        if (lastBlock != null) {
            lastBlock.setNextInHeap(block);
            block.setPrevInHeap(lastBlock);
            block.setNextInHeap(null);
        } else {
            block.setNextInHeap(null);
            block.setPrevInHeap(null);
        }
        lastBlock = block;
        blocks.put(block.getDataId(), block);
        return block;
    }

    public static DMMBlock freeBlock(String dataId) {
        DMMBlock block = null;
        block = blocks.get(dataId);
        if (block == null) {
            System.err.println("DMMHeap.freeBlock. Try to free an object that doesn't exist. DataId = " + dataId);
        }
        return block;
    }

    public static DMMBlock findBlock(String dataId) {
        DMMBlock block = null;
        block = blocks.get(dataId);
        if (block == null) {
            System.err.println("DMMHeap.findBlock. Try to find an object that doesn't exist. DataId = " + dataId);
        }
        return block;
    }

    public static int getIndex(String dataId) {
        DMMBlock block = null;
        block = blocks.get(dataId);
        if (block == null) {
            System.err.println("DMMHeap.getIndex. Try to get an index of a non exist object. DataId = " + dataId);
            return -1;
        }
        return block.getIndex();
    }

    public static boolean add(DMMBlock block, int index) {
        DMMBlock prev = null;
        DMMBlock next = null;
        if (index > blocks.size()) {
            DMMLogger.addInfinity();
            System.err.println("DMMHeap::add --> The index requested is not in the heap ");
            return false;
        }
        Collection<DMMBlock> blockList = blocks.values();
        Iterator<DMMBlock> iterBlockList = blockList.iterator();
        Boolean found = false;
        while (iterBlockList.hasNext() && !found.booleanValue()) {
            next = iterBlockList.next();
            if (index != next.getIndex()) continue;
            found = true;
        }
        if (index > 0) {
            prev = next.getPrevInHeap();
            prev.setNextInHeap(block);
        }
        block.setPrevInHeap(prev);
        block.setNextInHeap(next);
        if (next != null) {
            next.setPrevInHeap(block);
        }
        block.setIndex(index);
        if (index == blocks.size()) {
            lastBlock = block;
        } else {
            DMMBlock iterBlock = null;
            for (iterBlock = next; iterBlock != null; iterBlock = iterBlock.getNextInHeap()) {
                iterBlock.setIndex(iterBlock.getIndex() + 1);
            }
        }
        blocks.put(block.getDataId(), block);
        return true;
    }

    public static boolean remove(DMMBlock block) {
        DMMBlock findBlock = null;
        String dataId = block.getDataId();
        findBlock = blocks.get(dataId);
        if (findBlock == null) {
            DMMLogger.addInfinity();
            System.err.println("DMMHeap.remove. Try to remove an object that does not exist. DataId = " + dataId);
        } else {
            DMMBlock prevBlock = block.getPrevInHeap();
            DMMBlock nextBlock = block.getNextInHeap();
            if (prevBlock != null) {
                prevBlock.setNextInHeap(nextBlock);
            }
            if (nextBlock != null) {
                nextBlock.setPrevInHeap(prevBlock);
            }
            if (block.equals(lastBlock)) {
                lastBlock = prevBlock;
                prevBlock.setNextInHeap(nextBlock);
            }
            blocks.remove(dataId);
            DMMBlock iterBlock = null;
            for (iterBlock = nextBlock; iterBlock != null; iterBlock = iterBlock.getNextInHeap()) {
                iterBlock.setIndex(iterBlock.getIndex() - 1);
            }
        }
        return findBlock != null;
    }

    public static boolean changeBlocksSlop() {
        boolean done = false;
        DMMBlock last = null;
        DMMBlock newLast = blocks.get(lastBlock.getDataId()).getPrevInHeap();
        if (blocks.size() > 3) {
            int index = blocks.size() - 1;
            last = blocks.remove(lastBlock.getDataId());
            lastBlock = newLast;
            lastBlock.setNextInHeap(null);
            if (DMMHeap.add(last, index -= 2)) {
                done = true;
            }
        }
        return done;
    }

    public static DMMBlock changeBlockId(DMMBlock block, String newId) {
        DMMBlock modifiedBlock = blocks.remove(block.getDataId());
        modifiedBlock.changeId(newId);
        blocks.put(newId, modifiedBlock);
        return modifiedBlock;
    }
}

