/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.combining;

import java.util.logging.Logger;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.layers.AbstractHeap;
import jeco.dmm.simulator.selectors.AbstractSelector;

public class HeapList
extends AbstractHeap {
    private static Logger logger = Logger.getLogger(HeapList.class.getName());
    protected AbstractHeap heap;
    protected AbstractSelector allocSelector;
    protected AbstractSelector freeSelector;
    protected AbstractHeap tail;

    public HeapList(AbstractHeap heap, AbstractSelector allocSelector, AbstractSelector freeSelector, AbstractHeap tail) {
        super(heap.getHeader());
        DMMLogger.updateData(5L, 10L, 4L, 0L);
        DMMLogger.addMemUsedByDMMSupport(4L);
        this.heap = heap;
        this.allocSelector = allocSelector;
        this.freeSelector = freeSelector;
        this.tail = tail;
    }

    public DMMBlock free(DMMData dataObject) {
        logger.fine(this.getClass().getSimpleName() + "::free");
        DMMLogger.updateData(3L, 9L, 0L, 2L);
        boolean canFree = this.freeSelector.getFree(this.heap, dataObject);
        if (canFree) {
            return this.heap.free(dataObject);
        }
        return this.tail.free(dataObject);
    }

    public DMMBlock malloc(DMMData dataObject) {
        logger.fine(this.getClass().getCanonicalName() + "::malloc");
        DMMLogger.updateData(5L, 9L, 0L, 1L);
        boolean canAlloc = this.allocSelector.getMalloc(this.heap, dataObject);
        DMMBlock aux = null;
        if (canAlloc) {
            DMMLogger.updateData(1L, 4L, 0L, 1L);
            aux = this.heap.malloc(dataObject);
        }
        if (aux == null) {
            DMMLogger.updateData(1L, 4L, 0L, 1L);
            aux = this.tail.malloc(dataObject);
        }
        return aux;
    }

    public boolean remove(DMMData dataObject) {
        DMMLogger.updateData(5L, 12L, 0L, 2L);
        boolean canFree = this.freeSelector.getFree(this.heap, dataObject);
        boolean removed = false;
        removed = canFree ? this.heap.remove(dataObject) : this.tail.remove(dataObject);
        return removed;
    }

    public AbstractSelector getAllocSelector() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.allocSelector;
    }

    public void setAllocSelector(AbstractSelector allocSelector) {
        DMMLogger.updateData(1L, 2L, 0L, 0L);
        this.allocSelector = allocSelector;
    }

    public AbstractSelector getFreeSelector() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.freeSelector;
    }

    public void setFreeSelector(AbstractSelector freeSelector) {
        DMMLogger.updateData(1L, 2L, 0L, 0L);
        this.freeSelector = freeSelector;
    }

    public AbstractHeap getTail() {
        return this.tail;
    }

    public void setTail(AbstractHeap tail) {
        this.tail = tail;
    }
}

