/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.freelists;

import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;
import jeco.dmm.simulator.layers.freelists.AbstractFreeList;

public abstract class AbstractDLFreeList
extends AbstractFreeList {
    public AbstractDLFreeList(AbstractHeader header) {
        super(header);
        DMMLogger.updateData(1L, 2L, 0L, 0L);
    }

    public void pushBack(DMMBlock block) {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        if (this.isEmpty()) {
            DMMLogger.updateData(4L, 6L, 0L, 2L);
            this.head = block;
            this.tail = block;
            block.setNext(null);
            block.setPrev(null);
        } else {
            DMMLogger.updateData(4L, 10L, 0L, 3L);
            this.tail.setNext(block);
            block.setPrev(this.tail);
            block.setNext(null);
            this.tail = block;
        }
    }

    public void pushFront(DMMBlock block) {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        if (this.isEmpty()) {
            DMMLogger.updateData(4L, 8L, 0L, 2L);
            this.head = block;
            this.tail = block;
            block.setNext(null);
            block.setPrev(null);
        } else {
            DMMLogger.updateData(4L, 10L, 0L, 3L);
            this.head.setPrev(block);
            block.setNext(this.head);
            block.setPrev(null);
            this.head = block;
        }
    }

    public DMMBlock remove(DMMBlock block) {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        if (this.isEmpty()) {
            System.err.println(this.getClass().getSimpleName() + "::remove --> My list is empty, I cannot remove the block " + block);
            DMMLogger.addInfinity();
            return null;
        }
        if (this.head == this.tail && this.head != block) {
            System.err.println(this.getClass().getSimpleName() + "::remove --> My list contain just one element, I cannot find the block " + block + ". \nThe block looking is " + block.getDataId() + "and in the list there is only " + this.head.getDataId() + "\nComprobaciones. \n -BloqueBuscado.next=" + block.getNext() + "  -BloqueBuscado.prev=" + block.getPrev() + "\n -BloqueDeLaLista.next=" + this.head.getNext() + "  -BloqueDeLaLista.prev=" + this.head.getPrev());
            DMMLogger.addInfinity();
            return null;
        }
        DMMLogger.updateData(6L, 17L, 0L, 2L);
        DMMBlock next = block.getNext();
        DMMBlock prev = block.getPrev();
        if (next != null) {
            DMMLogger.updateData(1L, 3L, 0L, 1L);
            next.setPrev(prev);
        }
        if (prev != null) {
            DMMLogger.updateData(1L, 3L, 0L, 1L);
            prev.setNext(next);
        }
        if (this.head == block) {
            DMMLogger.updateData(1L, 2L, 0L, 0L);
            this.head = next;
        }
        if (this.tail == block) {
            DMMLogger.updateData(1L, 2L, 0L, 0L);
            this.tail = prev;
        }
        block.setNext(null);
        block.setPrev(null);
        return block;
    }

    public boolean removeFromBack(DMMData dataObject) {
        DMMLogger.updateData(2L, 4L, 0L, 1L);
        for (DMMBlock block = this.tail; block != null; block = block.getPrev()) {
            DMMLogger.updateData(1L, 5L, 0L, 2L);
            if (dataObject.getId().equals(block.getDataId())) {
                DMMLogger.updateData(2L, 3L, 0L, 1L);
                this.remove(block);
                return true;
            }
            DMMLogger.updateData(2L, 4L, 0L, 1L);
        }
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return false;
    }

    public boolean removeFromFront(DMMData dataObject) {
        DMMLogger.updateData(2L, 4L, 0L, 1L);
        for (DMMBlock block = this.head; block != null; block = block.getNext()) {
            DMMLogger.updateData(1L, 5L, 0L, 2L);
            if (dataObject.getId().equals(block.getDataId())) {
                DMMLogger.updateData(2L, 3L, 0L, 1L);
                this.remove(block);
                return true;
            }
            DMMLogger.updateData(2L, 4L, 0L, 1L);
        }
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return false;
    }
}

