/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.root;

import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;
import jeco.dmm.simulator.layers.AbstractHeap;

public class FixedHeap
extends AbstractHeap {
    private static Logger logger = Logger.getLogger(FixedHeap.class.getName());
    protected AbstractHeap child;
    protected long memorySizeInBytes;
    protected long memoryUsed;

    public FixedHeap(AbstractHeap child, long memorySizeInKB, AbstractHeader header) {
        super(header);
        DMMLogger.updateData(5L, 14L, 2L, 2L);
        DMMLogger.addMemUsedByDMMSupport(9L);
        this.child = child;
        this.memorySizeInBytes = (long)(Math.pow(2.0, 10.0) * (double)memorySizeInKB);
        DMMData dataObject = new DMMData(null, this.memorySizeInBytes);
        child.malloc(dataObject);
        this.memoryUsed = 0L;
    }

    public DMMBlock free(DMMData dataObject) {
        logger.warning(this.getClass().getSimpleName() + "::free --> This function might not be never reached ");
        DMMLogger.addInfinity();
        return DMMHeap.freeBlock(dataObject.getId());
    }

    public DMMBlock malloc(DMMData dataObject) {
        logger.fine(this.getClass().getCanonicalName() + "::malloc");
        DMMLogger.updateData(2L, 7L, 0L, 2L);
        long dataSizeInBytes = dataObject.getSizeInBytes();
        long totalSizeInBytes = dataSizeInBytes + (long)this.header.getMaxSizeInBytes();
        try {
            int i;
            Class<?> headerClass = this.header.getClass();
            Constructor<?>[] constructors = headerClass.getConstructors();
            for (i = 0; i < constructors.length && constructors[i].getParameterTypes().length != 0; ++i) {
            }
            DMMLogger.updateData(2L, 7L, 0L, 1L);
            Object newHeader = constructors[i].newInstance(new Object[0]);
            if (totalSizeInBytes > this.memorySizeInBytes) {
                DMMLogger.addInfinity();
                logger.warning("\nNo enough memory: " + totalSizeInBytes + "B (allocation) > " + this.memorySizeInBytes + "B (system)");
                return null;
            }
            DMMLogger.updateData(3L, 9L, totalSizeInBytes, 2L);
            DMMLogger.addMemUsedInHeap(totalSizeInBytes);
            DMMBlock block = DMMHeap.newBlock((AbstractHeader)newHeader, dataObject, this.memoryUsed);
            this.memorySizeInBytes -= totalSizeInBytes;
            this.memoryUsed += totalSizeInBytes;
            return block;
        }
        catch (Exception ee) {
            System.err.println(ee.getLocalizedMessage() + "Error in FixedHeap::malloc");
            DMMLogger.addInfinity();
            return null;
        }
    }

    public boolean remove(DMMData dataObject) {
        DMMLogger.updateData(1L, 3L, 0L, 1L);
        return this.child.remove(dataObject);
    }
}

