/*
 * Decompiled with CFR 0.152.
 */
package jeco.gui.attainmentSurface;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jeco.gui.util.TextAreaOutputStream;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.qualityIndicators.AttainmentSurface;

public class AttainmentSurfaceWindow
extends JFrame {
    protected String currentPath;
    private JButton addButton;
    private JList addList;
    private JTextField attNumberTextField;
    private JButton downButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton newButton;
    private JTextField newTextField;
    private JCheckBox normalizeCheckBox;
    private JButton removeButton;
    private JTextField resolutionTextField;
    private JButton runButton;
    private JTextArea textArea;
    private JButton upButton;

    public AttainmentSurfaceWindow() {
        this.initComponents();
        this.addList.setModel(new DefaultListModel());
        super.setTitle("Attainment Surfaces");
        this.currentPath = ".";
        PrintStream out = new PrintStream(new TextAreaOutputStream(this.textArea));
        System.setOut(out);
        System.setErr(out);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.addList = new JList();
        this.jLabel2 = new JLabel();
        this.addButton = new JButton();
        this.jLabel3 = new JLabel();
        this.newTextField = new JTextField();
        this.newButton = new JButton();
        this.runButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.normalizeCheckBox = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.attNumberTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.resolutionTextField = new JTextField();
        this.setDefaultCloseOperation(3);
        this.addList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.addList);
        this.jLabel2.setText("Approximation sets");
        this.addButton.setText("Add...");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttainmentSurfaceWindow.this.addButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Results");
        this.newButton.setText("New ...");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttainmentSurfaceWindow.this.newButtonActionPerformed(evt);
            }
        });
        this.runButton.setText("Run ...");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttainmentSurfaceWindow.this.runButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttainmentSurfaceWindow.this.removeButtonActionPerformed(evt);
            }
        });
        this.upButton.setText("Up");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttainmentSurfaceWindow.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText("Down");
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttainmentSurfaceWindow.this.downButtonActionPerformed(evt);
            }
        });
        this.normalizeCheckBox.setSelected(true);
        this.normalizeCheckBox.setText("Normalize");
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.jScrollPane2.setViewportView(this.textArea);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Attainment Surface Number:");
        this.attNumberTextField.setHorizontalAlignment(0);
        this.attNumberTextField.setText("1");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Resolution:");
        this.resolutionTextField.setHorizontalAlignment(0);
        this.resolutionTextField.setText("24");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -1, 471, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 379, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.normalizeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 74, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 234, -2)).addComponent(this.jLabel4, -2, 140, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.resolutionTextField).addComponent(this.attNumberTextField).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, 86, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -1, 380, Short.MAX_VALUE).addGap(91, 91, 91)).addComponent(this.runButton, GroupLayout.Alignment.TRAILING, -1, 471, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.newTextField, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newButton, -2, 86, -2)).addComponent(this.jScrollPane2, -1, 471, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attNumberTextField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.normalizeCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.resolutionTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newTextField, -2, -1, -2).addComponent(this.newButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 119, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        boolean normalize = this.normalizeCheckBox.isSelected();
        ArrayList<String> pathToDataFiles = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.addList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String filePath = (String)model.get(i);
            pathToDataFiles.add(filePath);
            System.out.println("Data file number " + i + ": " + filePath);
        }
        Integer resolution = Integer.valueOf(this.resolutionTextField.getText());
        Integer attNumber = Integer.valueOf(this.attNumberTextField.getText());
        try {
            AttainmentSurface indicator = new AttainmentSurface(pathToDataFiles, resolution);
            if (normalize) {
                System.out.print("Normalize objective values in the interval [1,2] ... ");
                indicator.normalize();
                System.out.println("done.");
            }
            System.out.print("\nComputing attainment surfaces ... ");
            ArrayList<Solutions> surfacesArray = indicator.extractAttainmentSurface(attNumber);
            System.out.println("done.");
            System.out.println("\nWriting to file ... ");
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.newTextField.getText())));
            for (int i = 0; i < surfacesArray.size(); ++i) {
                Solutions surface = surfacesArray.get(i);
                for (Solution solution : surface) {
                    writer.write(solution.toString() + "\n");
                    System.out.println(solution.toString());
                }
                writer.write("\n");
                System.out.println("");
            }
            writer.flush();
            writer.close();
            System.out.println("FINISHED.");
        }
        catch (Exception ee) {
            System.out.println("Exception: " + ee.getLocalizedMessage());
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        AttainmentSurfaceWindow mainWin = (AttainmentSurfaceWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showSaveDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null) {
            mainWin.newTextField.setText(file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        AttainmentSurfaceWindow mainWin = (AttainmentSurfaceWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showOpenDialog(mainWin);
        File[] files = fc.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file == null || !file.exists()) continue;
            DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
            model.add(model.getSize(), file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        AttainmentSurfaceWindow mainWin = (AttainmentSurfaceWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index >= 0) {
            model.remove(index);
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        AttainmentSurfaceWindow mainWin = (AttainmentSurfaceWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index > 0) {
            int newIndex = index - 1;
            String fileIndex = (String)model.get(index);
            String fileNewIndex = (String)model.get(newIndex);
            model.set(newIndex, fileIndex);
            model.set(index, fileNewIndex);
            mainWin.addList.setSelectedIndex(newIndex);
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        AttainmentSurfaceWindow mainWin = (AttainmentSurfaceWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index < model.getSize() - 1) {
            int newIndex = index + 1;
            String fileIndex = (String)model.get(index);
            String fileNewIndex = (String)model.get(newIndex);
            model.set(newIndex, fileIndex);
            model.set(index, fileNewIndex);
            mainWin.addList.setSelectedIndex(newIndex);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new AttainmentSurfaceWindow().setVisible(true);
            }
        });
    }
}

