/*
 * Decompiled with CFR 0.152.
 */
package jeco.gui.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RefineryUtilities;

public class Scope
extends JFrame {
    private XYSeries serie;
    private XYSeriesCollection dataSet = new XYSeriesCollection();
    private JFreeChart chart;

    public Scope(String topTitle, String title, String xTitle, String yTitle) {
        super(topTitle);
        this.serie = new XYSeries((Comparable)((Object)"data"));
        this.dataSet.addSeries(this.serie);
        this.chart = ChartFactory.createXYLineChart((String)title, (String)xTitle, (String)yTitle, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)new XYStepRenderer());
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane((Container)chartPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Scope.this.dispose();
            }
        });
        super.pack();
        RefineryUtilities.centerFrameOnScreen((Window)this);
        this.setVisible(true);
    }

    public Scope() {
        this("GE", "Results", "Generation", "Fitness");
    }

    public void add(double x, double y) {
        this.serie.add(x, y);
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setXTitle(String title) {
        this.chart.getXYPlot().getDomainAxis().setLabel(title);
    }

    public void setYTitle(String title) {
        this.chart.getXYPlot().getRangeAxis().setLabel(title);
    }
}

