/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm.mopso;

import java.util.ArrayList;
import java.util.Collections;
import jeco.kernel.algorithm.Algorithm;
import jeco.kernel.operator.assigner.CrowdingDistance;
import jeco.kernel.operator.assigner.FrontsExtractor;
import jeco.kernel.operator.comparator.PropertyComparator;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.operator.mutator.NonUniformMutation;
import jeco.kernel.operator.mutator.UniformMutation;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class HNSPSO
extends Algorithm {
    public static final int DEFAULT_NUM_PARTICLES = 100;
    public static final int DEFAULT_T = 250;
    public static final double DEFAULT_W0 = 0.7;
    public static final double DEFAULT_WT = 0.4;
    public static final double DEFAULT_C10 = 2.5;
    public static final double DEFAULT_C1T = 0.5;
    public static final double DEFAULT_C20 = 0.5;
    public static final double DEFAULT_C2T = 2.5;
    public static final double DEFAULT_CHI = 1.0;
    private Double c10;
    private Double c1T;
    private Double c20;
    private Double c2T;
    private double chi;
    private int maxT;
    private int swarmSize;
    private Double w0;
    private Double wT;
    private int t;
    private Solutions swarm;
    private Solutions swarmH;
    private Solutions leaders;
    private SolutionDominance objectivesComparator;
    private CrowdingDistance crowdingDistanceAssigner;
    private PropertyComparator crowdingDistanceComparator;
    private FrontsExtractor frontsExtractor;
    private Solution[] personalBests;
    private Solution[] personalBestsH;
    private double[][] speeds;
    private double[][] speedsH;
    private UniformMutation uniformMutation;
    private NonUniformMutation nonUniformMutation;

    public HNSPSO(Problem problem, int swarmSize, int maxT, double w0, double wT, double c10, double c1T, double c20, double c2T, double chi) {
        super("HNSPSO", problem);
        this.swarmSize = swarmSize;
        this.maxT = maxT;
        this.w0 = w0;
        this.wT = wT;
        this.c10 = c10;
        this.c1T = c1T;
        this.c20 = c20;
        this.c2T = c2T;
        this.chi = chi;
    }

    public HNSPSO(Problem problem, int swarmSize, int maxT, double w0, double wT, double c10, double c1T, double c20, double c2T) {
        this(problem, swarmSize, maxT, w0, wT, c10, c1T, c20, c2T, 1.0);
    }

    public HNSPSO(Problem problem, int swarmSize, int maxT) {
        this(problem, swarmSize, maxT, 0.7, 0.4, 2.5, 0.5, 0.5, 2.5, 1.0);
    }

    public HNSPSO(Problem problem) {
        this(problem, 100, 250, 0.7, 0.4, 2.5, 0.5, 0.5, 2.5, 1.0);
    }

    public void initialize() {
        this.uniformMutation = new UniformMutation(1.0 / (double)this.problem.getNumberOfVariables(), 0.5);
        this.nonUniformMutation = new NonUniformMutation(1.0 / (double)this.problem.getNumberOfVariables(), 0.5, 0, this.maxT);
        this.crowdingDistanceAssigner = new CrowdingDistance(this.problem.getNumberOfObjectives());
        this.crowdingDistanceComparator = new PropertyComparator("crowdingDistance");
        this.swarm = this.problem.newRandomSetOfSolutions(this.swarmSize);
        this.swarmH = this.problem.newRandomSetOfSolutions(this.swarmSize);
        this.leaders = new Solutions();
        this.personalBests = new Solution[this.swarmSize];
        this.personalBestsH = new Solution[this.swarmSize];
        this.speeds = new double[this.swarmSize][this.problem.getNumberOfVariables()];
        this.speedsH = new double[this.swarmSize][this.problem.getNumberOfVariables()];
        this.objectivesComparator = new SolutionDominance();
        this.frontsExtractor = new FrontsExtractor(this.objectivesComparator);
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            particle.setProperty("owner", 0);
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speeds[i][j] = 0.0;
            }
            this.personalBests[i] = particle.clone();
            this.leaders.add(particle.clone());
            Solution particleH = (Solution)this.swarmH.get(i);
            particleH.setProperty("owner", 1);
            this.problem.evaluate(particleH);
            this.problem.evaluateConstraints(particleH);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speedsH[i][j] = 0.0;
            }
            this.personalBestsH[i] = particleH.clone();
            this.leaders.add(particleH.clone());
        }
        this.reduceLeaders(2 * this.swarmSize);
        this.t = 0;
    }

    public Solutions execute() {
        while (this.t < this.maxT) {
            this.step();
        }
        return this.leaders;
    }

    public void step() {
        ++this.t;
        this.computeSpeed();
        this.computeNewPositions();
        this.computeSpeedH();
        this.computeNewPositionsH();
        this.mutation(this.swarmH);
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
            int flag = this.objectivesComparator.compare(particle, this.personalBests[i]);
            if (flag < 0) {
                this.personalBests[i] = particle.clone();
            }
            this.leaders.add(particle.clone());
            this.leaders.add(this.personalBests[i]);
            Solution particleH = (Solution)this.swarmH.get(i);
            this.problem.evaluate(particleH);
            this.problem.evaluateConstraints(particleH);
            flag = this.objectivesComparator.compare(particleH, this.personalBestsH[i]);
            if (flag < 0) {
                this.personalBestsH[i] = particleH.clone();
            }
            this.leaders.add(particleH.clone());
            this.leaders.add(this.personalBestsH[i]);
        }
        this.reduceLeaders(2 * this.swarmSize);
    }

    private void computeSpeed() {
        Solution globalBest = null;
        Solution personalBest = null;
        Solution particle = null;
        this.crowdingDistanceAssigner.execute(this.leaders);
        for (int i = 0; i < this.swarmSize; ++i) {
            particle = (Solution)this.swarm.get(i);
            personalBest = this.personalBests[i];
            int pos1 = RandomGenerator.nextInt(0, this.leaders.size());
            int pos2 = RandomGenerator.nextInt(0, this.leaders.size());
            Solution one = (Solution)this.leaders.get(pos1);
            Solution two = (Solution)this.leaders.get(pos2);
            globalBest = this.crowdingDistanceComparator.compare(two, one) < 1 ? one : two;
            double r1 = RandomGenerator.nextDouble();
            double r2 = RandomGenerator.nextDouble();
            double c1 = RandomGenerator.nextDouble(1.5, 2.0);
            double c2 = RandomGenerator.nextDouble(1.5, 2.0);
            double w = RandomGenerator.nextDouble(0.1, 0.5);
            for (int var = 0; var < this.problem.getNumberOfVariables(); ++var) {
                double pBestValue = (Double)((VariableReal)personalBest.getVariable(var)).getValue();
                double gBesValue = (Double)((VariableReal)globalBest.getVariable(var)).getValue();
                double particleValue = (Double)((VariableReal)particle.getVariable(var)).getValue();
                this.speeds[i][var] = w * this.speeds[i][var] + c1 * r1 * (pBestValue - particleValue) + c2 * r2 * (gBesValue - particleValue);
            }
        }
    }

    private void computeSpeedH() {
        Solutions referenceFront = null;
        Solution globalBest = null;
        Solution personalBest = null;
        Solution particle = null;
        int referenceFrontSize = 0;
        this.crowdingDistanceAssigner.execute(this.leaders);
        this.crowdingDistanceAssigner.execute(this.swarmH);
        ArrayList<Solutions> fronts = this.frontsExtractor.execute(this.swarmH);
        for (int i = 0; i < this.swarmSize; ++i) {
            particle = (Solution)this.swarmH.get(i);
            int referenceFrontIndex = particle.getProperty("rank").intValue() - 1 - 1;
            referenceFront = referenceFrontIndex < 0 || referenceFrontIndex >= fronts.size() ? this.leaders : fronts.get(referenceFrontIndex);
            referenceFrontSize = referenceFront.size();
            int pos1 = RandomGenerator.nextInt(0, referenceFrontSize);
            int pos2 = RandomGenerator.nextInt(0, referenceFrontSize);
            Solution one = (Solution)referenceFront.get(pos1);
            Solution two = (Solution)referenceFront.get(pos2);
            globalBest = this.crowdingDistanceComparator.compare(two, one) < 1 ? one : two;
            double r1 = RandomGenerator.nextDouble();
            double r2 = RandomGenerator.nextDouble();
            double cd = particle.getProperty("crowdingDistance").doubleValue();
            double w = (this.wT - this.w0) * (1.0 * (double)this.t / (double)this.maxT) * Math.exp(-cd) + this.w0 * Math.exp(-cd);
            double c1 = (this.c1T - this.c10) * (1.0 * (double)this.t / (double)this.maxT) + this.c10;
            double c2 = (this.c2T - this.c20) * (1.0 * (double)this.t / (double)this.maxT) + this.c20;
            personalBest = this.personalBestsH[i];
            for (int var = 0; var < this.problem.getNumberOfVariables(); ++var) {
                double pBestValue = (Double)((VariableReal)personalBest.getVariable(var)).getValue();
                double gBesValue = (Double)((VariableReal)globalBest.getVariable(var)).getValue();
                double particleValue = (Double)((VariableReal)particle.getVariable(var)).getValue();
                this.speedsH[i][var] = w * this.speedsH[i][var] + c1 * r1 * (pBestValue - particleValue) + c2 * r2 * (gBesValue - particleValue);
            }
        }
    }

    private void computeNewPositions() {
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            for (int var = 0; var < this.problem.getNumberOfVariables(); ++var) {
                VariableReal variable = (VariableReal)particle.getVariable(var);
                variable.setValue((Double)variable.getValue() + this.chi * this.speeds[i][var]);
                if ((Double)variable.getValue() < (Double)variable.getLowerBound()) {
                    variable.setValue(variable.getLowerBound());
                    this.speeds[i][var] = this.speeds[i][var] * -1.0;
                }
                if (!((Double)variable.getValue() > (Double)variable.getUpperBound())) continue;
                variable.setValue(variable.getUpperBound());
                this.speeds[i][var] = this.speeds[i][var] * -1.0;
            }
        }
    }

    private void computeNewPositionsH() {
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarmH.get(i);
            for (int var = 0; var < this.problem.getNumberOfVariables(); ++var) {
                VariableReal variable = (VariableReal)particle.getVariable(var);
                variable.setValue((Double)variable.getValue() + this.chi * this.speedsH[i][var]);
                if ((Double)variable.getValue() < (Double)variable.getLowerBound()) {
                    variable.setValue(variable.getLowerBound());
                    this.speedsH[i][var] = this.speedsH[i][var] * -1.0;
                }
                if (!((Double)variable.getValue() > (Double)variable.getUpperBound())) continue;
                variable.setValue(variable.getUpperBound());
                this.speedsH[i][var] = this.speedsH[i][var] * -1.0;
            }
        }
    }

    private void mutation(Solutions solutions) {
        this.nonUniformMutation.setCurrentIteration(this.t);
        for (int i = 0; i < this.swarmSize; ++i) {
            if (i % 3 == 0) {
                this.nonUniformMutation.execute((Solution)solutions.get(i));
                continue;
            }
            if (i % 3 != 1) continue;
            this.uniformMutation.execute((Solution)solutions.get(i));
        }
    }

    public void reduceLeaders(int maxSize) {
        this.leaders.keepParetoNonDominated(this.objectivesComparator);
        if (this.leaders.size() <= maxSize) {
            return;
        }
        this.crowdingDistanceAssigner.execute(this.leaders);
        Collections.sort(this.leaders, this.crowdingDistanceComparator);
        while (this.leaders.size() > maxSize) {
            this.leaders.remove(0);
        }
    }

    public void setMaxT(int maxT) {
        this.maxT = maxT;
    }

    public void setSwarmSize(int swarmSize) {
        this.swarmSize = swarmSize;
    }
}

