/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.mutator;

import jeco.kernel.operator.mutator.MutationOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class NonUniformMutation
extends MutationOperator {
    private double perturbationIndex;
    private int maxIterations;
    private int currentIteration;
    protected double probability;

    public NonUniformMutation(double probability, double perturbationIndex, int currentIteration, int maxIterations) {
        this.probability = probability;
        this.perturbationIndex = perturbationIndex;
        this.currentIteration = currentIteration;
        this.maxIterations = maxIterations;
    }

    public Solution execute(Solution solution) {
        Variable[] variables = solution.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            double tmp;
            VariableReal variable = (VariableReal)variables[i];
            if (!(RandomGenerator.nextDouble() < this.probability)) continue;
            double rand = RandomGenerator.nextDouble();
            if (rand <= 0.5) {
                tmp = this.delta((Double)variable.getUpperBound() - (Double)variable.getValue(), this.perturbationIndex);
                tmp += ((Double)variable.getValue()).doubleValue();
            } else {
                tmp = this.delta((Double)variable.getLowerBound() - (Double)variable.getValue(), this.perturbationIndex);
                tmp += ((Double)variable.getValue()).doubleValue();
            }
            if (tmp < (Double)variable.getLowerBound()) {
                tmp = (Double)variable.getLowerBound();
            } else if (tmp > (Double)variable.getUpperBound()) {
                tmp = (Double)variable.getUpperBound();
            }
            variable.setValue(tmp);
        }
        return solution;
    }

    private double delta(double y, double bMutationParameter) {
        double rand = RandomGenerator.nextDouble();
        return y * (1.0 - Math.pow(rand, Math.pow(1.0 - (double)this.currentIteration / (double)this.maxIterations, bMutationParameter)));
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }
}

