/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.mutator;

import jeco.kernel.operator.mutator.MutationOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class UniformMutation
extends MutationOperator {
    protected Double perturbationIndex;
    protected double probability;

    public UniformMutation(double probability, double perturbationIndex) {
        this.perturbationIndex = perturbationIndex;
        this.probability = probability;
    }

    public Solution execute(Solution solution) {
        Variable[] variables = solution.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            VariableReal variable = (VariableReal)variables[i];
            if (!(RandomGenerator.nextDouble() < this.probability)) continue;
            double rand = RandomGenerator.nextDouble();
            double tmp = (rand - 0.5) * this.perturbationIndex;
            if ((tmp += ((Double)variable.getValue()).doubleValue()) < (Double)variable.getLowerBound()) {
                tmp = (Double)variable.getLowerBound();
            } else if (tmp > (Double)variable.getUpperBound()) {
                tmp = (Double)variable.getUpperBound();
            }
            variable.setValue(tmp);
        }
        return solution;
    }
}

