/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.qualityIndicators;

import java.util.ArrayList;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryEpsilon {
    protected int dim;
    protected ArrayList<ArrayList<Solutions>> fronts;
    protected Solutions referenceFront;
    protected ArrayList<ArrayList<Double>> epsilons;
    protected METHOD method;

    public UnaryEpsilon(ArrayList<String> pathsToDataFiles, String pathToReferenceFront, METHOD method) throws Exception {
        this.method = method;
        this.fronts = new ArrayList();
        for (String filePath : pathsToDataFiles) {
            ArrayList<Solutions> temp = Util.readFrontsFromFile(filePath);
            this.fronts.add(temp);
        }
        if (this.fronts.size() <= 0) {
            throw new Exception("The number of files is zero or impossible to read.");
        }
        this.dim = Integer.MAX_VALUE;
        for (int i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Solutions> solutionsSet = this.fronts.get(i);
            if (solutionsSet.size() <= 0) {
                throw new Exception("The number of fronts in the file " + pathsToDataFiles.get(i) + " is zero.");
            }
            int dimAux = ((Solution)solutionsSet.get(0).get(0)).getObjectives().length;
            if (dimAux >= this.dim) continue;
            this.dim = dimAux;
        }
        this.referenceFront = Util.readFrontFromFile(pathToReferenceFront);
    }

    public UnaryEpsilon(ArrayList<String> pathsToDataFiles, String pathToReferenceFront) throws Exception {
        this(pathsToDataFiles, pathToReferenceFront, METHOD.ADDITIVE);
    }

    public void normalize() {
        ArrayList<Solutions> totalSet = new ArrayList<Solutions>();
        for (int i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Solutions> temp = this.fronts.get(i);
            for (Solutions solutions : temp) {
                totalSet.add(solutions);
            }
        }
        totalSet.add(this.referenceFront);
        Util.normalize(totalSet, this.dim);
    }

    public ArrayList<ArrayList<Double>> calculateIndicatorValues() throws Exception {
        this.epsilons = new ArrayList();
        double value = 0.0;
        for (int i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Double> aux = new ArrayList<Double>();
            ArrayList<Solutions> solutionsSet = this.fronts.get(i);
            for (int j = 0; j < solutionsSet.size(); ++j) {
                value = this.calculateIndicatorValue(solutionsSet.get(j));
                aux.add(value);
            }
            this.epsilons.add(aux);
        }
        return this.epsilons;
    }

    private double calculateIndicatorValue(Solutions front) throws Exception {
        double epsJ = 0.0;
        double epsK = 0.0;
        double eps = this.method == METHOD.ADDITIVE ? Double.MIN_VALUE : 0.0;
        for (int i = 0; i < this.referenceFront.size(); ++i) {
            for (int j = 0; j < front.size(); ++j) {
                for (int k = 0; k < this.dim; ++k) {
                    double epsAux;
                    switch (this.method) {
                        case ADDITIVE: {
                            epsAux = ((Solution)front.get(j)).getObjective(k) - ((Solution)this.referenceFront.get(i)).getObjective(k);
                            break;
                        }
                        default: {
                            if (((Solution)this.referenceFront.get(i)).getObjective(k) < 0.0 && ((Solution)front.get(j)).getObjective(k) > 0.0 || ((Solution)this.referenceFront.get(i)).getObjective(k) > 0.0 && ((Solution)front.get(j)).getObjective(k) < 0.0 || ((Solution)this.referenceFront.get(i)).getObjective(k) == 0.0 || ((Solution)front.get(j)).getObjective(k) == 0.0) {
                                throw new Exception("Error in data file");
                            }
                            epsAux = ((Solution)front.get(j)).getObjective(k) / ((Solution)this.referenceFront.get(i)).getObjective(k);
                        }
                    }
                    if (k == 0) {
                        epsK = epsAux;
                        continue;
                    }
                    if (!(epsK < epsAux)) continue;
                    epsK = epsAux;
                }
                if (j == 0) {
                    epsJ = epsK;
                    continue;
                }
                if (!(epsJ > epsK)) continue;
                epsJ = epsK;
            }
            if (i == 0) {
                eps = epsJ;
                continue;
            }
            if (!(eps < epsJ)) continue;
            eps = epsJ;
        }
        return eps;
    }

    public static void main(String[] args) {
        ArrayList<String> dataPaths = new ArrayList<String>();
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.HNSPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.NSGAII");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.NSPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.OMOPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.SPEA2");
        String refPath = "D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.POF";
        try {
            UnaryEpsilon unaryEpsilon = new UnaryEpsilon(dataPaths, refPath);
            ArrayList<ArrayList<Double>> epsilonsSet = unaryEpsilon.calculateIndicatorValues();
            for (int i = 0; i < epsilonsSet.size(); ++i) {
                ArrayList<Double> epsilons = epsilonsSet.get(i);
                System.out.println("Epsilon for:  " + dataPaths.get(i));
                for (Double epsilon : epsilons) {
                    System.out.println(epsilon);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum METHOD {
        ADDITIVE,
        MULTIPLICATIVE;

    }
}

