/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.util;

import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LoggerFormatter
extends Formatter {
    private static final MessageFormat messageFormat = new MessageFormat("[{0}|{1}]({2}): {3} \n");
    public static final LoggerFormatter formatter = new LoggerFormatter();
    protected long startTime = System.currentTimeMillis();

    public String format(LogRecord record) {
        Object[] arguments = new Object[]{record.getLevel(), Thread.currentThread().getName(), this.getElapsedTime(record.getMillis()), record.getMessage()};
        return messageFormat.format(arguments);
    }

    public String getElapsedTime(long currentTime) {
        long elapsedTime = currentTime - this.startTime;
        long elapsedTimeInSeconds = elapsedTime / 1000L;
        String format1 = String.format("%%0%dd", 2);
        String format2 = String.format("%%0%dd", 3);
        String seconds = String.format(format1, elapsedTimeInSeconds % 60L);
        String minutes = String.format(format1, elapsedTimeInSeconds % 3600L / 60L);
        String hours = String.format(format1, elapsedTimeInSeconds / 3600L);
        String millis = String.format(format2, elapsedTime % 1000L);
        String time = hours + ":" + minutes + ":" + seconds + "." + millis;
        return time;
    }
}

