/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.util;

import java.util.Random;

public class RandomGenerator {
    protected static Random randomGenerator = new Random();

    public static void setSeed(long seed) {
        randomGenerator.setSeed(seed);
    }

    public static double nextDouble() {
        return randomGenerator.nextDouble();
    }

    public static double nextDouble(double lowerBound, double upperBound) {
        return lowerBound + (upperBound - lowerBound) * randomGenerator.nextDouble();
    }

    public static int nextInt(int lowerBound, int upperBound) {
        return lowerBound + randomGenerator.nextInt(upperBound - lowerBound);
    }

    public static int nextInteger(int lowerBound, int upperBound) {
        return RandomGenerator.nextInt(lowerBound, upperBound);
    }

    public static int nextInt(int upperBound) {
        return randomGenerator.nextInt(upperBound);
    }

    public static int nextInteger(int upperBound) {
        return RandomGenerator.nextInt(upperBound);
    }

    public static boolean nextBoolean() {
        return randomGenerator.nextBoolean();
    }

    public static int[] intPermutation(int length) {
        int i;
        int[] aux = new int[length];
        int[] result = new int[length];
        for (i = 0; i < length; ++i) {
            result[i] = i;
            aux[i] = RandomGenerator.nextInt(0, length);
        }
        for (i = 0; i < length; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (aux[i] <= aux[j]) continue;
                int tmp = aux[i];
                aux[i] = aux[j];
                aux[j] = tmp;
                tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
        }
        return result;
    }
}

