/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.papers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.SimulatorWithReliabilityV1;
import jeco.dmm.sim2.lib.allocator.BuddySystem;
import jeco.dmm.sim2.lib.allocator.ExactSegregatedFit;
import jeco.dmm.sim2.lib.allocator.Kingsley;
import jeco.dmm.sim2.lib.allocator.SegregatedFreeList;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.util.LoggerFormatter;

public class Dsd2010 {
    private static Logger logger = Logger.getLogger(Dsd2010.class.getName());
    public static final String baseDir = "D:/jlrisco/TrabajoEnRepositorios/MisPapers/genet-algorithm/papers/2010/DSD/results";

    public static void main(String[] args) {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        int index = 0;
        while (index < handlers.length) {
            handlers[index].setFormatter(LoggerFormatter.formatter);
            ++index;
        }
        Dsd2010 dsd2010 = new Dsd2010();
        try {
            dsd2010.runSimulations();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Dsd2010.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Dsd2010.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void runSimulations() throws InterruptedException, IOException {
        String[] pathToProfiles = new String[]{baseDir + File.separator + "boxed-sim.mem", baseDir + File.separator + "espresso.mem", baseDir + File.separator + "gcbench.mem"};
        ProfilingReport[] profilingReport = new ProfilingReport[pathToProfiles.length];
        int i = 0;
        while (i < profilingReport.length) {
            profilingReport[i] = new ProfilingReport(pathToProfiles[i]);
            ++i;
        }
        i = 0;
        while (i < profilingReport.length) {
            profilingReport[i].start();
            ++i;
        }
        i = 0;
        while (i < profilingReport.length) {
            profilingReport[i].join();
            ++i;
        }
        DynamicMemoryManager[] managers = new DynamicMemoryManager[8 * profilingReport.length];
        int i2 = 0;
        while (i2 < profilingReport.length) {
            managers[8 * i2 + 0] = new DynamicMemoryManager(new Kingsley());
            BuddySystem fibonacci1 = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, profilingReport[i2].getMaxSizeInB(), false, false);
            fibonacci1.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i2 + 1] = new DynamicMemoryManager(fibonacci1);
            SegregatedFreeList segregated1 = new SegregatedFreeList(0L, profilingReport[i2].getMaxSizeInB(), false, false);
            ManagersCreator.buildSeveralFreeLists(10, segregated1, FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i2 + 2] = new DynamicMemoryManager(segregated1);
            ExactSegregatedFit exact1 = new ExactSegregatedFit(0L, profilingReport[i2].getMaxSizeInB(), profilingReport[i2].getSizesInB());
            exact1.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i2 + 3] = new DynamicMemoryManager(exact1);
            managers[8 * i2 + 4] = new DynamicMemoryManager(new Kingsley(FreeList.ALLOCATION_MECHANISM.FARTHEST));
            BuddySystem fibonacci2 = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, profilingReport[i2].getMaxSizeInB(), false, false);
            fibonacci2.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FARTHEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i2 + 5] = new DynamicMemoryManager(fibonacci2);
            SegregatedFreeList segregated2 = new SegregatedFreeList(0L, profilingReport[i2].getMaxSizeInB(), false, false);
            ManagersCreator.buildSeveralFreeLists(10, segregated2, FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FARTHEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i2 + 6] = new DynamicMemoryManager(segregated2);
            ExactSegregatedFit exact2 = new ExactSegregatedFit(0L, profilingReport[i2].getMaxSizeInB(), profilingReport[i2].getSizesInB());
            exact2.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FARTHEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i2 + 7] = new DynamicMemoryManager(exact2);
            ++i2;
        }
        Simulator[] simulators = new Simulator[8 * profilingReport.length];
        int i3 = 0;
        while (i3 < profilingReport.length) {
            simulators[8 * i3 + 0] = new Simulator(profilingReport[i3], managers[8 * i3 + 0], String.valueOf(pathToProfiles[i3]) + ".Kingsley.acc");
            simulators[8 * i3 + 1] = new Simulator(profilingReport[i3], managers[8 * i3 + 1], String.valueOf(pathToProfiles[i3]) + ".Fibonacci.acc");
            simulators[8 * i3 + 2] = new Simulator(profilingReport[i3], managers[8 * i3 + 2], String.valueOf(pathToProfiles[i3]) + ".Segregated10.acc");
            simulators[8 * i3 + 3] = new Simulator(profilingReport[i3], managers[8 * i3 + 3], String.valueOf(pathToProfiles[i3]) + ".Exact.acc");
            simulators[8 * i3 + 4] = new SimulatorWithReliabilityV1(profilingReport[i3], managers[8 * i3 + 4], String.valueOf(pathToProfiles[i3]) + ".Kingsley.Farthest.acc");
            simulators[8 * i3 + 5] = new SimulatorWithReliabilityV1(profilingReport[i3], managers[8 * i3 + 5], String.valueOf(pathToProfiles[i3]) + ".Fibonacci.Farthest.acc");
            simulators[8 * i3 + 6] = new SimulatorWithReliabilityV1(profilingReport[i3], managers[8 * i3 + 6], String.valueOf(pathToProfiles[i3]) + ".Segregated10.Farthest.acc");
            simulators[8 * i3 + 7] = new SimulatorWithReliabilityV1(profilingReport[i3], managers[8 * i3 + 7], String.valueOf(pathToProfiles[i3]) + ".Exact.Farthest.acc");
            ++i3;
        }
        i3 = 0;
        while (i3 < 8 * profilingReport.length) {
            simulators[i3].start();
            ++i3;
        }
        i3 = 0;
        while (i3 < 8 * profilingReport.length) {
            simulators[i3].join();
            ++i3;
        }
        i3 = 0;
        while (i3 < profilingReport.length) {
            this.logAndSaveReports(simulators[8 * i3 + 0], String.valueOf(pathToProfiles[i3]) + "Kingsley.map", String.valueOf(pathToProfiles[i3]) + ".Kingsley.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 1], String.valueOf(pathToProfiles[i3]) + "Fibonacci.map", String.valueOf(pathToProfiles[i3]) + ".Fibonacci.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 2], String.valueOf(pathToProfiles[i3]) + "Segregated10.map", String.valueOf(pathToProfiles[i3]) + ".Segregated10.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 3], String.valueOf(pathToProfiles[i3]) + "Exact.map", String.valueOf(pathToProfiles[i3]) + ".Exact.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 4], String.valueOf(pathToProfiles[i3]) + "Kingsley.Farthest.map", String.valueOf(pathToProfiles[i3]) + ".Kingsley.Farthest.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 5], String.valueOf(pathToProfiles[i3]) + "Fibonacci.Farthest.map", String.valueOf(pathToProfiles[i3]) + ".Fibonacci.Farthest.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 6], String.valueOf(pathToProfiles[i3]) + "Segregated10.Farthest.map", String.valueOf(pathToProfiles[i3]) + ".Segregated10.Farthest.mtr");
            this.logAndSaveReports(simulators[8 * i3 + 7], String.valueOf(pathToProfiles[i3]) + "Exact.Farthest.map", String.valueOf(pathToProfiles[i3]) + ".Exact.Farthest.mtr");
            ++i3;
        }
    }

    public void logAndSaveReports(Simulator simulator, String mapPath, String metrPath) throws IOException {
        String mapAsString = simulator.drawAllocatorMap();
        String reportAsString = simulator.getMetrics().report();
        logger.info(mapAsString);
        logger.info(reportAsString);
        BufferedWriter writer = null;
        logger.info("Saving map ...");
        writer = new BufferedWriter(new FileWriter(new File(mapPath)));
        writer.write(mapAsString);
        writer.flush();
        writer.close();
        logger.info("Saving metrics ...");
        writer = new BufferedWriter(new FileWriter(new File(metrPath)));
        writer.write(reportAsString);
        writer.flush();
        writer.close();
        logger.info("DONE.");
    }
}

