/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.papers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import jeco.kernel.algorithm.Algorithm;
import jeco.kernel.algorithm.moga.NSGAII;
import jeco.kernel.algorithm.moga.SPEA2;
import jeco.kernel.algorithm.mopso.HNSPSO;
import jeco.kernel.algorithm.mopso.NSPSO;
import jeco.kernel.algorithm.mopso.OMOPSO;
import jeco.kernel.operator.crossover.SBXCrossover;
import jeco.kernel.operator.mutator.PolynomialMutation;
import jeco.kernel.operator.selector.BinaryTournament;
import jeco.kernel.operator.selector.BinaryTournamentNSGAII;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solutions;
import jeco.lib.problems.dtlz.DTLZ2;
import jeco.lib.problems.dtlz.DTLZ5;
import jeco.lib.problems.dtlz.DTLZ7;
import jeco.lib.problems.zdt.ZDT1;
import jeco.lib.problems.zdt.ZDT2;
import jeco.lib.problems.zdt.ZDT3;
import jeco.lib.problems.zdt.ZDT4;

public class TransOnEvolutionaryComputation2008 {
    protected int mode;
    protected int numTrials;
    protected int numPoints;
    protected String outDir;
    protected ArrayList<Problem> problems;
    protected ArrayList<Algorithm> algorithms;

    public static void main(String[] args) {
        int numTrials = 1;
        int mode = 0;
        int numPoints = 5000;
        String outDir = ".";
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println("java -jar EvolutionaryComputation2008.jar <-m m> [-o .] [-p 5000] [-n 1]");
            System.out.println("Option -m: mode");
            System.out.println("-m 0 --> Generate POFs (no -n required)");
            System.out.println("-m 1 --> Generate PFs (option -n required)");
            System.out.println("Option -o: output directory");
            System.out.println("example       --> -o /home/user/example");
            System.out.println("default value --> .");
            System.out.println("Option -p: number of pareto-optimal points");
            System.out.println("example       --> -p 10000");
            System.out.println("default value --> 5000");
            System.out.println("Option -n: number of trials");
            System.out.println("example       --> -n 30");
            System.out.println("default value --> 1");
            return;
        }
        for (int i = 0; i < args.length / 2; ++i) {
            String option = args[2 * i];
            if (option.equals("-m")) {
                mode = Integer.valueOf(args[2 * i + 1]);
                continue;
            }
            if (option.equals("-o")) {
                outDir = args[2 * i + 1];
                continue;
            }
            if (option.equals("-p")) {
                numPoints = Integer.valueOf(args[2 * i + 1]);
                continue;
            }
            if (!option.equals("-n")) continue;
            numTrials = Integer.valueOf(args[2 * i + 1]);
        }
        try {
            TransOnEvolutionaryComputation2008 evo = new TransOnEvolutionaryComputation2008(mode, outDir, numPoints, numTrials);
            evo.execute();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public TransOnEvolutionaryComputation2008(int mode, String outDir, int numPoints, int maxTrials) {
        this.mode = mode;
        this.numPoints = numPoints;
        this.numTrials = maxTrials;
        this.outDir = outDir;
    }

    public void execute() throws Exception {
        if (this.mode == 0) {
            this.executeMode0();
        } else if (this.mode == 1) {
            this.executeMode1();
        }
    }

    public void executeMode0() throws Exception {
        this.initialize();
        String filePath = null;
        for (int i = 0; i < this.problems.size(); ++i) {
            System.out.print("Calulating POF for " + this.problems.get(i).getName() + " ... ");
            Solutions sols = this.problems.get(i).computeParetoOptimalFront(this.numPoints);
            filePath = this.outDir + File.separator + this.problems.get(i).getName() + ".POF." + sols.size();
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filePath)));
            writer.write(sols.toString());
            writer.flush();
            writer.close();
            System.out.println("done.");
        }
    }

    public void executeMode1() throws Exception {
        this.initialize();
        String filePath = null;
        for (int i = 0; i < this.problems.size(); ++i) {
            for (int j = 0; j < this.algorithms.size(); ++j) {
                filePath = this.outDir + File.separator + this.problems.get(i).getName() + "." + this.algorithms.get(j).getName();
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filePath)));
                for (int k = 0; k < this.numTrials; ++k) {
                    System.out.print("Running " + this.algorithms.get(j).getName() + " on " + this.problems.get(i).getName() + ", (" + (k + 1) + "/" + this.numTrials + ") ... ");
                    this.initializeAlgorithm(j, this.problems.get(i));
                    this.algorithms.get(j).initialize();
                    Solutions sols = this.algorithms.get(j).execute();
                    writer.write(sols.toString());
                    writer.write("\n");
                    System.out.println("done.");
                    writer.flush();
                }
                writer.flush();
                writer.close();
            }
        }
    }

    public void initialize() {
        this.problems = new ArrayList();
        this.problems.add(new ZDT1(30));
        this.problems.add(new ZDT2(30));
        this.problems.add(new ZDT3(30));
        this.problems.add(new ZDT4(10));
        this.problems.add(new DTLZ2(12));
        this.problems.add(new DTLZ5(12));
        this.problems.add(new DTLZ7(22));
        HNSPSO hnspso = new HNSPSO(null, 100, 250);
        NSGAII nsgaii = new NSGAII(null, 100, 250, null, null, null);
        NSPSO nspso = new NSPSO(null, 100, 250, 0.4, 2.0, 2.0);
        OMOPSO omopso = new OMOPSO(null, 100, 250, 0.5);
        SPEA2 spea2 = new SPEA2(null, 100, 250, null, null, null);
        this.algorithms = new ArrayList();
        this.algorithms.add(hnspso);
        this.algorithms.add(nsgaii);
        this.algorithms.add(nspso);
        this.algorithms.add(omopso);
        this.algorithms.add(spea2);
    }

    public void initializeAlgorithm(int i, Problem problem) {
        Algorithm algorithm = this.algorithms.get(i);
        algorithm.setProblem(problem);
        if (algorithm.getClass().getName().equals(NSGAII.class.getName())) {
            NSGAII nsgaii = (NSGAII)algorithm;
            nsgaii.setMutationOperator(new PolynomialMutation(20.0, 1.0 / (double)problem.getNumberOfVariables()));
            nsgaii.setCrossoverOperator(new SBXCrossover());
            nsgaii.setSelectionOperator(new BinaryTournamentNSGAII());
        } else if (algorithm.getClass().getName().equals(SPEA2.class.getName())) {
            SPEA2 spea2 = (SPEA2)algorithm;
            spea2.setMutationOperator(new PolynomialMutation(20.0, 1.0 / (double)problem.getNumberOfVariables()));
            spea2.setCrossoverOperator(new SBXCrossover());
            spea2.setSelectionOperator(new BinaryTournament());
        }
    }
}

