/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.combinatorial;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TSP
extends Problem {
    private static Logger logger = Logger.getLogger(TSP.class.getName());
    public int numberOfCities;
    public double[][] distanceMatrix;
    public ArrayList<String> cityNames;

    public TSP(String xmlFilePath) {
        super("TSP", 1, 1);
        try {
            this.readProblem(xmlFilePath);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void evaluate(Solution solution) {
        double fitness = 0.0;
        for (int i = 0; i < this.numberOfCities - 1; ++i) {
            int x = (Integer)((VariableInteger)solution.getVariable(i)).getValue();
            int y = (Integer)((VariableInteger)solution.getVariable(i + 1)).getValue();
            fitness += this.distanceMatrix[x][y];
        }
        int firstCity = (Integer)((VariableInteger)solution.getVariable(0)).getValue();
        int lastCity = (Integer)((VariableInteger)solution.getVariable(this.numberOfCities - 1)).getValue();
        solution.setObjective(0, fitness += this.distanceMatrix[firstCity][lastCity]);
    }

    public void readProblem(String xmlFilePath) throws Exception {
        Document xmlTspModel = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(xmlFilePath));
        Element xmlTsp = (Element)xmlTspModel.getElementsByTagName("tsp").item(0);
        HashSet<String> cityNamesAsSet = new HashSet<String>();
        NodeList xmlDistances = xmlTsp.getElementsByTagName("distance");
        for (int i = 0; i < xmlDistances.getLength(); ++i) {
            Element xmlDistance = (Element)xmlDistances.item(i);
            cityNamesAsSet.add(xmlDistance.getAttribute("from"));
            cityNamesAsSet.add(xmlDistance.getAttribute("to"));
        }
        this.numberOfCities = cityNamesAsSet.size();
        this.distanceMatrix = new double[this.numberOfCities][this.numberOfCities];
        this.cityNames = new ArrayList();
        int counter = 0;
        HashMap<String, Integer> cityIndexes = new HashMap<String, Integer>();
        for (String cityName : cityNamesAsSet) {
            cityIndexes.put(cityName, counter++);
            this.cityNames.add(cityName);
        }
        for (int i = 0; i < xmlDistances.getLength(); ++i) {
            Element xmlDistance = (Element)xmlDistances.item(i);
            String cityFrom = xmlDistance.getAttribute("from");
            Integer indexFrom = (Integer)cityIndexes.get(cityFrom);
            String cityTo = xmlDistance.getAttribute("to");
            Integer indexTo = (Integer)cityIndexes.get(cityTo);
            Double distance = Double.valueOf(xmlDistance.getAttribute("distance"));
            this.distanceMatrix[indexFrom.intValue()][indexTo.intValue()] = distance;
        }
    }

    public Solutions newRandomSetOfSolutions(int size) {
        logger.severe("Method not implemented");
        return null;
    }

    public Solutions computeParetoOptimalFront(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

