/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.dtlz;

import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableReal;
import jeco.lib.problems.dtlz.DTLZ;

public class DTLZ2
extends DTLZ {
    public DTLZ2(Integer numberOfVariables) {
        super("DTLZ2", numberOfVariables);
        for (int i = 0; i < numberOfVariables; ++i) {
            this.lowerBound[i] = 0.0;
            this.upperBound[i] = 1.0;
        }
    }

    public DTLZ2() {
        this(12);
    }

    public void evaluate(Solution solution) {
        int i;
        Variable[] variables = solution.getVariables();
        int k = this.numberOfVariables - this.numberOfObjectives + 1;
        double f = 0.0;
        double g = 0.0;
        for (i = this.numberOfVariables - k + 1; i <= this.numberOfVariables; ++i) {
            g += Math.pow((Double)((VariableReal)variables[i - 1]).getValue() - 0.5, 2.0);
        }
        for (i = 1; i <= this.numberOfObjectives; ++i) {
            f = 1.0 + g;
            for (int j = this.numberOfObjectives - i; j >= 1; --j) {
                f *= Math.cos((Double)((VariableReal)variables[j - 1]).getValue() * Math.PI / 2.0);
            }
            if (i > 1) {
                f *= Math.sin((Double)((VariableReal)variables[this.numberOfObjectives - i]).getValue() * Math.PI / 2.0);
            }
            solution.setObjective(i - 1, f);
        }
    }

    public Solutions computeParetoOptimalFront(int n) {
        int num = (int)Math.sqrt(n);
        Solutions result = new Solutions();
        for (int i = 0; i < num; ++i) {
            double x0 = 0.0 + 1.0 * (double)i / (double)(num - 1);
            for (int j = 0; j < num; ++j) {
                Solution sol = new Solution(this);
                double x1 = 0.0 + 1.0 * (double)j / (double)(num - 1);
                sol.getVariable(0).setValue(x0);
                sol.getVariable(1).setValue(x1);
                for (int k = 2; k < this.numberOfVariables; ++k) {
                    sol.getVariable(k).setValue(0.5);
                }
                this.evaluate(sol);
                result.add(sol);
            }
        }
        result.keepParetoNonDominated(new SolutionDominance());
        return result;
    }
}

