/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import jeco.kernel.operator.crossover.CrossoverOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.VariableBinary;
import jeco.kernel.util.RandomGenerator;

public class LiquidChannelsCrossover
extends CrossoverOperator {
    protected double probability;
    protected int maxNumLcs;

    public LiquidChannelsCrossover(double probability, int maxNumLcs) {
        this.probability = probability;
        this.maxNumLcs = maxNumLcs;
    }

    public Solution[] execute(Solution parent1, Solution parent2) {
        int i;
        Solution child1 = parent1.clone();
        Solution child2 = parent2.clone();
        int idx = RandomGenerator.nextInt(parent1.getVariables().length);
        int numLcsInChild1 = 0;
        int numLcsInChild2 = 0;
        for (i = 0; i <= idx; ++i) {
            if (((Boolean)((VariableBinary)child1.getVariable(i)).getValue()).booleanValue()) {
                ++numLcsInChild1;
            }
            if (!((Boolean)((VariableBinary)child2.getVariable(i)).getValue()).booleanValue()) continue;
            ++numLcsInChild2;
        }
        for (i = idx + 1; i < parent1.getVariables().length; ++i) {
            VariableBinary varPar1 = (VariableBinary)parent1.getVariable(i).clone();
            VariableBinary varPar2 = (VariableBinary)parent2.getVariable(i).clone();
            if (numLcsInChild1 >= this.maxNumLcs) {
                varPar2.setValue(Boolean.FALSE);
            } else if (((Boolean)varPar2.getValue()).booleanValue()) {
                ++numLcsInChild1;
            }
            child1.setVariable(i, varPar2);
            if (numLcsInChild2 >= this.maxNumLcs) {
                varPar1.setValue(Boolean.FALSE);
            } else if (((Boolean)varPar1.getValue()).booleanValue()) {
                ++numLcsInChild2;
            }
            child2.setVariable(i, varPar1);
        }
        while (numLcsInChild1 < this.maxNumLcs) {
            idx = RandomGenerator.nextInt(child1.getVariables().length);
            VariableBinary variable = (VariableBinary)child1.getVariable(idx);
            if (((Boolean)variable.getValue()).booleanValue()) continue;
            variable.setValue(Boolean.TRUE);
            ++numLcsInChild1;
        }
        while (numLcsInChild2 < this.maxNumLcs) {
            idx = RandomGenerator.nextInt(child2.getVariables().length);
            VariableBinary variable = (VariableBinary)child2.getVariable(idx);
            if (((Boolean)variable.getValue()).booleanValue()) continue;
            variable.setValue(Boolean.TRUE);
            ++numLcsInChild2;
        }
        Solution[] offspring = new Solution[]{child1, child2};
        return offspring;
    }
}

