/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.zdt;

import java.util.logging.Logger;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableReal;
import jeco.lib.problems.zdt.ZDT;

public class ZDT6
extends ZDT {
    private static Logger logger = Logger.getLogger(ZDT6.class.getName());

    public ZDT6(Integer numberOfVariables) {
        super("ZDT6", numberOfVariables);
        for (int i = 0; i < numberOfVariables; ++i) {
            this.lowerBound[i] = 0.0;
            this.upperBound[i] = 1.0;
        }
    }

    public ZDT6() {
        this(10);
    }

    public void evaluate(Solution solution) {
        VariableReal[] variables = (VariableReal[])solution.getVariables();
        double x0 = (Double)variables[0].getValue();
        double f1 = 1.0 - Math.exp(-4.0 * x0) * Math.pow(Math.sin(Math.PI * 6 * x0), 6.0);
        double g = 0.0;
        for (int j = 1; j < this.numberOfVariables; ++j) {
            g += ((Double)variables[j].getValue()).doubleValue();
        }
        g /= (double)(this.numberOfVariables - 1);
        g = Math.pow(g, 0.25);
        g *= 9.0;
        double h = 1.0 - f1 / (g += 1.0) * (f1 / g);
        solution.setObjective(0, f1);
        solution.setObjective(1, g * h);
    }

    public Solutions computeParetoOptimalFront(int n) {
        logger.severe("This function is not finished");
        return null;
    }
}

