/*
 * Decompiled with CFR 0.152.
 */
package moea.commons.examples;

import ext.number.ValReal;
import ext.number.Value;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collections;
import moea.commons.Entity;
import moea.commons.Individual;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.commons.comparator.ComparatorObjective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFunction<I extends Individual>
extends Individual {
    public static KindOfTestFunction kindOfTestFunction;

    public TestFunction() {
    }

    public TestFunction(String[] args) {
        Value[] xLTemp = null;
        Value[] xUTemp = null;
        if (args[0].equals("ZDT1")) {
            kindOfTestFunction = KindOfTestFunction.ZDT1;
        } else if (args[0].equals("ZDT2")) {
            kindOfTestFunction = KindOfTestFunction.ZDT2;
        } else if (args[0].equals("ZDT3")) {
            kindOfTestFunction = KindOfTestFunction.ZDT3;
        } else if (args[0].equals("ZDT4")) {
            kindOfTestFunction = KindOfTestFunction.ZDT4;
        } else if (args[0].equals("DTLZ2")) {
            kindOfTestFunction = KindOfTestFunction.DTLZ2;
        } else if (args[0].equals("DTLZ5")) {
            kindOfTestFunction = KindOfTestFunction.DTLZ5;
        } else if (args[0].equals("DTLZ7")) {
            kindOfTestFunction = KindOfTestFunction.DTLZ7;
        }
        switch (kindOfTestFunction) {
            case ZDT1: 
            case ZDT2: 
            case ZDT3: {
                N = 2;
                M = 30;
                xLTemp = new Value[M];
                xUTemp = new Value[M];
                for (int i = 0; i < M; ++i) {
                    xLTemp[i] = new ValReal(0.0);
                    xUTemp[i] = new ValReal(1.0);
                }
                break;
            }
            case ZDT4: {
                N = 2;
                M = 10;
                xLTemp = new Value[M];
                xUTemp = new Value[M];
                xLTemp[0] = new ValReal(0.0);
                xUTemp[0] = new ValReal(1.0);
                for (int i = 1; i < M; ++i) {
                    xLTemp[i] = new ValReal(-5.0);
                    xUTemp[i] = new ValReal(5.0);
                }
                break;
            }
            case ZDT6: {
                N = 2;
                M = 10;
                xLTemp = new Value[M];
                xUTemp = new Value[M];
                for (int i = 0; i < M; ++i) {
                    xLTemp[i] = new ValReal(0.0);
                    xUTemp[i] = new ValReal(1.0);
                }
                break;
            }
            case DTLZ2: {
                N = 3;
                M = 12;
                xLTemp = new Value[M];
                xUTemp = new Value[M];
                for (int i = 0; i < M; ++i) {
                    xLTemp[i] = new ValReal(0.0);
                    xUTemp[i] = new ValReal(1.0);
                }
                break;
            }
            case DTLZ5: {
                N = 3;
                M = 12;
                xLTemp = new Value[M];
                xUTemp = new Value[M];
                for (int i = 0; i < M; ++i) {
                    xLTemp[i] = new ValReal(0.0);
                    xUTemp[i] = new ValReal(1.0);
                }
                break;
            }
            case DTLZ7: {
                N = 3;
                M = 22;
                xLTemp = new Value[M];
                xUTemp = new Value[M];
                for (int i = 0; i < M; ++i) {
                    xLTemp[i] = new ValReal(0.0);
                    xUTemp[i] = new ValReal(1.0);
                }
                break;
            }
        }
        xL = xLTemp;
        xU = xUTemp;
    }

    @Override
    public void evaluate() {
    }

    public void evaluateFunction(Value[] x, ObjectiveVector objs) {
        for (int i = 0; i < N; ++i) {
            objs.set(i, 0.0);
        }
        int k = M - N + 1;
        double f1 = 0.0;
        double g = 0.0;
        double h = 0.0;
        switch (kindOfTestFunction) {
            case ZDT1: {
                f1 = x[0].getValue().doubleValue();
                g = 0.0;
                for (int j = 1; j < M; ++j) {
                    g += x[j].getValue().doubleValue();
                }
                g /= (double)(M - 1);
                g *= 9.0;
                h = 1.0 - Math.sqrt(f1 / (g += 1.0));
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT2: {
                f1 = x[0].getValue().doubleValue();
                g = 0.0;
                for (int j = 1; j < M; ++j) {
                    g += x[j].getValue().doubleValue();
                }
                g /= (double)(M - 1);
                g *= 9.0;
                h = 1.0 - f1 / (g += 1.0) * (f1 / g);
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT3: {
                f1 = x[0].getValue().doubleValue();
                g = 0.0;
                for (int j = 1; j < M; ++j) {
                    g += x[j].getValue().doubleValue();
                }
                g /= (double)(M - 1);
                g *= 9.0;
                h = 1.0 - Math.sqrt(f1 / (g += 1.0)) - f1 / g * Math.sin(Math.PI * 10 * f1);
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT4: {
                f1 = x[0].getValue().doubleValue();
                g = 0.0;
                for (int j = 1; j < M; ++j) {
                    g += x[j].getValue().doubleValue() * x[j].getValue().doubleValue() - 10.0 * Math.cos(Math.PI * 4 * x[j].getValue().doubleValue());
                }
                h = 1.0 - Math.sqrt(f1 / (g += (double)(1 + 10 * (M - 1))));
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT6: {
                f1 = 1.0 - Math.exp(-4.0 * x[0].getValue().doubleValue()) * Math.pow(Math.sin(Math.PI * 6 * x[0].getValue().doubleValue()), 6.0);
                g = 0.0;
                for (int j = 1; j < M; ++j) {
                    g += x[j].getValue().doubleValue();
                }
                g /= (double)(M - 1);
                g = Math.pow(g, 0.25);
                g *= 9.0;
                h = 1.0 - f1 / (g += 1.0) * (f1 / g);
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case DTLZ2: {
                int i;
                for (i = M - k + 1; i <= M; ++i) {
                    g += Math.pow(x[i - 1].getValue().doubleValue() - 0.5, 2.0);
                }
                for (i = 1; i <= N; ++i) {
                    double f = 1.0 + g;
                    for (int j = N - i; j >= 1; --j) {
                        f *= Math.cos(x[j - 1].getValue().doubleValue() * Math.PI / 2.0);
                    }
                    if (i > 1) {
                        f *= Math.sin(x[N - i].getValue().doubleValue() * Math.PI / 2.0);
                    }
                    objs.set(i - 1, f);
                }
                break;
            }
            case DTLZ5: {
                int i;
                double[] theta = new double[N];
                for (int i2 = M - k + 1; i2 <= M; ++i2) {
                    g += Math.pow(x[i2 - 1].getValue().doubleValue() - 0.5, 2.0);
                }
                double t = Math.PI / (4.0 * (1.0 + g));
                theta[0] = x[0].getValue().doubleValue() * Math.PI / 2.0;
                for (i = 2; i <= N - 1; ++i) {
                    theta[i - 1] = t * (1.0 + 2.0 * g * x[i - 1].getValue().doubleValue());
                }
                for (i = 1; i <= N; ++i) {
                    double f = 1.0 + g;
                    for (int j = N - i; j >= 1; --j) {
                        f *= Math.cos(theta[j - 1]);
                    }
                    if (i > 1) {
                        f *= Math.sin(theta[N - i]);
                    }
                    objs.set(i - 1, f);
                }
                break;
            }
            case DTLZ7: {
                int i;
                for (i = M - k + 1; i <= M; ++i) {
                    g += x[i - 1].getValue().doubleValue();
                }
                g = 1.0 + 9.0 * g / (double)k;
                for (i = 1; i <= N - 1; ++i) {
                    objs.set(i - 1, x[i - 1].getValue().doubleValue());
                }
                h = 0.0;
                for (int j = 1; j <= N - 1; ++j) {
                    h += x[j - 1].getValue().doubleValue() / (1.0 + g) * (1.0 + Math.sin(Math.PI * 3 * x[j - 1].getValue().doubleValue()));
                }
                h = (double)N - h;
                objs.set(N - 1, (1.0 + g) * h);
            }
        }
    }

    @Override
    public ObjectiveVector getObjectiveVector() {
        this.evaluateFunction(this.x, this.objectiveVector);
        return this.objectiveVector;
    }

    public Population<TestFunction<I>> loadParetoOptimalFront(String filePath) throws Exception {
        Population<TestFunction<I>> paretoOptimalFront = new Population<TestFunction<I>>();
        BufferedReader reader = new BufferedReader(new FileReader(new File(filePath)));
        String line = reader.readLine();
        while (line != null) {
            String[] parts = line.split(" ");
            TestFunction<I> p = new TestFunction<I>();
            for (int i = 0; i < N; ++i) {
                Double objValue = Double.valueOf(parts[i]);
                p.objectiveVector.set(i, objValue);
            }
            p.scoresValid = true;
            paretoOptimalFront.add(p);
            line = reader.readLine();
        }
        reader.close();
        return paretoOptimalFront;
    }

    public Population<TestFunction<I>> generateParetoOptimalFront(int num) {
        int i;
        Population<TestFunction<I>> paretoOptimalFront = new Population<TestFunction<I>>();
        for (i = 0; i < num; ++i) {
            paretoOptimalFront.add(new TestFunction<I>());
        }
        block4: for (i = 0; i < num; ++i) {
            TestFunction p = (TestFunction)paretoOptimalFront.get(i);
            switch (kindOfTestFunction) {
                case ZDT1: 
                case ZDT2: 
                case ZDT3: 
                case ZDT4: {
                    ValReal temp = new ValReal(xL[0].getValue().doubleValue() + (double)i * ((xU[0].getValue().doubleValue() - xL[0].getValue().doubleValue()) / (double)(num - 1)));
                    p.x[0] = temp;
                    for (int j = 1; j < M; ++j) {
                        p.x[j] = new ValReal(0.0);
                    }
                    continue block4;
                }
            }
        }
        paretoOptimalFront.keepNonDominated();
        return paretoOptimalFront;
    }

    public double calculateGenerationalDistance(Population<I> pop, Population<TestFunction<I>> pof) {
        double res = 0.0;
        for (Individual p1 : pop) {
            double minDistance = Double.MAX_VALUE;
            double curDistance = 0.0;
            ObjectiveVector objs1 = p1.getObjectiveVector();
            for (TestFunction testFunction : pof) {
                ObjectiveVector objs2 = testFunction.getObjectiveVector();
                curDistance = 0.0;
                for (int i = 0; i < Entity.N; ++i) {
                    curDistance += ((Double)objs1.get(i) - (Double)objs2.get(i)) * ((Double)objs1.get(i) - (Double)objs2.get(i));
                }
                if (!((curDistance = Math.sqrt(curDistance)) < minDistance)) continue;
                minDistance = curDistance;
            }
            res += Math.pow(minDistance, Entity.N);
        }
        res = Math.pow(res, 1.0 / (double)Entity.N);
        return res /= (double)pop.size();
    }

    public double calculateDiversity(Population<I> pop, Population<TestFunction<I>> pof) {
        double res = 0.0;
        double dem = 0.0;
        for (int i = 0; i < N; ++i) {
            Collections.sort(pop, ComparatorObjective.getInstance(i));
            Collections.sort(pof, ComparatorObjective.getInstance(i));
            dem += Math.abs((Double)((Individual)pop.get(pop.size() - 1)).getObjectiveVector().get(i) - (Double)((TestFunction)pof.get(pof.size() - 1)).getObjectiveVector().get(i));
        }
        double[] di = new double[pop.size()];
        for (int i = 0; i < pop.size(); ++i) {
            Individual pI = (Individual)pop.get(i);
            ObjectiveVector objI = pI.getObjectiveVector();
            double minDistance = Double.MAX_VALUE;
            double curDistance = 0.0;
            for (int j = 0; j < pop.size(); ++j) {
                if (i == j) continue;
                Individual pJ = (Individual)pop.get(j);
                ObjectiveVector objJ = pJ.getObjectiveVector();
                curDistance = 0.0;
                for (int k = 0; k < N; ++k) {
                    curDistance += Math.abs((Double)objI.get(k) - (Double)objJ.get(k));
                }
                if (!(curDistance < minDistance)) continue;
                minDistance = curDistance;
            }
            di[i] = minDistance;
        }
        double avgD = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            avgD += di[i];
        }
        avgD /= (double)pop.size();
        double sumD = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            sumD += Math.abs(di[i] - avgD);
        }
        res = (dem + sumD) / (dem + (double)pop.size() * avgD);
        return res;
    }

    public void savePopInFile(Population<I> pop, String filePath) throws Exception {
        BufferedWriter logger = new BufferedWriter(new FileWriter(new File(filePath)));
        for (Individual p : pop) {
            ObjectiveVector objs = p.getObjectiveVector();
            for (int k = 0; k < N; ++k) {
                logger.write(objs.get(k) + " ");
            }
            logger.write("\n");
        }
        logger.flush();
        logger.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KindOfTestFunction {
        ZDT1,
        ZDT2,
        ZDT3,
        ZDT4,
        ZDT6,
        DTLZ2,
        DTLZ5,
        DTLZ7;

    }
}

