/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorAnalisisView;
import Application.Herramientas.CellRenderJButton;
import Application.Herramientas.CommonTools;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Interfaces.AnalisisView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class DialogoNuevaInsulina
extends JDialog
implements AnalisisView {
    ControladorAnalisisView controlador;
    boolean saved;
    private JComboBox ComboBoxInsulina;
    private JButton buttonAceptar;
    private JButton buttonCancelar;
    private JButton buttonInsertar;
    private JDateChooser dateChooserFechaGlucemia;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel labelHora;
    private JLabel labelTipoInsulina;
    private JLabel labelTitulo;
    private JLabel labelValor;
    private JPanel panelGlucemia;
    private JPanel panelInferior;
    private JSpinner spinnerHora;
    private JTable tablaInsulinas;
    private JTextField textFieldValorMedido;

    private DialogoNuevaInsulina(Frame parent, boolean modal, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinnerHora.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(new SimpleDateFormat("HH:mm"));
        this.tablaInsulinas.getColumnModel().getColumn(0).setMaxWidth(0);
        this.tablaInsulinas.getColumnModel().getColumn(0).setMinWidth(0);
        this.tablaInsulinas.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.tablaInsulinas.setAutoCreateRowSorter(true);
        this.tablaInsulinas.getRowSorter().toggleSortOrder(0);
        this.controlador = new ControladorAnalisisView(idPacienteOwner, new Analisis());
        this.controlador.getModelo().setTipoAnalisis("Insulina");
        this.saved = false;
        this.getContentPane().setBackground(Color.white);
        CommonTools.centrarVentana(this);
    }

    public static Analisis showDialogNuevasInsulinas(String idPacienteOwner) {
        DialogoNuevaInsulina dialog = new DialogoNuevaInsulina(null, true, idPacienteOwner);
        return dialog.getGlucemia();
    }

    private Analisis getGlucemia() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    private String comprobarDatos() {
        if (this.dateChooserFechaGlucemia.getDate() != null) {
            Date fechaToma = this.dateChooserFechaGlucemia.getDate();
            int horaSpinner = ((Date)this.spinnerHora.getValue()).getHours();
            int minutosSpinner = ((Date)this.spinnerHora.getValue()).getMinutes();
            fechaToma.setHours(horaSpinner);
            fechaToma.setMinutes(minutosSpinner);
            if (fechaToma.after(new Date())) {
                return "\tFecha err\u00f3nea, no puede ser una fecha futura.\n";
            }
            if (this.textFieldValorMedido.getText().isEmpty()) {
                return "\tValor de la toma err\u00f3neo o en blanco. \n";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");
            String tipo = (String)this.ComboBoxInsulina.getSelectedItem();
            ImageIcon icon = new ImageIcon(this.getClass().getResource("../img/iconos/delete 16x16.png"));
            JButton boton = new JButton("Eliminar entrada", icon);
            boton.setFont(new Font("Tahoma", 0, 8));
            ((DefaultTableModel)this.tablaInsulinas.getModel()).addRow(new Object[]{fechaToma.getTime(), sdf.format(fechaToma), tipo, Double.parseDouble(this.textFieldValorMedido.getText()), boton});
            return null;
        }
        return "\tFecha err\u00f3nea o en blanco. \n";
    }

    private void initComponents() {
        this.panelGlucemia = new JPanel();
        this.jLabel1 = new JLabel();
        this.dateChooserFechaGlucemia = new JDateChooser();
        this.labelHora = new JLabel();
        this.spinnerHora = new JSpinner();
        this.labelTipoInsulina = new JLabel();
        this.ComboBoxInsulina = new JComboBox();
        this.labelValor = new JLabel();
        this.textFieldValorMedido = new JTextField();
        this.buttonInsertar = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tablaInsulinas = new JTable();
        this.panelInferior = new JPanel();
        this.buttonAceptar = new JButton();
        this.buttonCancelar = new JButton();
        this.labelTitulo = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Insertar nueva insulina");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(731, 323));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelGlucemia.setLayout(new BoxLayout(this.panelGlucemia, 2));
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setText("Fecha de la inyecci\u00f3n:");
        this.panelGlucemia.add(this.jLabel1);
        this.dateChooserFechaGlucemia.setMinimumSize(new Dimension(150, 20));
        this.panelGlucemia.add((Component)this.dateChooserFechaGlucemia);
        this.labelHora.setFont(new Font("Tahoma", 0, 12));
        this.labelHora.setText("Hora");
        this.panelGlucemia.add(this.labelHora);
        this.spinnerHora.setModel(new SpinnerDateModel(new Date(), null, null, 12));
        this.spinnerHora.setMaximumSize(new Dimension(65, 20));
        this.spinnerHora.setMinimumSize(new Dimension(65, 20));
        this.spinnerHora.setPreferredSize(new Dimension(65, 20));
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinnerHora.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(new SimpleDateFormat("hh:00 a"));
        this.panelGlucemia.add(this.spinnerHora);
        this.labelTipoInsulina.setText("Tipo:");
        this.panelGlucemia.add(this.labelTipoInsulina);
        this.ComboBoxInsulina.setModel(new DefaultComboBoxModel<String>(new String[]{"ACCI\u00d3N RAPIDA", "ACCION BREVE", "INTERMEDIA", "ACCION PROLONGADA", "PREMEZCLA", "INHALADA"}));
        this.panelGlucemia.add(this.ComboBoxInsulina);
        this.labelValor.setText("Cantidad:");
        this.panelGlucemia.add(this.labelValor);
        this.textFieldValorMedido.setMinimumSize(new Dimension(50, 20));
        this.textFieldValorMedido.setPreferredSize(new Dimension(50, 20));
        this.panelGlucemia.add(this.textFieldValorMedido);
        this.buttonInsertar.setBackground(new Color(255, 255, 255));
        this.buttonInsertar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonInsertar.setForeground(new Color(0, 102, 255));
        this.buttonInsertar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonInsertar.setText("Insertar");
        this.buttonInsertar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonInsertar.setContentAreaFilled(false);
        this.buttonInsertar.setCursor(new Cursor(12));
        this.buttonInsertar.setFocusPainted(false);
        this.buttonInsertar.setHorizontalAlignment(2);
        this.buttonInsertar.setMaximumSize(new Dimension(83, 22));
        this.buttonInsertar.setMinimumSize(new Dimension(83, 22));
        this.buttonInsertar.setPreferredSize(new Dimension(83, 22));
        this.buttonInsertar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaInsulina.this.buttonInsertarActionPerformed(evt);
            }
        });
        this.panelGlucemia.add(this.buttonInsertar);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 9, 2);
        this.getContentPane().add((Component)this.panelGlucemia, gridBagConstraints);
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setMinimumSize(new Dimension(695, 250));
        this.jScrollPane1.setOpaque(false);
        this.tablaInsulinas.setModel(new DefaultTableModel(new Object[0][], new String[]{"ValorFecha", "Fecha", "Tipo", "Cantidad", "Eliminar"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, String.class, String.class, Double.class, Object.class};
                this.canEdit = new boolean[]{false, false, true, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablaInsulinas.setFillsViewportHeight(true);
        this.tablaInsulinas.getTableHeader().setReorderingAllowed(false);
        this.tablaInsulinas.setDefaultRenderer(Object.class, new CellRenderJButton());
        this.jScrollPane1.setViewportView(this.tablaInsulinas);
        this.tablaInsulinas.getColumnModel().getColumn(0).setResizable(false);
        this.tablaInsulinas.getColumnModel().getColumn(1).setResizable(false);
        this.tablaInsulinas.getColumnModel().getColumn(2).setResizable(false);
        this.tablaInsulinas.getColumnModel().getColumn(3).setResizable(false);
        this.tablaInsulinas.getColumnModel().getColumn(4).setResizable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.panelInferior.setLayout(new BoxLayout(this.panelInferior, 2));
        this.buttonAceptar.setBackground(new Color(255, 255, 255));
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAceptar.setForeground(new Color(0, 102, 255));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.setCursor(new Cursor(12));
        this.buttonAceptar.setFocusPainted(false);
        this.buttonAceptar.setHorizontalAlignment(2);
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaInsulina.this.buttonAceptarActionPerformed(evt);
            }
        });
        this.panelInferior.add(this.buttonAceptar);
        this.buttonCancelar.setBackground(new Color(255, 255, 255));
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.setCursor(new Cursor(12));
        this.buttonCancelar.setFocusPainted(false);
        this.buttonCancelar.setHorizontalAlignment(2);
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaInsulina.this.buttonCancelarActionPerformed(evt);
            }
        });
        this.panelInferior.add(this.buttonCancelar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 6, 9);
        this.getContentPane().add((Component)this.panelInferior, gridBagConstraints);
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Insertar nueva insulina");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(1, 0, 7, 0);
        this.getContentPane().add((Component)this.labelTitulo, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        this.extraerInsulinasTabla();
        if (this.controlador.insertarAnalisisVariosResultados()) {
            this.saved = true;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Hubo un error al guardar los datos, por favor verifique la informaci\u00f3n y vuelva a intentarlo");
        }
    }

    private void extraerInsulinasTabla() {
        for (int i = 0; i < this.tablaInsulinas.getRowCount(); ++i) {
            Date fechaInsulina = new Date((Long)this.tablaInsulinas.getValueAt(i, 0));
            Double valor = (Double)this.tablaInsulinas.getValueAt(i, 3);
            ResultadoTest res = new ResultadoTest();
            res.setFecha(fechaInsulina);
            res.setTipoFecha("Collection start date");
            String tipo = (String)this.tablaInsulinas.getValueAt(i, 2);
            res.setTipoTest("Insulina " + tipo);
            res.setUnidadesObtenido("u/ml");
            res.setValorNormal("");
            res.setValorObtenido("" + valor);
            Analisis analisis = new Analisis();
            analisis.insertNewResultTest(res);
            analisis.setTipoAnalisis("Insulina");
            this.controlador.getModelo().insertNewResultTest(res);
        }
    }

    private void buttonInsertarActionPerformed(ActionEvent evt) {
        String erroresEncontrados = this.comprobarDatos();
        if (erroresEncontrados != null) {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + erroresEncontrados, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        if (!this.saved) {
            int option = JOptionPane.showConfirmDialog(this, "No se han guardado los cambios, \u00bfSeguro que desea cerrar sin guardar?", "\u00a1Atenci\u00f3n, cambios no guardados!", 2);
            if (option == 0) {
                this.saved = false;
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    public void updateView() {
    }
}

