/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Modelos.Analisis;
import Application.Vistas.Dialogos.DialogoDetallesCuerposCetonicos;
import Application.Vistas.Interfaces.PacienteView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;

public class PanelCuerposCetonicos
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    int idVista;
    private JButton buttonNuevoCuerpo;
    private JButton buttonVerDetalles;
    private JScrollPane jScrollPane1;
    private JLabel labelTitulo;
    private JList listaCuerposCetonicos;

    public PanelCuerposCetonicos(ControladorPacienteView controlador, String rol) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.rellenarListaCuerposCetonicos();
        if (rol.equalsIgnoreCase("Medico")) {
            this.buttonNuevoCuerpo.setVisible(false);
        }
    }

    private void rellenarListaCuerposCetonicos() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        ArrayList<Analisis> cuerposCetonicos = this.controlador.getModelo().getListaCuerposCetonicos();
        for (int i = cuerposCetonicos.size() - 1; i >= 0; --i) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");
            model.addElement("Cuerpo cet\u00f3nico con fecha " + sdf.format(cuerposCetonicos.get(i).getResultadosTest().get(0).getFecha()));
        }
        this.listaCuerposCetonicos.setModel(model);
    }

    public int getIdVista() {
        return this.idVista;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listaCuerposCetonicos = new JList();
        this.buttonVerDetalles = new JButton();
        this.buttonNuevoCuerpo = new JButton();
        this.labelTitulo = new JLabel();
        this.setMinimumSize(new Dimension(516, 462));
        this.setPreferredSize(new Dimension(516, 462));
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setMaximumSize(new Dimension(400, 400));
        this.jScrollPane1.setMinimumSize(new Dimension(400, 400));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 400));
        this.listaCuerposCetonicos.setSelectionMode(0);
        this.listaCuerposCetonicos.setMinimumSize(new Dimension(50, 80));
        this.listaCuerposCetonicos.setPreferredSize(new Dimension(5, 80));
        this.jScrollPane1.setViewportView(this.listaCuerposCetonicos);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonVerDetalles.setBackground(new Color(255, 255, 255));
        this.buttonVerDetalles.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonVerDetalles.setForeground(new Color(0, 102, 255));
        this.buttonVerDetalles.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/search 24x24.png")));
        this.buttonVerDetalles.setText("Ver en detalle");
        this.buttonVerDetalles.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonVerDetalles.setContentAreaFilled(false);
        this.buttonVerDetalles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelCuerposCetonicos.this.buttonVerDetallesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 26, 4, 14);
        this.add((Component)this.buttonVerDetalles, gridBagConstraints);
        this.buttonNuevoCuerpo.setBackground(new Color(255, 255, 255));
        this.buttonNuevoCuerpo.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonNuevoCuerpo.setForeground(new Color(0, 102, 255));
        this.buttonNuevoCuerpo.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonNuevoCuerpo.setText("Insertar nueva medida");
        this.buttonNuevoCuerpo.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonNuevoCuerpo.setContentAreaFilled(false);
        this.buttonNuevoCuerpo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelCuerposCetonicos.this.buttonNuevoCuerpoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 4, 19);
        this.add((Component)this.buttonNuevoCuerpo, gridBagConstraints);
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Medidas de Cuerpos Cet\u00f3nicos");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.labelTitulo, gridBagConstraints);
    }

    private void buttonNuevoCuerpoActionPerformed(ActionEvent evt) {
        Analisis analisis = DialogoDetallesCuerposCetonicos.showDialogNuevoCuerpoCetonico(this.controlador.getModelo().getId());
        if (analisis != null) {
            this.controlador.insertNewAnalisis(analisis);
            this.controlador.updateModelo();
        }
    }

    private void buttonVerDetallesActionPerformed(ActionEvent evt) {
        if (!this.listaCuerposCetonicos.isSelectionEmpty()) {
            int posCuerpo = this.listaCuerposCetonicos.getModel().getSize() - this.listaCuerposCetonicos.getSelectedIndex() - 1;
            Analisis analitica = this.controlador.getModelo().getListaCuerposCetonicos().get(posCuerpo);
            DialogoDetallesCuerposCetonicos.showDialogDetallesCuerpoCetonico(this.controlador.getModelo().getId(), analitica);
        }
    }

    public void updateView() {
        this.rellenarListaCuerposCetonicos();
    }
}

