/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Herramientas.CommonTools;
import Application.Herramientas.GraficaPesoAlturaImc;
import Application.Modelos.Analisis;
import Application.Vistas.Dialogos.DialogoDetallesAnalitica;
import Application.Vistas.Dialogos.DialogoDetallesFondoOjo;
import Application.Vistas.Interfaces.PacienteView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jfree.chart.ChartPanel;

public class PanelPruebasComplementarias
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    int tipoGrafica = 1;
    int tipoAmostrar = 1;
    ChartPanel actual = null;
    int idVista;
    String textFieldPeso = "";
    String antiguaTalla = "";
    String textFieldTalla = "";
    boolean suprimirTalla = false;
    boolean eliminarTalla = false;
    private JRadioButton ALtura;
    private JRadioButton IMC;
    private JRadioButton Peso;
    private JRadioButtonMenuItem area;
    private JRadioButtonMenuItem barras;
    private JRadioButtonMenuItem barras3d;
    private JButton botonNuevaAnalitica;
    private JButton botonNuevoFondoOjo;
    private JButton botonVerAnalitica;
    private JButton botonVerFondoOjo;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton buttonInsertar;
    private JButton buttonVerGraficas2;
    private JDialog dialogoGraficas;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JLabel labelIMC;
    private JLabel labelPeso;
    private JLabel labelTalla;
    private JLabel labelTitulo;
    private JLabel labelTitulo1;
    private JLabel labelTitulo2;
    private JRadioButtonMenuItem lineal;
    private JRadioButtonMenuItem lineal3d;
    private JList listaAnaliticas;
    private JList listaFondosDeOjo;
    private JPanel panelAnaliticas;
    private JPanel panelFondosOjo;
    private JFormattedTextField textFieldIMC;
    private JFormattedTextField textFieldPesoActual;
    private JFormattedTextField textFieldTallaActual;

    public PanelPruebasComplementarias(ControladorPacienteView controlador) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.rellenarListaAnaliticas();
        this.rellenarListaFondoOjos();
    }

    public int getIdVista() {
        return this.idVista;
    }

    private void rellenarListaAnaliticas() {
        DefaultListModel model = (DefaultListModel)this.listaAnaliticas.getModel();
        if (!model.isEmpty()) {
            model.clear();
        }
        ArrayList<Date> fechas = new ArrayList<Date>(this.controlador.getModelo().getTablaAnaliticas().keySet());
        Collections.sort(fechas);
        for (int i = fechas.size() - 1; i >= 0; --i) {
            model.addElement("Analitica con fecha " + CommonTools.getDateAsString(fechas.get(i)));
        }
    }

    private void rellenarListaFondoOjos() {
        DefaultListModel model = (DefaultListModel)this.listaFondosDeOjo.getModel();
        if (!model.isEmpty()) {
            model.clear();
        }
        ArrayList<Analisis> fondos = this.controlador.getModelo().getListaFondoOjos();
        for (Analisis fondo : fondos) {
            model.addElement("Fondo de ojo con fecha " + CommonTools.getDateAsString(fondo.getResultadosTest().get(0).getFecha()));
        }
    }

    private void initComponents() {
        this.dialogoGraficas = new JDialog();
        this.jPanel2 = new JPanel();
        this.Peso = new JRadioButton();
        this.ALtura = new JRadioButton();
        this.IMC = new JRadioButton();
        this.jButton1 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu3 = new JMenu();
        this.barras = new JRadioButtonMenuItem();
        this.barras3d = new JRadioButtonMenuItem();
        this.lineal = new JRadioButtonMenuItem();
        this.lineal3d = new JRadioButtonMenuItem();
        this.area = new JRadioButtonMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.labelIMC = new JLabel();
        this.labelPeso = new JLabel();
        this.labelTalla = new JLabel();
        this.buttonInsertar = new JButton();
        this.buttonVerGraficas2 = new JButton();
        this.labelTitulo2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.textFieldPesoActual = new JFormattedTextField();
        this.textFieldTallaActual = new JFormattedTextField();
        this.textFieldIMC = new JFormattedTextField();
        this.jLabel3 = new JLabel();
        this.panelAnaliticas = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.listaAnaliticas = new JList();
        this.botonNuevaAnalitica = new JButton();
        this.botonVerAnalitica = new JButton();
        this.labelTitulo = new JLabel();
        this.panelFondosOjo = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.listaFondosDeOjo = new JList();
        this.botonNuevoFondoOjo = new JButton();
        this.botonVerFondoOjo = new JButton();
        this.labelTitulo1 = new JLabel();
        this.dialogoGraficas.setDefaultCloseOperation(2);
        this.dialogoGraficas.setMinimumSize(new Dimension(640, 600));
        this.dialogoGraficas.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                PanelPruebasComplementarias.this.dialogoGraficasWindowClosed(evt);
            }
        });
        this.dialogoGraficas.getContentPane().setLayout(new BoxLayout(this.dialogoGraficas.getContentPane(), 1));
        this.buttonGroup1.add(this.Peso);
        this.Peso.setSelected(true);
        this.Peso.setText("Gr\u00e1fica Peso");
        this.Peso.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.PesoActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.ALtura);
        this.ALtura.setText("Gr\u00e1fica Altura");
        this.ALtura.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.ALturaActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.IMC);
        this.IMC.setText("Gr\u00e1fica IMC");
        this.IMC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.IMCActionPerformed(evt);
            }
        });
        this.jButton1.setText("Actualizar Gr\u00e1fica");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.Peso).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ALtura).addGap(18, 18, 18).addComponent(this.IMC).addGap(48, 48, 48).addComponent(this.jButton1, -2, 200, -2).addContainerGap(37, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(16, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Peso).addComponent(this.ALtura).addComponent(this.IMC)).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1).addContainerGap(12, Short.MAX_VALUE)));
        this.dialogoGraficas.getContentPane().add(this.jPanel2);
        this.jMenu1.setText("Archivo");
        this.jMenuItem1.setText("Guardar como .jpg");
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelPruebasComplementarias.this.jMenuItem1MouseClicked(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("Salir");
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Opciones");
        this.jMenu3.setText("Tipo de gr\u00e1fica");
        this.buttonGroup2.add(this.barras);
        this.barras.setText("Barras");
        this.barras.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelPruebasComplementarias.this.barrasMouseClicked(evt);
            }
        });
        this.barras.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.barrasActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.barras);
        this.barras3d.setText("Barras 3D");
        this.jMenu3.add(this.barras3d);
        this.buttonGroup2.add(this.lineal);
        this.lineal.setSelected(true);
        this.lineal.setText("Lineal");
        this.lineal.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelPruebasComplementarias.this.linealMouseClicked(evt);
            }
        });
        this.jMenu3.add(this.lineal);
        this.buttonGroup2.add(this.lineal3d);
        this.lineal3d.setText("Lineal 3D");
        this.jMenu3.add(this.lineal3d);
        this.buttonGroup2.add(this.area);
        this.area.setText("Area");
        this.jMenu3.add(this.area);
        this.jMenu2.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenu2);
        this.dialogoGraficas.setJMenuBar(this.jMenuBar1);
        this.setMinimumSize(new Dimension(978, 454));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(978, 454));
        this.setLayout(new GridBagLayout());
        this.jPanel3.setMinimumSize(new Dimension(241, 224));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(241, 224));
        this.jPanel3.setLayout(new GridBagLayout());
        this.labelIMC.setFont(new Font("Arial", 1, 11));
        this.labelIMC.setText("IMC:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 69, 0, 0);
        this.jPanel3.add((Component)this.labelIMC, gridBagConstraints);
        this.labelPeso.setFont(new Font("Tahoma", 1, 11));
        this.labelPeso.setText("Peso actual(kg):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.labelPeso, gridBagConstraints);
        this.labelTalla.setFont(new Font("Tahoma", 1, 11));
        this.labelTalla.setText("Talla actual(cm):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.labelTalla, gridBagConstraints);
        this.buttonInsertar.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonInsertar.setForeground(new Color(0, 102, 255));
        this.buttonInsertar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonInsertar.setText("Insertar");
        this.buttonInsertar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonInsertar.setContentAreaFilled(false);
        this.buttonInsertar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.buttonInsertarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(4, 23, 5, 9);
        this.jPanel3.add((Component)this.buttonInsertar, gridBagConstraints);
        this.buttonVerGraficas2.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonVerGraficas2.setForeground(new Color(0, 102, 255));
        this.buttonVerGraficas2.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/chart 24x24.png")));
        this.buttonVerGraficas2.setText("Aqu\u00ed");
        this.buttonVerGraficas2.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonVerGraficas2.setContentAreaFilled(false);
        this.buttonVerGraficas2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.buttonVerGraficas2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 14, 0, 32);
        this.jPanel3.add((Component)this.buttonVerGraficas2, gridBagConstraints);
        this.labelTitulo2.setBackground(new Color(0, 153, 255));
        this.labelTitulo2.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo2.setForeground(new Color(255, 255, 255));
        this.labelTitulo2.setText("Peso, talla e IMC");
        this.labelTitulo2.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo2.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo2.setOpaque(true);
        this.labelTitulo2.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.labelTitulo2, gridBagConstraints);
        this.jLabel1.setText("Para ver las gr\u00e1ficas de evoluci\u00f3n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 3, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Introducir nuevas medidas de altura, peso e IMC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 5, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.textFieldPesoActual.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0"))));
        this.textFieldPesoActual.setMinimumSize(new Dimension(50, 20));
        this.textFieldPesoActual.setPreferredSize(new Dimension(50, 20));
        this.textFieldPesoActual.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PanelPruebasComplementarias.this.textFieldPesoActualFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                PanelPruebasComplementarias.this.textFieldPesoActualFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 21, 0, 0);
        this.jPanel3.add((Component)this.textFieldPesoActual, gridBagConstraints);
        this.textFieldTallaActual.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0"))));
        this.textFieldTallaActual.setMinimumSize(new Dimension(50, 20));
        this.textFieldTallaActual.setPreferredSize(new Dimension(50, 20));
        this.textFieldTallaActual.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PanelPruebasComplementarias.this.textFieldTallaActualFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                PanelPruebasComplementarias.this.textFieldTallaActualFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 21, 0, 0);
        this.jPanel3.add((Component)this.textFieldTallaActual, gridBagConstraints);
        this.textFieldIMC.setEditable(false);
        this.textFieldIMC.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00"))));
        this.textFieldIMC.setMinimumSize(new Dimension(50, 20));
        this.textFieldIMC.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 21, 0, 0);
        this.jPanel3.add((Component)this.textFieldIMC, gridBagConstraints);
        this.jLabel3.setText(" de peso, talla e IMC pulse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.panelAnaliticas.setMinimumSize(new Dimension(330, 471));
        this.panelAnaliticas.setOpaque(false);
        this.panelAnaliticas.setPreferredSize(new Dimension(330, 471));
        this.panelAnaliticas.setLayout(new GridBagLayout());
        this.listaAnaliticas.setBorder(BorderFactory.createTitledBorder("Anal\u00edticas previas"));
        this.listaAnaliticas.setModel(new DefaultListModel());
        this.listaAnaliticas.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.listaAnaliticas);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelAnaliticas.add((Component)this.jScrollPane4, gridBagConstraints);
        this.botonNuevaAnalitica.setFont(new Font("Trebuchet MS", 0, 14));
        this.botonNuevaAnalitica.setForeground(new Color(0, 102, 255));
        this.botonNuevaAnalitica.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.botonNuevaAnalitica.setText("Nueva anal\u00edtica");
        this.botonNuevaAnalitica.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.botonNuevaAnalitica.setContentAreaFilled(false);
        this.botonNuevaAnalitica.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.botonNuevaAnaliticaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 6, 2);
        this.panelAnaliticas.add((Component)this.botonNuevaAnalitica, gridBagConstraints);
        this.botonVerAnalitica.setFont(new Font("Trebuchet MS", 0, 12));
        this.botonVerAnalitica.setForeground(new Color(0, 102, 255));
        this.botonVerAnalitica.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/search 24x24.png")));
        this.botonVerAnalitica.setText("Ver anal\u00edtica seleccionada");
        this.botonVerAnalitica.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.botonVerAnalitica.setContentAreaFilled(false);
        this.botonVerAnalitica.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.botonVerAnaliticaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 4, 6, 2);
        this.panelAnaliticas.add((Component)this.botonVerAnalitica, gridBagConstraints);
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Anal\u00edticas registradas");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.panelAnaliticas.add((Component)this.labelTitulo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panelAnaliticas, gridBagConstraints);
        this.panelFondosOjo.setMinimumSize(new Dimension(358, 471));
        this.panelFondosOjo.setOpaque(false);
        this.panelFondosOjo.setPreferredSize(new Dimension(358, 471));
        this.panelFondosOjo.setLayout(new GridBagLayout());
        this.listaFondosDeOjo.setBorder(BorderFactory.createTitledBorder("Fondos de Ojo previos"));
        this.listaFondosDeOjo.setModel(new DefaultListModel());
        this.listaFondosDeOjo.setSelectionMode(0);
        this.jScrollPane5.setViewportView(this.listaFondosDeOjo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panelFondosOjo.add((Component)this.jScrollPane5, gridBagConstraints);
        this.botonNuevoFondoOjo.setFont(new Font("Trebuchet MS", 0, 14));
        this.botonNuevoFondoOjo.setForeground(new Color(0, 102, 255));
        this.botonNuevoFondoOjo.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.botonNuevoFondoOjo.setText("Nuevo fondo de ojo");
        this.botonNuevoFondoOjo.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.botonNuevoFondoOjo.setContentAreaFilled(false);
        this.botonNuevoFondoOjo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.botonNuevoFondoOjoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 7, 3);
        this.panelFondosOjo.add((Component)this.botonNuevoFondoOjo, gridBagConstraints);
        this.botonVerFondoOjo.setFont(new Font("Trebuchet MS", 0, 12));
        this.botonVerFondoOjo.setForeground(new Color(0, 102, 255));
        this.botonVerFondoOjo.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/search 24x24.png")));
        this.botonVerFondoOjo.setText("Ver Fondo de ojo seleccionado");
        this.botonVerFondoOjo.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.botonVerFondoOjo.setContentAreaFilled(false);
        this.botonVerFondoOjo.setHorizontalAlignment(2);
        this.botonVerFondoOjo.setMargin(new Insets(2, 2, 2, 2));
        this.botonVerFondoOjo.setMaximumSize(new Dimension(235, 29));
        this.botonVerFondoOjo.setMinimumSize(new Dimension(235, 29));
        this.botonVerFondoOjo.setPreferredSize(new Dimension(215, 29));
        this.botonVerFondoOjo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPruebasComplementarias.this.botonVerFondoOjoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 4, 7, 3);
        this.panelFondosOjo.add((Component)this.botonVerFondoOjo, gridBagConstraints);
        this.labelTitulo1.setBackground(new Color(0, 153, 255));
        this.labelTitulo1.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo1.setForeground(new Color(255, 255, 255));
        this.labelTitulo1.setText("Fondos de ojos registrados");
        this.labelTitulo1.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo1.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo1.setOpaque(true);
        this.labelTitulo1.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.panelFondosOjo.add((Component)this.labelTitulo1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelFondosOjo, gridBagConstraints);
    }

    private void botonNuevaAnaliticaActionPerformed(ActionEvent evt) {
        Analisis nuevaAnalitica = DialogoDetallesAnalitica.showDialogCrearNuevaAnalitica(this.controlador.getModelo().getId());
        if (nuevaAnalitica != null) {
            this.controlador.insertNewAnalisis(nuevaAnalitica);
            this.controlador.updateModelo();
        }
    }

    private void buttonInsertarActionPerformed(ActionEvent evt) {
        if (!this.textFieldPesoActual.getText().isEmpty()) {
            this.controlador.insertNewAnalisis("Peso", new Date(), "Peso", this.textFieldPesoActual.getText(), "kg", "");
        }
        if (!this.textFieldTallaActual.getText().isEmpty()) {
            this.controlador.insertNewAnalisis("Altura", new Date(), "Altura", this.textFieldTallaActual.getText(), "cm", "");
        }
        if (!this.textFieldIMC.getText().isEmpty()) {
            this.controlador.insertNewAnalisis("IMC", new Date(), "IMC", this.textFieldIMC.getText(), "kg/m2", "");
        }
    }

    private void linealMouseClicked(MouseEvent evt) {
    }

    private void PesoActionPerformed(ActionEvent evt) {
        this.tipoAmostrar = 1;
    }

    private void ALturaActionPerformed(ActionEvent evt) {
        this.tipoAmostrar = 2;
    }

    private void IMCActionPerformed(ActionEvent evt) {
        this.tipoAmostrar = 3;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dialogoGraficas.remove((Component)this.actual);
        this.dialogoGraficas.validate();
        Object p = null;
        this.actualizaTipo();
        if (this.tipoAmostrar == 1) {
            ArrayList<Analisis> listaPesos = this.controlador.getModelo().getPeso();
            this.actual = GraficaPesoAlturaImc.mostrarGrafica(listaPesos, null, null, this.tipoGrafica);
        }
        if (this.tipoAmostrar == 2) {
            ArrayList<Analisis> listaAltura = this.controlador.getModelo().getAltura();
            this.actual = GraficaPesoAlturaImc.mostrarGrafica(null, listaAltura, null, this.tipoGrafica);
        }
        if (this.tipoAmostrar == 3) {
            ArrayList<Analisis> listaIMC = this.controlador.getModelo().getImc();
            this.actual = GraficaPesoAlturaImc.mostrarGrafica(null, null, listaIMC, this.tipoGrafica);
        }
        this.dialogoGraficas.add((Component)this.actual);
        this.dialogoGraficas.validate();
    }

    private void barrasActionPerformed(ActionEvent evt) {
    }

    private void barrasMouseClicked(MouseEvent evt) {
        this.tipoGrafica = 2;
    }

    private void jMenuItem1MouseClicked(MouseEvent evt) {
        GraficaPesoAlturaImc.guardarFichero(this.actual.getChart(), this.tipoGrafica);
    }

    private void botonVerAnaliticaActionPerformed(ActionEvent evt) {
        if (!this.listaAnaliticas.isSelectionEmpty()) {
            Date fechaAnaliticaSelec = CommonTools.getStringAsDate(((String)this.listaAnaliticas.getSelectedValue()).substring(20));
            Analisis analitica = this.controlador.getModelo().getTablaAnaliticas().get(fechaAnaliticaSelec);
            DialogoDetallesAnalitica.showDialogDetallesAnalitica(this.controlador.getModelo().getId(), analitica);
        }
    }

    public int damePos(String antiguo, String nuevo) {
        int pos = 0;
        char[] ant = antiguo.toCharArray();
        char[] nue = nuevo.toCharArray();
        int size = Math.min(antiguo.length(), nuevo.length());
        for (int i = 0; i < size && ant[i] == nue[i]; ++i) {
            ++pos;
        }
        return pos;
    }

    private void dialogoGraficasWindowClosed(WindowEvent evt) {
        if (this.actual != null) {
            this.dialogoGraficas.remove((Component)this.actual);
        }
    }

    private void buttonVerGraficas2ActionPerformed(ActionEvent evt) {
        this.dialogoGraficas.setVisible(true);
        ArrayList<Analisis> listaPeso = this.controlador.getModelo().getPeso();
        this.actual = GraficaPesoAlturaImc.mostrarGrafica(listaPeso, null, null, this.tipoGrafica);
        this.dialogoGraficas.add((Component)this.actual);
    }

    private void botonVerFondoOjoActionPerformed(ActionEvent evt) {
        if (!this.listaFondosDeOjo.isSelectionEmpty()) {
            int elemSelec = this.listaFondosDeOjo.getSelectedIndex();
            Analisis fondo = this.controlador.getModelo().getListaFondoOjos().get(elemSelec);
            DialogoDetallesFondoOjo.showDialogDetallesFondoOjo(this.controlador.getModelo().getId(), fondo);
        }
    }

    private void botonNuevoFondoOjoActionPerformed(ActionEvent evt) {
        Analisis nuevoFondo = DialogoDetallesFondoOjo.showDialogNuevoFondoOjo(this.controlador.getModelo().getId());
        if (nuevoFondo != null) {
            this.controlador.insertNewAnalisis(nuevoFondo);
            this.controlador.updateModelo();
        }
    }

    private void textFieldPesoActualFocusLost(FocusEvent evt) {
        if (!this.textFieldPesoActual.getText().isEmpty() && !this.textFieldTallaActual.getText().isEmpty()) {
            float peso = Float.parseFloat(this.textFieldPesoActual.getText());
            float talla = Float.parseFloat(this.textFieldTallaActual.getText());
            float imc = peso / ((talla /= 100.0f) * talla);
            imc = Math.round(imc * 100.0f) / 100;
            this.textFieldIMC.setText(Float.toString(imc));
        }
    }

    private void textFieldTallaActualFocusLost(FocusEvent evt) {
        if (!this.textFieldPesoActual.getText().isEmpty() && !this.textFieldTallaActual.getText().isEmpty()) {
            float peso = Float.parseFloat(this.textFieldPesoActual.getText());
            float talla = Float.parseFloat(this.textFieldTallaActual.getText());
            float imc = peso / ((talla /= 100.0f) * talla);
            imc = Math.round(imc * 100.0f) / 100;
            this.textFieldIMC.setText(Float.toString(imc));
        }
    }

    private void textFieldPesoActualFocusGained(FocusEvent evt) {
    }

    private void textFieldTallaActualFocusGained(FocusEvent evt) {
    }

    public static boolean esVacio(String vacio) {
        if (!vacio.isEmpty()) {
            Pattern patron = Pattern.compile("[0-9]*");
            Matcher encajador = patron.matcher(vacio);
            return encajador.matches();
        }
        return false;
    }

    public void updateView() {
        this.textFieldPesoActual.setText("");
        this.textFieldTallaActual.setText("");
        this.textFieldIMC.setText("");
        this.textFieldIMC.setText("");
        this.rellenarListaAnaliticas();
        this.rellenarListaFondoOjos();
    }

    private boolean comprobarFormatoPeso(String campo) {
        if (!campo.isEmpty()) {
            Pattern patron = Pattern.compile("[0-9]*");
            Matcher encajador = patron.matcher(campo);
            return encajador.matches();
        }
        return false;
    }

    private void actualizaTipo() {
        if (this.lineal.isSelected()) {
            this.tipoGrafica = 1;
        }
        if (this.barras.isSelected()) {
            this.tipoGrafica = 2;
        }
        if (this.lineal3d.isSelected()) {
            this.tipoGrafica = 3;
        }
        if (this.barras3d.isSelected()) {
            this.tipoGrafica = 4;
        }
        if (this.area.isSelected()) {
            this.tipoGrafica = 5;
        }
    }
}

