/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.ClasesAuxiliares;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Dosis;
import com.google.code.ccr4j.DirectionDocument;
import com.google.code.ccr4j.DirectionsDocument;
import com.google.code.ccr4j.FrequencyType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Direction {
    private ArrayList<Dosis> listaDosis;
    private ArrayList<String> listaVias;
    private ArrayList<String> listaFrecuencias;

    public Direction(String valor, String unidades, String via, String frecuencia) {
        if (valor != null || unidades != null) {
            this.listaDosis = new ArrayList();
            Dosis d = new Dosis();
            if (valor != null) {
                d.setValor(valor);
            }
            if (unidades != null) {
                d.setUnidades(unidades);
            }
            this.listaDosis.add(d);
        }
        if (via != null) {
            this.listaVias = new ArrayList();
            this.listaVias.add(via);
        }
        if (frecuencia != null) {
            this.listaFrecuencias = new ArrayList();
            this.listaFrecuencias.add(frecuencia);
        }
    }

    public Direction() {
        this.listaDosis = new ArrayList();
        this.listaVias = new ArrayList();
        this.listaFrecuencias = new ArrayList();
    }

    public static Direction getDirection(DirectionsDocument.Directions direcc) {
        List directionList = direcc.getDirectionList();
        Iterator it = directionList.iterator();
        Direction posologia = new Direction();
        while (it.hasNext()) {
            DirectionDocument.Direction d = (DirectionDocument.Direction)it.next();
            List doseList = d.getDoseList();
            for (DirectionDocument.Direction.Dose dosis : doseList) {
                Dosis ds = new Dosis();
                ds.setValor(dosis.getValue());
                if (dosis.getUnits() != null) {
                    ds.setUnidades(dosis.getUnits().getUnit());
                }
                posologia.getListaDosis().add(ds);
            }
            List routeList = d.getRouteList();
            Iterator it2 = routeList.iterator();
            while (it2.hasNext()) {
                posologia.getListaVias().add(((DirectionDocument.Direction.Route)it2.next()).getText());
            }
            List frequencyList = d.getFrequencyList();
            for (FrequencyType freq : frequencyList) {
                posologia.getListaFrecuencias().add(freq.getValue());
            }
        }
        return posologia;
    }

    public ArrayList<Dosis> getListaDosis() {
        return this.listaDosis;
    }

    public void setListaDosis(ArrayList<Dosis> listaDosis) {
        this.listaDosis = listaDosis;
    }

    public ArrayList<String> getListaVias() {
        return this.listaVias;
    }

    public void setListaVias(ArrayList<String> via) {
        this.listaVias = via;
    }

    public ArrayList<String> getListaFrecuencias() {
        return this.listaFrecuencias;
    }

    public void setListaFrecuencias(ArrayList<String> frecuencia) {
        this.listaFrecuencias = frecuencia;
    }

    public Direction clone() {
        Direction aDirection = new Direction();
        aDirection.setListaFrecuencias(new ArrayList<String>());
        for (String freq : this.getListaFrecuencias()) {
            aDirection.getListaFrecuencias().add(freq.toString());
        }
        aDirection.setListaDosis(new ArrayList<Dosis>());
        for (Dosis dosis : this.getListaDosis()) {
            aDirection.getListaDosis().add(dosis.clone());
        }
        aDirection.setListaVias(new ArrayList<String>());
        for (String via : this.getListaVias()) {
            aDirection.getListaVias().add(via.toString());
        }
        return aDirection;
    }
}

