/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DAOs;

import DataManager.GoogleHealthManager.Conector;
import DataManager.GoogleHealthManager.DAOs.Interfaces.AnalisisDAO;
import DataManager.GoogleHealthManager.DAOs.MedicamentosDAOGH;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.ResultadoTestDTO;
import DataManager.GoogleHealthManager.Interpreters.AnalisisInterpreter;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalisisDAOGH
implements AnalisisDAO {
    @Override
    public ArrayList<AnalisisDTO> getListaDeAnalisis(String idPaciente) {
        try {
            String XMLData = Conector.getConector().getDataByCategory(idPaciente, "Labtest", true);
            ArrayList<AnalisisDTO> lista = new AnalisisInterpreter().translateCCRtoDTO(XMLData);
            System.out.println("Analisis retrieved successfully");
            return lista;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (XmlException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR AL CONVERTIR EL CCR EN DTO");
        }
        System.err.println("Analisis retrieval failed");
        return null;
    }

    @Override
    public String insertNewAnalisis(AnalisisDTO analisisDTO, String idPaciente) {
        try {
            String XMLCode = new AnalisisInterpreter().translateDTOtoCCR(analisisDTO);
            return Conector.getConector().insert(idPaciente, XMLCode);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        return null;
    }

    @Override
    public boolean removeAnalisis(String idAnalisis, String idPaciente) {
        try {
            Conector.getConector().remove(idPaciente, idAnalisis);
            System.out.println("Analisis removed successfully");
            return true;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        System.out.println("Analisis removing failed");
        return false;
    }

    @Override
    public boolean updateAnalisis(AnalisisDTO analisisDTO, String idPaciente) {
        String XMLCode = new AnalisisInterpreter().translateDTOtoCCR(analisisDTO);
        try {
            Conector.getConector().update(idPaciente, XMLCode, analisisDTO.getIdObjeto());
            System.out.println("Analisis updated successfully");
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(MedicamentosDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(MedicamentosDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Analisis updating failed");
        return false;
    }

    public String[] insertarAnalisisVariosTestResult(AnalisisDTO analisis, String idPaciente) {
        String[] idsAsignados = new String[analisis.getResultadosDelAnalisis().size()];
        int i = 0;
        for (ResultadoTestDTO test : analisis.getResultadosDelAnalisis()) {
            AnalisisDTO nuevaEntrada = new AnalisisDTO();
            nuevaEntrada.setDatosMedico(analisis.getDatosMedico());
            nuevaEntrada.setDescripcion(analisis.getDescripcion());
            nuevaEntrada.setFechaAnalisis(analisis.getFechaAnalisis());
            nuevaEntrada.insertarNuevoResultado(test);
            idsAsignados[i] = this.insertNewAnalisis(nuevaEntrada, idPaciente);
            ++i;
        }
        return idsAsignados;
    }
}

