/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DAOs;

import DataManager.GoogleHealthManager.Conector;
import DataManager.GoogleHealthManager.DAOs.AnalisisDAOGH;
import DataManager.GoogleHealthManager.DAOs.Interfaces.ProblemsDAO;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import DataManager.GoogleHealthManager.Interpreters.ProblemsInterpreter;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemsDAOGH
implements ProblemsDAO {
    @Override
    public ArrayList<ProblemsDTO> getAllProblems(String idPaciente) {
        try {
            String XMLData = Conector.getConector().getProfileData(idPaciente);
            ArrayList<ProblemsDTO> lista = new ProblemsInterpreter().translateCCRtoDTO(XMLData);
            System.out.println("Problems retrieved successfully");
            return lista;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERRO INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERRO DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (XmlException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR AL CONVERTIR EL CCR EN DTO");
        }
        System.err.println("Problems retrieval failed");
        return null;
    }

    @Override
    public String insertProblem(ProblemsDTO problem, String identificador) {
        try {
            String XMLCode = new ProblemsInterpreter().translateDTOtoCCR(problem);
            String idProblem = Conector.getConector().insert(identificador, XMLCode);
            System.out.println("INSERT de PROBLEM con exito");
            return idProblem;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        System.out.println("Insert de PROBLEM fallido");
        return null;
    }

    @Override
    public boolean removeProblem(ProblemsDTO problems, String idPaciente) {
        try {
            Conector.getConector().remove(idPaciente, problems.getIdInterno());
            System.out.println("Borrado de PROBLEM con exito");
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Borrado de PROBLEM fallido");
        return false;
    }

    @Override
    public boolean updateProblem(ProblemsDTO problems, String idPaciente) {
        String XMLCode = new ProblemsInterpreter().translateDTOtoCCR(problems);
        try {
            Conector.getConector().update(idPaciente, XMLCode, problems.getIdInterno());
            System.out.println("Actualizacion de PROBLEM con exito");
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(ProblemsDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Actualizacion de PROBLEM fallida");
        return false;
    }
}

