/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DTOs;

import Application.Modelos.Analisis;
import Application.Modelos.Medicamento;
import Application.Modelos.Paciente;
import Application.Modelos.Problemas;
import Application.Modelos.SocialHistory;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.FunctionalStatusDTO;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import DataManager.GoogleHealthManager.DTOs.SocialHistoryDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacienteDTO {
    private String id;
    private String nombreDelPaciente = "";
    private DateTime fechaNacimiento;
    private String sexo;
    private String Raza;
    private String tipoSangre;
    private ArrayList<MedicamentoDTO> medicamentos = new ArrayList();
    private ArrayList<ProblemsDTO> problemas = new ArrayList();
    private ArrayList<AnalisisDTO> analisis = new ArrayList();
    private ArrayList<SocialHistoryDTO> socialHistories = new ArrayList();
    private ArrayList<FunctionalStatusDTO> functionalStatus = new ArrayList();

    public PacienteDTO() {
    }

    public PacienteDTO(Paciente patient) {
        this.id = patient.getId();
        this.nombreDelPaciente = patient.getApellidos() + "," + patient.getNombre();
        this.Raza = "";
        this.tipoSangre = "";
        this.medicamentos = new ArrayList();
        this.insertaMedicamentos(patient.getListaMedicamentos());
        this.insertaMedicamentos(patient.getInsulina());
        this.analisis = new ArrayList();
        this.insertaAnalisis(patient.getComidas());
        this.insertaAnalisis(patient.getListaCuerposCetonicos());
        this.insertaAnalisis(patient.getListaFondoOjos());
        this.insertaAnalisis(patient.getTablaAnaliticas());
        this.insertaAnalisis(patient.getListaGlucemias());
        this.insertaAnalisis(patient.getAltura());
        this.insertaAnalisis(patient.getPeso());
        this.problemas = new ArrayList();
        this.insertaProblemas(patient.getOtrasEnfermedades());
        this.problemas.add(new ProblemsDTO(patient.getDiabetes()));
        this.socialHistories = new ArrayList();
        this.socialHistories.add(new SocialHistoryDTO(patient.getLocalidad()));
        this.socialHistories.add(new SocialHistoryDTO(patient.getFechaNacimiento()));
        this.socialHistories.add(new SocialHistoryDTO(patient.getDireccion()));
        this.socialHistories.add(new SocialHistoryDTO(patient.getSexo()));
        this.socialHistories.add(new SocialHistoryDTO(patient.getTelefono1()));
        this.socialHistories.add(new SocialHistoryDTO(patient.getTelefono2()));
        this.socialHistories.add(new SocialHistoryDTO(patient.getEmail()));
    }

    private void insertaMedicamentos(ArrayList<Medicamento> listaMedicamentos) {
        for (Medicamento m : listaMedicamentos) {
            MedicamentoDTO mdto = new MedicamentoDTO(m);
            this.medicamentos.add(mdto);
        }
    }

    private void insertaSocialHistory(ArrayList<SocialHistory> listaSocialHistory) {
        for (SocialHistory s : listaSocialHistory) {
            SocialHistoryDTO sdto = new SocialHistoryDTO(s);
            this.socialHistories.add(sdto);
        }
    }

    private void insertaAnalisis(ArrayList<Analisis> analisisPaciente) {
        for (Analisis analisisModelo : analisisPaciente) {
            AnalisisDTO analisisDTO = new AnalisisDTO(analisisModelo);
            this.analisis.add(analisisDTO);
        }
    }

    private void insertaAnalisis(Hashtable<Date, Analisis> tablaAnalisisPaciente) {
        for (Analisis analisisModelo : tablaAnalisisPaciente.values()) {
            AnalisisDTO analisisDTO = new AnalisisDTO(analisisModelo);
            this.analisis.add(analisisDTO);
        }
    }

    private void insertaProblemas(ArrayList<Problemas> otrasEnfermedades) {
        for (Problemas m : otrasEnfermedades) {
            ProblemsDTO mdto = new ProblemsDTO(m);
            this.problemas.add(mdto);
        }
    }

    public ArrayList<SocialHistoryDTO> getSocialHistories() {
        return this.socialHistories;
    }

    public void setSocialHistories(ArrayList<SocialHistoryDTO> socialHistories) {
        this.socialHistories = socialHistories;
    }

    public String getRaza() {
        return this.Raza;
    }

    public void setRaza(String Raza) {
        this.Raza = Raza;
    }

    public DateTime getFechaNacimiento() {
        return this.fechaNacimiento;
    }

    public void setFechaNacimiento(DateTime fechaNacimiento) {
        this.fechaNacimiento = fechaNacimiento;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNombreDelPaciente() {
        return this.nombreDelPaciente;
    }

    public void setNombreDelPaciente(String nombreDelPaciente) {
        this.nombreDelPaciente = nombreDelPaciente;
    }

    public String getSexo() {
        return this.sexo;
    }

    public void setSexo(String sexo) {
        this.sexo = sexo;
    }

    public String getTipoSangre() {
        return this.tipoSangre;
    }

    public void setTipoSangre(String tipoSangre) {
        this.tipoSangre = tipoSangre;
    }

    public ArrayList<MedicamentoDTO> getMedicamentos() {
        return this.medicamentos;
    }

    public void setMedicamentos(ArrayList<MedicamentoDTO> medicamentos) {
        this.medicamentos = medicamentos;
    }

    public ArrayList<AnalisisDTO> getAnalisis() {
        return this.analisis;
    }

    public void setAnalisis(ArrayList<AnalisisDTO> analisis) {
        this.analisis = analisis;
    }

    public ArrayList<ProblemsDTO> getProblemas() {
        return this.problemas;
    }

    public void setProblemas(ArrayList<ProblemsDTO> problemas) {
        this.problemas = problemas;
    }

    public ArrayList<FunctionalStatusDTO> getFunctionalStatus() {
        return this.functionalStatus;
    }

    public void setFunctionalStatus(ArrayList<FunctionalStatusDTO> functionalStatus) {
        this.functionalStatus = functionalStatus;
    }
}

