/*
 * Decompiled with CFR 0.152.
 */
package Application.Controladores;

import Application.Modelos.Analisis;
import Application.Vistas.Interfaces.AnalisisView;
import DataManager.GoogleHealthManager.DAOs.AnalisisDAOGH;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;

public class ControladorAnalisisView {
    Analisis modelo;
    boolean modeloHasChange = false;
    String idPacienteOwner = "";

    public ControladorAnalisisView(String idPaciente, Analisis modelo) {
        this.modelo = modelo;
        this.idPacienteOwner = idPaciente;
    }

    public ControladorAnalisisView(String idPaciente, String tipoAnalisis) {
        this.modelo = new Analisis();
        this.modelo.setTipoAnalisis(tipoAnalisis);
        this.idPacienteOwner = idPaciente;
    }

    public boolean insertarAnalisisVariosResultados() {
        String[] nuevosIds = new AnalisisDAOGH().insertarAnalisisVariosTestResult(new AnalisisDTO(this.modelo), this.idPacienteOwner);
        for (int i = 0; i < nuevosIds.length; ++i) {
            this.modelo.getResultadosTest().get(i).setIdInterno(nuevosIds[i]);
        }
        return true;
    }

    public boolean insertarAnalisis() {
        String nuevoId = new AnalisisDAOGH().insertNewAnalisis(new AnalisisDTO(this.modelo), this.idPacienteOwner);
        if (nuevoId != null) {
            this.modelo.getResultadosTest().get(0).setIdInterno(nuevoId);
            return true;
        }
        return false;
    }

    public void addViewToModel(AnalisisView view) {
        this.modelo.addView(view);
    }

    public Analisis getModelo() {
        return this.modelo;
    }

    public String getIdPacienteOwner() {
        return this.idPacienteOwner;
    }
}

