/*
 * Decompiled with CFR 0.152.
 */
package Application.Controladores;

import Application.Modelos.Analisis;
import Application.Modelos.Medicamento;
import Application.Modelos.Paciente;
import Application.Modelos.Problemas;
import Application.Modelos.SocialHistory;
import Application.Vistas.Interfaces.PacienteView;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Type;
import DataManager.GoogleHealthManager.DAOs.AnalisisDAOGH;
import DataManager.GoogleHealthManager.DAOs.MedicamentosDAOGH;
import DataManager.GoogleHealthManager.DAOs.PacienteDAOGH;
import DataManager.GoogleHealthManager.DAOs.ProblemsDAOGH;
import DataManager.GoogleHealthManager.DAOs.SocialHistoryDAOGH;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import DataManager.GoogleHealthManager.DTOs.SocialHistoryDTO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;

public class ControladorPacienteView {
    Paciente modelo;
    boolean modeloHasChange = false;

    public ControladorPacienteView(String idPaciente, String nombrePaciente) {
        this.modelo = new Paciente(new PacienteDAOGH().getPaciente(idPaciente), nombrePaciente);
        this.modelo.setId(idPaciente);
    }

    public int addViewToModel(PacienteView view) {
        return this.modelo.addView(view);
    }

    public boolean removeViewFromModel(PacienteView view) {
        return this.modelo.removeView(view) != null;
    }

    public Paciente getModelo() {
        return this.modelo;
    }

    public void setModelo(Paciente modelo) {
        this.modelo = modelo;
    }

    public void updateModelo() {
        if (this.modeloHasChange) {
            this.modelo.updateAllViews();
        }
        this.modeloHasChange = false;
    }

    public void insertOrUpdateFechaDeNacimiento(String newFechaNacimiento) {
        if (this.modelo.getFechaNacimiento() == null) {
            SocialHistory fechaNacimiento;
            String nuevoId;
            if (!newFechaNacimiento.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(fechaNacimiento = new SocialHistory("FechaNacimiento", newFechaNacimiento)), this.modelo.getId())) != null) {
                fechaNacimiento.setIdInterno(nuevoId);
                this.modelo.setFechaNacimiento(fechaNacimiento);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getFechaNacimiento().getTipo().getType().equalsIgnoreCase(newFechaNacimiento)) {
            SocialHistory fechaNacimiento = this.modelo.getFechaNacimiento().clone();
            fechaNacimiento.setTipo(new Type(newFechaNacimiento));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(fechaNacimiento), this.modelo.getId())) {
                this.modelo.setFechaNacimiento(fechaNacimiento);
                this.modeloHasChange = true;
            }
        }
    }

    public void insertOrUpdateSexo(String newSexo) {
        if (this.modelo.getSexo() == null) {
            SocialHistory sexo;
            String nuevoId;
            if (!newSexo.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(sexo = new SocialHistory("Sexo", newSexo)), this.modelo.getId())) != null) {
                sexo.setIdInterno(nuevoId);
                this.modelo.setSexo(sexo);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getSexo().getTipo().getType().equalsIgnoreCase(newSexo)) {
            SocialHistory sexo = this.modelo.getSexo().clone();
            sexo.setTipo(new Type(newSexo));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(sexo), this.modelo.getId())) {
                this.modelo.setSexo(sexo);
                this.modeloHasChange = true;
            }
        }
    }

    public void insertOrUpdateDireccion(String newDireccion) {
        if (this.modelo.getDireccion() == null) {
            SocialHistory direccion;
            String nuevoId;
            if (!newDireccion.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(direccion = new SocialHistory("Direccion", newDireccion)), this.modelo.getId())) != null) {
                direccion.setIdInterno(nuevoId);
                this.modelo.setDireccion(direccion);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getDireccion().getTipo().getType().equalsIgnoreCase(newDireccion)) {
            SocialHistory direccion = this.modelo.getDireccion().clone();
            direccion.setTipo(new Type(newDireccion));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(direccion), this.modelo.getId())) {
                this.modelo.setDireccion(direccion);
                this.modeloHasChange = true;
            }
        }
    }

    public void insertOrUpdateLocalidad(String newLocalidad) {
        if (this.modelo.getLocalidad() == null) {
            SocialHistory localidad;
            String nuevoId;
            if (!newLocalidad.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(localidad = new SocialHistory("Localidad", newLocalidad)), this.modelo.getId())) != null) {
                localidad.setIdInterno(nuevoId);
                this.modelo.setLocalidad(localidad);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getLocalidad().getTipo().getType().equalsIgnoreCase(newLocalidad)) {
            SocialHistory localidad = this.modelo.getLocalidad().clone();
            localidad.setTipo(new Type(newLocalidad));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(localidad), this.modelo.getId())) {
                this.modelo.setLocalidad(localidad);
                this.modeloHasChange = true;
            }
        }
    }

    public String darFormatoFecha(String fecha) {
        String hora = "0";
        String min = "0";
        if (hora.length() == 1) {
            hora = "0" + hora;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        fecha = fecha + "T" + hora + ":" + min + ":00Z";
        return fecha;
    }

    public void insertOrUpdateDiabetes(String tipoDiabetes, int edadDiagnostico) {
        ProblemsDAOGH dao;
        if (this.modelo.getDiabetes() == null) {
            if (!tipoDiabetes.isEmpty()) {
                SimpleDateFormat formato = new SimpleDateFormat("yyyy-MM-dd");
                String fecha = formato.format(this.calcularFechaDiagnostico(edadDiagnostico).getTime());
                Problemas diabetes = new Problemas(fecha = this.darFormatoFecha(fecha), "", tipoDiabetes);
                String nuevoId = new ProblemsDAOGH().insertProblem(new ProblemsDTO(diabetes), this.modelo.getId());
                if (nuevoId != null) {
                    diabetes.setIdInterno(nuevoId);
                    this.modelo.setDiabetes(diabetes);
                    this.modeloHasChange = true;
                }
            }
        } else if ((!this.modelo.getDiabetes().getDescripcionProblema().getText().equalsIgnoreCase(tipoDiabetes) || this.calcularEdadDiagnostico() != edadDiagnostico) && (dao = new ProblemsDAOGH()).removeProblem(new ProblemsDTO(this.modelo.getDiabetes()), this.modelo.getId())) {
            this.modelo.setDiabetes(null);
            this.modeloHasChange = true;
            this.insertOrUpdateDiabetes(tipoDiabetes, edadDiagnostico);
        }
    }

    public void insertOrUpdateEnfermedades(String enfermedad, boolean estado) {
        ProblemsDAOGH dao;
        if (estado && this.modelo.getEnfermedades().get(enfermedad) == null) {
            Problemas problema = new Problemas(enfermedad, "activo");
            String nuevoId = new ProblemsDAOGH().insertProblem(new ProblemsDTO(problema), this.modelo.getId());
            if (nuevoId != null) {
                problema.setIdInterno(nuevoId);
                this.modelo.setEnfermedades(enfermedad, problema);
                this.modeloHasChange = true;
            }
        } else if (!estado && this.modelo.getEnfermedades().get(enfermedad) != null && (dao = new ProblemsDAOGH()).removeProblem(new ProblemsDTO(this.modelo.getEnfermedades(enfermedad)), this.modelo.getId())) {
            this.modelo.removeEnfermedades(enfermedad);
            this.modeloHasChange = true;
        }
    }

    public void insertOrUpdateOtrasEnfermedades(String otraEnfermedad, String fechaInicio, String fechaFin) {
        if (!this.modelo.isOtrasEnfermedades(otraEnfermedad)) {
            Problemas problema = new Problemas(otraEnfermedad, fechaInicio, fechaFin, "activo");
            String nuevoId = new ProblemsDAOGH().insertProblem(new ProblemsDTO(problema), this.modelo.getId());
            if (nuevoId != null) {
                problema.setIdInterno(nuevoId);
                this.modelo.addNewOtrasEnfermedades(problema);
                this.modeloHasChange = true;
            }
        } else {
            Problemas nuevoProblema;
            Problemas problema = this.modelo.getOtrasEnfermedades(otraEnfermedad);
            if (!problema.equals(nuevoProblema = new Problemas(otraEnfermedad, fechaInicio, fechaFin, "activo"))) {
                problema.setFechaInicio(new DateTime(fechaInicio, "Start date"));
                problema.setFechaFin(new DateTime(fechaFin, "Stop date"));
                if (new ProblemsDAOGH().updateProblem(new ProblemsDTO(problema), this.modelo.getId())) {
                    this.modelo.updateOtrasEnfermedades(problema);
                    this.modeloHasChange = true;
                }
            }
        }
    }

    public void deleteOtrasEnfermedades(String otraEnfermedad, boolean estado) {
        ProblemsDAOGH dao;
        if (!estado && this.modelo.isOtrasEnfermedades(otraEnfermedad) && (dao = new ProblemsDAOGH()).removeProblem(new ProblemsDTO(this.modelo.getOtrasEnfermedades(otraEnfermedad)), this.modelo.getId())) {
            this.modelo.removeOtrasEnfermedades(otraEnfermedad);
            this.modeloHasChange = true;
        }
    }

    public void insertNewAnalisis(String tipoAnalisis, Date fecha, String alimento, String valor, String unidades, String observaciones) {
        Analisis analisis = new Analisis(tipoAnalisis, fecha, alimento, valor, unidades, observaciones);
        String nuevoId = new AnalisisDAOGH().insertNewAnalisis(new AnalisisDTO(analisis), this.modelo.getId());
        if (nuevoId != null) {
            analisis.setIdInterno(nuevoId);
            if (tipoAnalisis.equalsIgnoreCase("Cuerpos Cetonicos")) {
                this.modelo.setCuerposCetonicos(analisis);
            } else if (tipoAnalisis.equalsIgnoreCase("Peso")) {
                this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getPeso());
            } else if (tipoAnalisis.equalsIgnoreCase("Altura")) {
                this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getAltura());
            } else if (tipoAnalisis.equalsIgnoreCase("IMC")) {
                this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getImc());
            }
            this.modeloHasChange = true;
        }
    }

    public boolean insertNewAnalisis(Analisis analisis) {
        if (analisis.getTipoAnalisis().equalsIgnoreCase("Comidas")) {
            this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getComidas());
            this.modeloHasChange = true;
            return true;
        }
        if (analisis.getTipoAnalisis().equalsIgnoreCase("Cuerpos Cetonicos")) {
            this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getListaCuerposCetonicos());
            this.modeloHasChange = true;
            return true;
        }
        if (analisis.getTipoAnalisis().equalsIgnoreCase("Insulina")) {
            this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getInsulinasInyectadas());
            this.modeloHasChange = true;
            return true;
        }
        if (analisis.getTipoAnalisis().equalsIgnoreCase("Analitica")) {
            this.modelo.insertarNuevoElemEnTabla(analisis, this.modelo.getTablaAnaliticas());
            this.modeloHasChange = true;
            return true;
        }
        if (analisis.getTipoAnalisis().equalsIgnoreCase("Glucemia")) {
            this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getListaGlucemias());
            this.modeloHasChange = true;
            return true;
        }
        if (analisis.getTipoAnalisis().equalsIgnoreCase("Fondo de Ojo")) {
            this.modelo.insertarNuevoElemEnLista(analisis, this.modelo.getListaFondoOjos());
            this.modeloHasChange = true;
            return true;
        }
        return false;
    }

    public void insertNewMedicamento(Medicamento medicamento) {
        this.modelo.addMedicamentoToListaMedicamentos(medicamento);
        this.modeloHasChange = true;
    }

    public void insertNewEnfermedad(Problemas enfermedad) {
        this.modelo.addNewOtrasEnfermedades(enfermedad);
        this.modeloHasChange = true;
    }

    public void insertNewMedicationInsulina(String productName, String estado, String fechaInicio, String fechaFin) {
        Medicamento insulina = new Medicamento(productName, fechaInicio, fechaFin, estado);
        String nuevoId = new MedicamentosDAOGH().insertMedication(new MedicamentoDTO(insulina), this.modelo.getId());
        if (nuevoId != null) {
            insulina.setIdInterno(nuevoId);
            this.modelo.setInsulina(insulina);
            this.modeloHasChange = false;
        }
    }

    public void insertNewMedication(String productName, boolean estado, String fechaInicio, String fechaFin, String fechaReceta, String cantidad, String forma, String valor, String unidades, String via, String frecuencia, String fechaRellenado, String valorF, String unidadesF) {
        Medicamento medicamento = new Medicamento(productName, estado, fechaInicio, fechaFin, fechaReceta, cantidad, unidades, forma, valor, unidades, via, frecuencia, fechaRellenado, valorF, unidadesF);
        String nuevoId = new MedicamentosDAOGH().insertMedication(new MedicamentoDTO(medicamento), this.modelo.getId());
        if (nuevoId != null) {
            medicamento.setIdInterno(nuevoId);
            this.modelo.setMedicamentos(medicamento);
            this.modeloHasChange = true;
            JOptionPane.showMessageDialog(null, "Guardado con exito");
        }
    }

    public void insertOrUpdateTelefono1(String newTelefono1) {
        if (this.modelo.getTelefono1() == null) {
            SocialHistory telefono1;
            String nuevoId;
            if (!newTelefono1.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(telefono1 = new SocialHistory("Telefono1", newTelefono1)), this.modelo.getId())) != null) {
                telefono1.setIdInterno(nuevoId);
                this.modelo.setTelefono1(telefono1);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getTelefono1().getTipo().getType().equalsIgnoreCase(newTelefono1)) {
            SocialHistory telefono1 = this.modelo.getTelefono1().clone();
            telefono1.setTipo(new Type(newTelefono1));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(telefono1), this.modelo.getId())) {
                this.modelo.setTelefono1(telefono1);
                this.modeloHasChange = true;
            }
        }
    }

    public void insertOrUpdateTelefono2(String newTelefono2) {
        if (this.modelo.getTelefono2() == null) {
            SocialHistory telefono2;
            String nuevoId;
            if (!newTelefono2.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(telefono2 = new SocialHistory("Telefono2", newTelefono2)), this.modelo.getId())) != null) {
                telefono2.setIdInterno(nuevoId);
                this.modelo.setTelefono2(telefono2);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getTelefono2().getTipo().getType().equalsIgnoreCase(newTelefono2)) {
            SocialHistory telefono2 = this.modelo.getTelefono2().clone();
            telefono2.setTipo(new Type(newTelefono2));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(telefono2), this.modelo.getId())) {
                this.modelo.setTelefono2(telefono2);
                this.modeloHasChange = true;
            }
        }
    }

    public void insertOrUpdateEmail(String newEmail) {
        if (this.modelo.getEmail() == null) {
            SocialHistory email;
            String nuevoId;
            if (!newEmail.isEmpty() && (nuevoId = new SocialHistoryDAOGH().insertSocialHistory(new SocialHistoryDTO(email = new SocialHistory("Email", newEmail)), this.modelo.getId())) != null) {
                email.setIdInterno(nuevoId);
                this.modelo.setEmail(email);
                this.modeloHasChange = true;
            }
        } else if (!this.modelo.getEmail().getTipo().getType().equalsIgnoreCase(newEmail)) {
            SocialHistory email = this.modelo.getEmail().clone();
            email.setTipo(new Type(newEmail));
            if (new SocialHistoryDAOGH().updateSocialHistory(new SocialHistoryDTO(email), this.modelo.getId())) {
                this.modelo.setEmail(email);
                this.modeloHasChange = true;
            }
        }
    }

    public int calcularEdadDiagnostico() {
        int dia;
        String[] fechaPartida = this.modelo.getFechaNacimiento().getTipo().getType().split("-");
        int anioNacimiento = Integer.parseInt(fechaPartida[0]);
        int mesNacimiento = Integer.parseInt(fechaPartida[1]);
        int diaNacimiento = Integer.parseInt(fechaPartida[2].split("T")[0]);
        String[] fechaDiagnostico = this.modelo.getDiabetes().getFechaInicio().getExactDateTime().split("-");
        int anioDiagnostico = Integer.parseInt(fechaDiagnostico[0]);
        int mesDiagnostico = Integer.parseInt(fechaDiagnostico[1]);
        int diaDiagnostico = Integer.parseInt(fechaDiagnostico[2].split("T")[0]);
        int anos = anioDiagnostico - anioNacimiento;
        int mes = mesDiagnostico - mesNacimiento;
        if (mes < 0) {
            --anos;
        } else if (mes == 0 && (dia = diaDiagnostico - diaNacimiento) > 0) {
            --anos;
        }
        return anos;
    }

    public GregorianCalendar calcularFechaDiagnostico(int edadDiagnostico) {
        String[] fechaPartida = this.modelo.getFechaNacimiento().getTipo().getType().split("-");
        int anioNacimiento = Integer.parseInt(fechaPartida[0]);
        int mesNacimiento = Integer.parseInt(fechaPartida[1]);
        int diaNacimiento = Integer.parseInt(fechaPartida[2].split("T")[0]);
        GregorianCalendar fechaActual = new GregorianCalendar();
        fechaActual.set(anioNacimiento + edadDiagnostico, mesNacimiento, diaNacimiento);
        return fechaActual;
    }
}

