/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorAnalisisView;
import Application.Herramientas.CommonTools;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Interfaces.AnalisisView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;

public class DialogoDetallesAnalitica
extends JDialog
implements AnalisisView {
    ControladorAnalisisView controlador;
    boolean saved;
    private JButton BotonCerrar;
    private JButton botonGuardar;
    private JDateChooser dateChooserFechaAnalitica;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel labelPregunta;
    private JTable tablaResultados;

    private DialogoDetallesAnalitica(Frame parent, boolean modal, Analisis analitica, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        this.controlador = new ControladorAnalisisView(idPacienteOwner, analitica);
        this.cargarDatos();
        this.getContentPane().setBackground(Color.white);
        this.saved = true;
        this.botonGuardar.setVisible(false);
        this.tablaResultados.setEnabled(false);
        this.dateChooserFechaAnalitica.getCalendarButton().setEnabled(false);
        CommonTools.centrarVentana(this);
    }

    private DialogoDetallesAnalitica(Frame parent, boolean modal, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        Analisis nuevaAnalitica = new Analisis();
        nuevaAnalitica.setTipoAnalisis("Analitica");
        this.controlador = new ControladorAnalisisView(idPacienteOwner, nuevaAnalitica);
        this.saved = false;
        this.rellenarDatosCompleto();
        CommonTools.centrarVentana(this);
    }

    public static Analisis showDialogCrearNuevaAnalitica(String idPacienteOwner) {
        DialogoDetallesAnalitica dialog = new DialogoDetallesAnalitica(null, true, idPacienteOwner);
        return dialog.getAnalitica();
    }

    public static void showDialogDetallesAnalitica(String idPacienteOwner, Analisis analitica) {
        DialogoDetallesAnalitica dialog = new DialogoDetallesAnalitica(null, true, analitica, idPacienteOwner);
    }

    private void rellenarDatosCompleto() {
        DefaultTableModel model = (DefaultTableModel)this.tablaResultados.getModel();
        Object[][] dataVector = new Object[][]{{"HbA1c", null, "%", "< 6%"}, {"Glucemia", null, "mg/dl", "< 100 mg/dl"}, {"Colesterol", null, "mg/dl", "< 200 mg/dl"}, {"Colesterol LDL", null, "mg/dl", "< 160 mg/dl"}, {"Colesterol HDL", null, "mg/dl", " [35 - 60] mg/dl"}, {"Triglic\u00e9ridos", null, "mg/dl", "< 200 mg/dl"}, {"TSH", null, "uU/ml", "?? uU/ml"}, {"T4", null, "ng/dl", "?? ng/dl"}, {"Creatinina", null, "mg/dl", " ?? mg/dl"}, {"Hemoglobina", null, "g/dl", " ?? g/dl"}, {"VCM", null, "fL", " ?? fL"}};
        model.setDataVector(dataVector, new String[]{"Par\u00e1metros", "Valor", "Unidades", "Valor normal"});
    }

    private void cargarDatos() {
        this.dateChooserFechaAnalitica.setDate(this.controlador.getModelo().getResultadosTest().get(0).getFecha());
        DefaultTableModel model = (DefaultTableModel)this.tablaResultados.getModel();
        for (ResultadoTest res : this.controlador.getModelo().getResultadosTest()) {
            Object[] data = new Object[]{res.getTipoTest(), Double.parseDouble(res.getValorObtenido()), res.getUnidadesObtenido(), res.getValorNormal()};
            model.addRow(data);
        }
    }

    public void updateView() {
        this.rellenarDatosCompleto();
    }

    private String comprobarDatos() {
        String errores = "";
        if (this.dateChooserFechaAnalitica.getDate() != null) {
            Date fechaAnalitica = this.dateChooserFechaAnalitica.getDate();
            this.controlador.getModelo().setTipoAnalisis("Analitica");
            int resultIntroducidos = 0;
            for (int i = 0; i < this.tablaResultados.getRowCount(); ++i) {
                if (this.tablaResultados.getValueAt(i, 1) == null) continue;
                ResultadoTest res = new ResultadoTest();
                res.setFecha(fechaAnalitica);
                res.setTipoFecha("Collection start date");
                res.setTipoTest((String)this.tablaResultados.getValueAt(i, 0));
                res.setUnidadesObtenido((String)this.tablaResultados.getValueAt(i, 2));
                res.setValorNormal((String)this.tablaResultados.getValueAt(i, 3));
                res.setValorObtenido("" + (Double)this.tablaResultados.getValueAt(i, 1));
                this.controlador.getModelo().insertNewResultTest(res);
                ++resultIntroducidos;
            }
            if (resultIntroducidos == 0) {
                errores = errores + "\tNo se ha introducido ning\u00fan valor\n";
            }
        } else {
            errores = errores + "\tFecha err\u00f3nea o en blanco. \n";
        }
        return errores;
    }

    private Analisis getAnalitica() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    private void initComponents() {
        this.dateChooserFechaAnalitica = new JDateChooser();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tablaResultados = new JTable();
        this.BotonCerrar = new JButton();
        this.botonGuardar = new JButton();
        this.labelPregunta = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Analitica de paciente");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 110, 0, 0);
        this.getContentPane().add((Component)this.dateChooserFechaAnalitica, gridBagConstraints);
        this.jLabel1.setText("Fecha de anal\u00edtica:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.tablaResultados.setModel(new DefaultTableModel(new Object[0][], new String[]{"Par\u00e1metros", "Valor", "Unidades", "Valor normal"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class, String.class, String.class};
                this.canEdit = new boolean[]{true, true, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablaResultados.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tablaResultados);
        this.tablaResultados.getColumnModel().getColumn(0).setResizable(false);
        this.tablaResultados.getColumnModel().getColumn(1).setResizable(false);
        this.tablaResultados.getColumnModel().getColumn(2).setResizable(false);
        this.tablaResultados.getColumnModel().getColumn(3).setResizable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 10, 0, 10);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.BotonCerrar.setBackground(new Color(255, 255, 255));
        this.BotonCerrar.setFont(new Font("Trebuchet MS", 1, 14));
        this.BotonCerrar.setForeground(new Color(0, 102, 255));
        this.BotonCerrar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.BotonCerrar.setText("Cerrar");
        this.BotonCerrar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.BotonCerrar.setContentAreaFilled(false);
        this.BotonCerrar.setHorizontalAlignment(2);
        this.BotonCerrar.setMaximumSize(new Dimension(90, 24));
        this.BotonCerrar.setMinimumSize(new Dimension(90, 24));
        this.BotonCerrar.setPreferredSize(new Dimension(90, 24));
        this.BotonCerrar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesAnalitica.this.BotonCerrarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 11, 11);
        this.getContentPane().add((Component)this.BotonCerrar, gridBagConstraints);
        this.botonGuardar.setBackground(new Color(255, 255, 255));
        this.botonGuardar.setFont(new Font("Trebuchet MS", 1, 14));
        this.botonGuardar.setForeground(new Color(0, 102, 255));
        this.botonGuardar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.botonGuardar.setText("Guardar");
        this.botonGuardar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.botonGuardar.setContentAreaFilled(false);
        this.botonGuardar.setHorizontalAlignment(2);
        this.botonGuardar.setMaximumSize(new Dimension(90, 24));
        this.botonGuardar.setMinimumSize(new Dimension(90, 24));
        this.botonGuardar.setPreferredSize(new Dimension(90, 24));
        this.botonGuardar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesAnalitica.this.botonGuardarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 177, 11, 111);
        this.getContentPane().add((Component)this.botonGuardar, gridBagConstraints);
        this.labelPregunta.setBackground(new Color(0, 153, 255));
        this.labelPregunta.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelPregunta.setForeground(new Color(255, 255, 255));
        this.labelPregunta.setText("Anal\u00edtica");
        this.labelPregunta.setMaximumSize(new Dimension(400, 40));
        this.labelPregunta.setMinimumSize(new Dimension(400, 40));
        this.labelPregunta.setOpaque(true);
        this.labelPregunta.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.labelPregunta, gridBagConstraints);
        this.pack();
    }

    private void botonGuardarActionPerformed(ActionEvent evt) {
        String erroresEncontrados = this.comprobarDatos();
        if (erroresEncontrados.isEmpty()) {
            if (this.controlador.insertarAnalisisVariosResultados()) {
                this.saved = true;
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Error al guardar la anal\u00edtica, por favor, vuelva a intentarlo", "Atenci\u00f3n, error al guardar", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + erroresEncontrados, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    private void BotonCerrarActionPerformed(ActionEvent evt) {
        if (!this.saved) {
            int option = JOptionPane.showConfirmDialog(this, "No se han guardado los cambios, \u00bfSeguro que desea cerrar sin guardar?", "\u00a1Atenci\u00f3n, cambios no guardados!", 2);
            if (option == 0) {
                this.saved = false;
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }
}

