/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorAnalisisView;
import Application.Herramientas.CommonTools;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Interfaces.AnalisisView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class DialogoNuevaComida
extends JDialog
implements AnalisisView {
    ControladorAnalisisView controlador;
    boolean saved;
    private JToggleButton buttonAceptar;
    private JToggleButton buttonCancelar;
    private JDateChooser dateChooserFechaComida;
    private JLabel labelAlimento;
    private JLabel labelComentario;
    private JLabel labelFecha;
    private JLabel labelGramos;
    private JLabel labelHidratosCarbono;
    private JLabel labelHora;
    private JLabel labelTitulo1;
    private JSpinner spinnerHidratosCarbono;
    private JSpinner spinnerHora;
    private TextArea textAreaComentario;
    private JTextField textFieldAlimento;

    private DialogoNuevaComida(Frame parent, boolean modal, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.controlador = new ControladorAnalisisView(idPacienteOwner, new Analisis());
        this.saved = false;
        CommonTools.centrarVentana(this);
    }

    public static Analisis showDialogNuevaComida(String idPacienteOwner) {
        DialogoNuevaComida dialog = new DialogoNuevaComida(null, true, idPacienteOwner);
        return dialog.getComida();
    }

    private Analisis getComida() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    private String comprobarDatos() {
        if (this.dateChooserFechaComida.getDate() != null) {
            Date fechaToma = this.dateChooserFechaComida.getDate();
            this.controlador.getModelo().setTipoAnalisis("Comidas");
            fechaToma.setHours(((Date)this.spinnerHora.getValue()).getHours());
            fechaToma.setMinutes(((Date)this.spinnerHora.getValue()).getMinutes());
            if (fechaToma.after(new Date())) {
                return "\tLa fecha de la nueva medida no puede ser posterior a la fecha actual. \n";
            }
            ResultadoTest res = new ResultadoTest();
            res.setFecha(fechaToma);
            res.setTipoFecha("Collection start date");
            res.setUnidadesObtenido("g");
            res.setValorNormal("");
            if (this.textFieldAlimento.getText().isEmpty()) {
                return "\tNombre de alimento err\u00f3neo o en blanco. \n";
            }
            res.setTipoTest(this.textFieldAlimento.getText());
            if ((Double)this.spinnerHidratosCarbono.getValue() <= 0.0) {
                return "\tValor de hidratos de carbono err\u00f3neo o en blanco. \n";
            }
            res.setValorObtenido("" + (Double)this.spinnerHidratosCarbono.getValue());
            res.setObservaciones(this.textAreaComentario.getText());
            this.controlador.getModelo().insertNewResultTest(res);
            return null;
        }
        return "\tFecha err\u00f3nea o en blanco. \n";
    }

    private void initComponents() {
        this.textAreaComentario = new TextArea();
        this.spinnerHidratosCarbono = new JSpinner();
        this.textFieldAlimento = new JTextField();
        this.dateChooserFechaComida = new JDateChooser();
        this.buttonCancelar = new JToggleButton();
        this.buttonAceptar = new JToggleButton();
        this.labelComentario = new JLabel();
        this.labelHora = new JLabel();
        this.labelHidratosCarbono = new JLabel();
        this.labelAlimento = new JLabel();
        this.labelFecha = new JLabel();
        this.spinnerHora = new JSpinner();
        this.labelTitulo1 = new JLabel();
        this.labelGramos = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Registrar nueva comida");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(561, 278));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 49;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 17, 0, 16);
        this.getContentPane().add((Component)this.textAreaComentario, gridBagConstraints);
        this.spinnerHidratosCarbono.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.spinnerHidratosCarbono.setMinimumSize(new Dimension(50, 20));
        this.spinnerHidratosCarbono.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 22;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.spinnerHidratosCarbono, gridBagConstraints);
        this.textFieldAlimento.setToolTipText("\"Describe el alimento ingerido\"");
        this.textFieldAlimento.setMinimumSize(new Dimension(200, 20));
        this.textFieldAlimento.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 58;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.textFieldAlimento, gridBagConstraints);
        this.dateChooserFechaComida.setToolTipText("Fecha de la ingesta del alimento");
        this.dateChooserFechaComida.setMinimumSize(new Dimension(150, 20));
        this.dateChooserFechaComida.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.dateChooserFechaComida, gridBagConstraints);
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 6, 14);
        this.getContentPane().add((Component)this.buttonCancelar, gridBagConstraints);
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonAceptar.setForeground(new Color(0, 102, 255));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaComida.this.buttonAceptarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 6, 100);
        this.getContentPane().add((Component)this.buttonAceptar, gridBagConstraints);
        this.labelComentario.setFont(new Font("Verdana", 0, 12));
        this.labelComentario.setText("Comentario:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.getContentPane().add((Component)this.labelComentario, gridBagConstraints);
        this.labelHora.setFont(new Font("Verdana", 0, 12));
        this.labelHora.setText("Hora");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.labelHora, gridBagConstraints);
        this.labelHidratosCarbono.setFont(new Font("Verdana", 0, 12));
        this.labelHidratosCarbono.setText("Hidratos de carbono");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 22, 0, 0);
        this.getContentPane().add((Component)this.labelHidratosCarbono, gridBagConstraints);
        this.labelAlimento.setFont(new Font("Verdana", 0, 12));
        this.labelAlimento.setText("Alimento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 23, 0, 0);
        this.getContentPane().add((Component)this.labelAlimento, gridBagConstraints);
        this.labelFecha.setFont(new Font("Verdana", 0, 12));
        this.labelFecha.setText("Fecha");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 24, 0, 0);
        this.getContentPane().add((Component)this.labelFecha, gridBagConstraints);
        this.spinnerHora.setModel(new SpinnerDateModel(new Date(), null, null, 10));
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinnerHora.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(new SimpleDateFormat("hh:00 a"));
        this.spinnerHora.setToolTipText("Hora de la ingesta");
        this.spinnerHora.setMinimumSize(new Dimension(70, 20));
        this.spinnerHora.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 39, 0, 0);
        this.getContentPane().add((Component)this.spinnerHora, gridBagConstraints);
        this.labelTitulo1.setBackground(new Color(0, 153, 255));
        this.labelTitulo1.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo1.setForeground(new Color(255, 255, 255));
        this.labelTitulo1.setText("Insertar nueva medida de dieta");
        this.labelTitulo1.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo1.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo1.setOpaque(true);
        this.labelTitulo1.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.labelTitulo1, gridBagConstraints);
        this.labelGramos.setText("gramos");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 8, 0, 0);
        this.getContentPane().add((Component)this.labelGramos, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        String erroresEncontrados = this.comprobarDatos();
        if (erroresEncontrados == null) {
            if (this.controlador.insertarAnalisis()) {
                this.saved = true;
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Error al guardar la nueva comida, por favor, vuelva a intentarlo", "Atenci\u00f3n, error al guardar", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + erroresEncontrados, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    public void updateView() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

