/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Actor;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.ClasesAuxiliares.TestResult;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.ResultadoTestDTO;
import com.google.code.ccr4j.ActorReferenceType;
import com.google.code.ccr4j.CodeType;
import com.google.code.ccr4j.CodedDescriptionType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.DateTimeType;
import com.google.code.ccr4j.NormalType;
import com.google.code.ccr4j.ResultType;
import com.google.code.ccr4j.SourceType;
import com.google.code.ccr4j.TestResultType;
import com.google.code.ccr4j.TestType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalisisInterpreter {
    public ArrayList<AnalisisDTO> translateCCRtoDTO(String XMLData) throws XmlException {
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)(XMLData = this.formatearCodigoXML(XMLData)));
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.Results analisisDelPaciente = CCR.getBody().getResults();
        if (analisisDelPaciente != null) {
            List listaAnalisis = analisisDelPaciente.getResultList();
            Iterator it = listaAnalisis.iterator();
            ArrayList<AnalisisDTO> lista = new ArrayList<AnalisisDTO>();
            while (it.hasNext()) {
                ResultType resultado = (ResultType)it.next();
                AnalisisDTO analisis = this.translateResultTypeToAnalisisDTO(resultado);
                lista.add(analisis);
            }
            return lista;
        }
        return null;
    }

    private AnalisisDTO translateResultTypeToAnalisisDTO(ResultType resultado) {
        AnalisisDTO analisis = new AnalisisDTO();
        analisis.setIdObjeto(resultado.getCCRDataObjectID());
        analisis.setDescripcion(Description.getDescription(resultado.getDescription()));
        if (resultado.getDateTimeList() != null && !resultado.getDateTimeList().isEmpty()) {
            analisis.setFechaAnalisis(DateTime.getDate((DateTimeType)resultado.getDateTimeList().get(0)));
        }
        analisis.setIdObjeto(resultado.getCCRDataObjectID().split("-")[0]);
        analisis.setDatosMedico(Source.getSource(resultado.getSourceArray(0)));
        if (resultado.getTestList() != null) {
            for (TestType testAux : resultado.getTestList()) {
                ResultadoTestDTO test = new ResultadoTestDTO();
                test.setIdInterno(testAux.getCCRDataObjectID());
                test.setDescripcion(Description.getDescription(testAux.getDescription()));
                test.setTestDate(DateTime.getDate(testAux.getDateTimeArray(0)));
                if (testAux.getTestResult() != null) {
                    test.setResultadoTest(TestResult.getTestResult(testAux.getTestResult()));
                }
                if (testAux.getNormalResult() != null && !testAux.getNormalResult().getNormalList().isEmpty()) {
                    test.setNormalResult(TestResult.getTestResult((NormalType)testAux.getNormalResult().getNormalList().get(0)));
                }
                test.setDatosMedico(Source.getSource(testAux.getSourceArray(0)));
                analisis.insertarNuevoResultado(test);
            }
        }
        return analisis;
    }

    public String translateDTOtoCCR(AnalisisDTO dtoObject) {
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = ContinuityOfCareRecordDocument.Factory.newInstance().addNewContinuityOfCareRecord();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.Results results = CCR.addNewBody().addNewResults();
        ResultType newResult = results.addNewResult();
        if (dtoObject.getDescripcion() != null) {
            CodedDescriptionType newDesc = newResult.addNewDescription();
            newDesc.setText(dtoObject.getDescripcion().getText());
        }
        int i = 0;
        for (ResultadoTestDTO test : dtoObject.getResultadosDelAnalisis()) {
            this.insertNewTestResultIntoNewAnalisis(newResult, test, i, dtoObject.getIdObjeto());
            ++i;
        }
        return CCR.xmlText();
    }

    private void insertNewTestResultIntoNewAnalisis(ResultType result, ResultadoTestDTO resultado, int numTest, String idAnalisis) {
        TestType _newTest = result.addNewTest();
        this.newAnalisis_DateTime(_newTest, resultado.getTestDate());
        this.newAnalisis_Description(_newTest, resultado.getDescripcion());
        this.newAnalisis_TestResult(_newTest, resultado.getResultadoTest());
        this.newAnalisis_NormalTestResult(_newTest, resultado.getNormalResult());
        this.newAnalisis_Source(_newTest, resultado.getDatosMedico());
    }

    private DateTimeType newAnalisis_DateTime(TestType newTest, DateTime fechaInicio) {
        DateTimeType newDateTime = newTest.addNewDateTime();
        CodedDescriptionType newType = newDateTime.addNewType();
        newDateTime.setExactDateTime(fechaInicio.getExactDateTime());
        newType.setText(fechaInicio.getType());
        return newDateTime;
    }

    private CodedDescriptionType newAnalisis_Description(TestType newTest, Description _description) {
        CodedDescriptionType description = newTest.addNewDescription();
        description.setText(_description.getText());
        if (_description.getCodes() != null) {
            Iterator<DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType> it = _description.getCodes().iterator();
            boolean i = false;
            while (it.hasNext()) {
                DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType e = it.next();
                CodeType c = description.addNewCode();
                c.setValue(e.getValue());
                c.setCodingSystem(e.getCodingSystem());
            }
        }
        return description;
    }

    private TestResultType newAnalisis_TestResult(TestType newTest, TestResult _testResult) {
        TestResultType testResult = newTest.addNewTestResult();
        testResult.setValue(_testResult.getValue());
        testResult.addNewUnits().setUnit(_testResult.getUnits());
        return testResult;
    }

    private NormalType newAnalisis_NormalTestResult(TestType newTest, TestResult _normalResult) {
        if (_normalResult == null) {
            return null;
        }
        NormalType normalResult = newTest.addNewNormalResult().addNewNormal();
        normalResult.setValue(_normalResult.getValue());
        normalResult.addNewUnits().setUnit(_normalResult.getUnits());
        return normalResult;
    }

    private SourceType newAnalisis_Source(TestType newTest, Source _source) {
        if (_source == null) {
            return null;
        }
        SourceType source = newTest.addNewSource();
        Iterator<Actor> it = _source.getActors().iterator();
        while (it.hasNext()) {
            ActorReferenceType _newActor = source.addNewActor();
            Actor actor = it.next();
            String id = actor.getId();
            _newActor.setActorID(actor.getId());
            _newActor.addNewActorRole().setText(actor.getRole().get(0));
        }
        return source;
    }

    private String formatearCodigoXML(String content) {
        content = content.replace("<xml-fragment>", "");
        content = content.replace("</xml-fragment>", "");
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

