/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Type;
import DataManager.GoogleHealthManager.DTOs.FunctionalStatusDTO;
import com.google.code.ccr4j.CodeType;
import com.google.code.ccr4j.CodedDescriptionType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.FunctionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalStatusInterpreter {
    public ArrayList<FunctionalStatusDTO> translateCCRtoDTO(String dataCCRAsString) throws XmlException {
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)(dataCCRAsString = this.formatearCodigoXML(dataCCRAsString)));
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        if (CCR.getBody().getFunctionalStatus() != null) {
            List FunctionalStatusList = CCR.getBody().getFunctionalStatus().getFunctionList();
            Iterator it = FunctionalStatusList.iterator();
            ArrayList<FunctionalStatusDTO> lista = new ArrayList<FunctionalStatusDTO>();
            while (it.hasNext()) {
                FunctionType _functionalStatus = (FunctionType)it.next();
                FunctionalStatusDTO functionalStatus = this.getFunctionalStatus(_functionalStatus);
                functionalStatus.setIdInterno(_functionalStatus.getCCRDataObjectID().split("-")[0]);
                lista.add(functionalStatus);
            }
            return lista;
        }
        return null;
    }

    public String translateDTOtoCCR(FunctionalStatusDTO functional) {
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Factory.newInstance();
        CCR.addNewBody();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.FunctionalStatus functionalStatus = CCR.getBody().addNewFunctionalStatus();
        FunctionType newFunctionalStatus = functionalStatus.addNewFunction();
        this.translateFunctionalStatusToCCR(newFunctionalStatus, functional);
        return CCR.xmlText();
    }

    private void translateFunctionalStatusToCCR(FunctionType newFunctionalStatus, FunctionalStatusDTO functionalStatus) {
        this._newFunctionalStatus_Type(functionalStatus.getType(), newFunctionalStatus);
        this._newFunctionalStatus_Status(functionalStatus.getEstado(), newFunctionalStatus);
        this._newFunctionalStatus_Description(functionalStatus.getDescription(), newFunctionalStatus);
    }

    private void _newFunctionalStatus_Type(Type type, FunctionType newFunctionalStatus) {
        if (type != null) {
            CodedDescriptionType addNewType = newFunctionalStatus.addNewType();
            addNewType.setText(type.getType());
        }
    }

    private void _newFunctionalStatus_Status(Status estado, FunctionType newFunctionalStatus) {
        if (estado != null) {
            CodedDescriptionType addNewStatus = newFunctionalStatus.addNewStatus();
            addNewStatus.setText(estado.getEstado());
        }
    }

    private CodedDescriptionType _newFunctionalStatus_Description(Description _description, FunctionType newFunctionalStatus) {
        CodedDescriptionType description = newFunctionalStatus.addNewDescription();
        description.setText(_description.getText());
        if (_description.getCodes() != null) {
            Iterator<DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType> it = _description.getCodes().iterator();
            boolean i = false;
            while (it.hasNext()) {
                DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType e = it.next();
                CodeType c = description.addNewCode();
                c.setValue(e.getValue());
                c.setCodingSystem(e.getCodingSystem());
            }
        }
        return description;
    }

    private FunctionalStatusDTO getFunctionalStatus(FunctionType functionalStatus) {
        CodedDescriptionType type;
        FunctionalStatusDTO f = new FunctionalStatusDTO();
        f.setDescription(Description.getDescription(functionalStatus.getDescription()));
        CodedDescriptionType status = functionalStatus.getStatus();
        if (status != null) {
            Status estado = Status.getStatus(status);
            f.setEstado(estado);
        }
        if ((type = functionalStatus.getType()) != null) {
            Type _type = Type.getType(type);
            f.setType(_type);
        }
        return f;
    }

    public String formatearCodigoXML(String content) {
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

