/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.FunctionalStatusDTO;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import DataManager.GoogleHealthManager.DTOs.PacienteDTO;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import DataManager.GoogleHealthManager.DTOs.SocialHistoryDTO;
import DataManager.GoogleHealthManager.Interpreters.AnalisisInterpreter;
import DataManager.GoogleHealthManager.Interpreters.FunctionalStatusInterpreter;
import DataManager.GoogleHealthManager.Interpreters.MedicamentosInterpreter;
import DataManager.GoogleHealthManager.Interpreters.ProblemsInterpreter;
import DataManager.GoogleHealthManager.Interpreters.SocialHistoryInterpreter;
import com.google.code.ccr4j.ActorType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.ResultType;
import com.google.code.ccr4j.SocialHistoryType;
import com.google.code.ccr4j.TestType;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlException;

public class PacienteInterpreter {
    public PacienteDTO translateCCRtoDTO(String dataCCRAsString) throws XmlException {
        String dataCCRAsStringFormated = this.formatearCodigoXML(dataCCRAsString);
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)dataCCRAsStringFormated);
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        PacienteDTO paciente = new PacienteDTO();
        try {
            paciente.setFechaNacimiento(new DateTime(((ActorType)CCR.getActors().getActorList().get(0)).getPerson().getDateOfBirth().getExactDateTime(), ""));
        }
        catch (NullPointerException e) {
            paciente.setFechaNacimiento(null);
        }
        try {
            paciente.setSexo(((ActorType)CCR.getActors().getActorList().get(0)).getPerson().getGender().getText());
        }
        catch (NullPointerException e) {
            paciente.setSexo(null);
        }
        try {
            paciente.setRaza(((SocialHistoryType)CCR.getBody().getSocialHistory().getSocialHistoryElementList().get(0)).getDescription().getText());
        }
        catch (NullPointerException e) {
            paciente.setRaza(null);
        }
        try {
            paciente.setTipoSangre(((TestType)((ResultType)CCR.getBody().getVitalSigns().getResultList().get(0)).getTestList().get(0)).getTestResult().getValue());
        }
        catch (NullPointerException e) {
            paciente.setTipoSangre(null);
        }
        try {
            ArrayList<MedicamentoDTO> listaMedicamentos = new MedicamentosInterpreter().translateCCRtoDTO(dataCCRAsString);
            System.out.println("Medications retrieved successfully");
            paciente.setMedicamentos(listaMedicamentos);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArrayList<ProblemsDTO> listaProblemas = new ProblemsInterpreter().translateCCRtoDTO(dataCCRAsString);
            System.out.println("Problems retrieved successfully");
            paciente.setProblemas(listaProblemas);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArrayList<AnalisisDTO> listaAnalisis = new AnalisisInterpreter().translateCCRtoDTO(dataCCRAsString);
            System.out.println("Analisis retrieved successfully");
            paciente.setAnalisis(listaAnalisis);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArrayList<SocialHistoryDTO> listaSocialHistory = new SocialHistoryInterpreter().translateCCRtoDTO(dataCCRAsString);
            System.out.println("SocialHistories retrieved successfully");
            paciente.setSocialHistories(listaSocialHistory);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArrayList<FunctionalStatusDTO> listaFunctionalStatus = new FunctionalStatusInterpreter().translateCCRtoDTO(dataCCRAsString);
            System.out.println("Problems retrieved successfully");
            paciente.setFunctionalStatus(listaFunctionalStatus);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return paciente;
    }

    public String translateDTOtoCCR(PacienteDTO paciente) {
        throw new UnsupportedOperationException("Not supported yet by Google Health.");
    }

    public String formatearCodigoXML(String content) {
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

