/*
 * Decompiled with CFR 0.152.
 */
package Application.Controladores;

import Application.Modelos.Medicamento;
import Application.Vistas.Interfaces.MedicamentoView;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Product;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.DAOs.MedicamentosDAOGH;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import java.util.ArrayList;

public class ControladorMedicationView {
    Medicamento modelo;
    boolean modeloHasChange = false;
    String idPacienteOwner = "";

    public ControladorMedicationView(String idPaciente, Medicamento modelo) {
        this.modelo = modelo;
        this.idPacienteOwner = idPaciente;
    }

    public ControladorMedicationView(String idPaciente, String nombreMedicamento) {
        this.modelo = new Medicamento();
        ArrayList<Product> listaProds = new ArrayList<Product>();
        Product p = new Product();
        p.setProductName(nombreMedicamento);
        listaProds.add(p);
        this.modelo.setListaProductos(listaProds);
        this.idPacienteOwner = idPaciente;
    }

    public void addViewToModel(MedicamentoView view) {
        this.modelo.addView(view);
    }

    public Medicamento getModelo() {
        return this.modelo;
    }

    public void insertNewMedication(String productName, boolean estado, String fechaInicio, String fechaFin, String fechaReceta, String cantidad, String unidadesDosis, String forma, String valor, String unidades, String via, String frecuencia, String fechaRellenado, String valorF, String unidadesF) {
        if (estado) {
            this.modelo.setEstado(new Status("Active"));
        } else {
            this.modelo.setEstado(new Status("Inactive"));
        }
        this.modelo.setFechaInicio(fechaInicio);
        this.modelo.setFechaFin(fechaFin);
        this.modelo.setFechaReceta(fechaReceta);
        this.modelo.getListaProductos().get(0).addStrentgh(cantidad + " " + unidadesDosis);
        this.modelo.getListaProductos().get(0).addForm(forma);
        this.modelo.addPosologia(valor, unidades, via, frecuencia);
        String nuevoId = new MedicamentosDAOGH().insertMedication(new MedicamentoDTO(this.modelo), this.idPacienteOwner);
        if (nuevoId != null) {
            this.modelo.setIdInterno(nuevoId);
            this.modeloHasChange = false;
        }
    }
}

