/*
 * Decompiled with CFR 0.152.
 */
package Application.Herramientas;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class CommonTools {
    public static void centrarVentana(JDialog dialogo) {
        Dimension pantalla = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension ventana = dialogo.getSize();
        dialogo.setLocation((pantalla.width - ventana.width) / 2, (pantalla.height - ventana.height) / 2);
        dialogo.pack();
        dialogo.setVisible(true);
    }

    public static void centrarVentana(JFrame dialogo) {
        Dimension pantalla = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension ventana = dialogo.getSize();
        dialogo.setLocation((pantalla.width - ventana.width) / 2, (pantalla.height - ventana.height) / 2);
        dialogo.pack();
        dialogo.setVisible(true);
    }

    public static String getDateAsString(Date date) {
        String fechaFormateada = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (date != null) {
            fechaFormateada = sdf.format(date);
        }
        return fechaFormateada;
    }

    public static Date getStringAsDate(String date) {
        Date fechaFormateada = new Date();
        if (date != null) {
            if (!date.contains("T")) {
                String[] partesFecha = date.split("-");
                fechaFormateada = new GregorianCalendar(Integer.parseInt(partesFecha[0]), Integer.parseInt(partesFecha[1]) - 1, Integer.parseInt(partesFecha[2])).getTime();
            } else {
                String[] partesFecha = date.split("-");
                int year = Integer.parseInt(partesFecha[0]);
                int month = Integer.parseInt(partesFecha[1]) - 1;
                partesFecha = partesFecha[2].split("T");
                int day = Integer.parseInt(partesFecha[0]);
                partesFecha = partesFecha[1].split(":");
                int hour = Integer.parseInt(partesFecha[0]);
                int minute = Integer.parseInt(partesFecha[1]);
                fechaFormateada = new GregorianCalendar(year, month, day, hour, minute).getTime();
            }
        }
        return fechaFormateada;
    }

    public static String getDateAsStringZulu(Date fecha) {
        String hora = "" + fecha.getHours();
        String min = "" + fecha.getMinutes();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String fechaString = sdf.format(fecha);
        if (hora.length() == 1) {
            hora = "0" + hora;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        fechaString = fechaString + "T" + hora + ":" + min + ":00Z";
        return fechaString;
    }

    public static Date getStringZuluAsDate(String date) {
        Date fechaFormateada = new Date();
        if (date != null) {
            String[] partesFecha = date.split("-");
            int year = Integer.parseInt(partesFecha[0]);
            int month = Integer.parseInt(partesFecha[1]) - 1;
            partesFecha = partesFecha[2].split("T");
            int day = Integer.parseInt(partesFecha[0]);
            partesFecha = partesFecha[1].split(":");
            int hour = Integer.parseInt(partesFecha[0]);
            int minute = Integer.parseInt(partesFecha[1]);
            fechaFormateada = new GregorianCalendar(year, month, day, hour, minute).getTime();
        }
        return fechaFormateada;
    }
}

