/*
 * Decompiled with CFR 0.152.
 */
package Application.Herramientas;

import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.TableOrder;

public abstract class Grafica {
    protected static JFreeChart createChart(CategoryDataset dataset, TiposDeGrafico tipo, String titulo, String Columna, String fila) {
        JFreeChart chart;
        switch (tipo) {
            case AreaChart: {
                chart = ChartFactory.createAreaChart((String)titulo, (String)fila, (String)Columna, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case BarChart: {
                chart = ChartFactory.createBarChart((String)titulo, (String)fila, (String)Columna, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case BarChart3D: {
                chart = ChartFactory.createBarChart3D((String)titulo, (String)fila, (String)Columna, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case LineChart: {
                chart = ChartFactory.createLineChart((String)titulo, (String)fila, (String)Columna, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case LineChart3D: {
                chart = ChartFactory.createLineChart3D((String)titulo, (String)fila, (String)Columna, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case MultiplePieChart: {
                chart = ChartFactory.createMultiplePieChart((String)titulo, (CategoryDataset)dataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case MultiplePieChart3D: {
                chart = ChartFactory.createMultiplePieChart3D((String)titulo, (CategoryDataset)dataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            default: {
                chart = null;
            }
        }
        return chart;
    }

    protected void salvaGraficoEnFichero(JFreeChart chart, TiposDeGrafico tipo) {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            ChartUtilities.saveChartAsJPEG((File)new File(tmpDir + tipo.toString() + "BARCHART_JPG"), (JFreeChart)chart, (int)500, (int)300);
            System.out.println("Salvada imagen en " + tmpDir + tipo.toString() + "BARCHART_JPG");
        }
        catch (IOException e) {
            System.err.println("Error creando grafico.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TiposDeGrafico {
        AreaChart,
        BarChart,
        BarChart3D,
        LineChart,
        LineChart3D,
        MultiplePieChart,
        MultiplePieChart3D;

    }
}

