/*
 * Decompiled with CFR 0.152.
 */
package Application.Modelos;

import Application.Herramientas.CommonTools;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Interfaces.AnalisisView;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.ResultadoTestDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analisis {
    String idInterno = "";
    String tipoAnalisis = "";
    ArrayList<ResultadoTest> resultadosTest = new ArrayList();
    ArrayList<AnalisisView> views = new ArrayList();

    public Analisis() {
    }

    public Analisis(String tipoAnalisis, Date fecha, String alimento, String valor, String unidades, String observaciones) {
        this.tipoAnalisis = tipoAnalisis;
        ResultadoTest test = new ResultadoTest();
        test.setFecha(fecha);
        test.setTipoFecha("Collection start date");
        test.setTipoTest(alimento);
        test.setValorObtenido(valor);
        test.setUnidadesObtenido(unidades);
        test.setObservaciones(observaciones);
        this.resultadosTest.add(test);
    }

    public Analisis(AnalisisDTO analisisDTO) {
        this.idInterno = analisisDTO.getIdObjeto();
        this.tipoAnalisis = analisisDTO.getDescripcion().getText();
        for (ResultadoTestDTO testDTO : analisisDTO.getResultadosDelAnalisis()) {
            ResultadoTest test = new ResultadoTest();
            test.setIdInterno(testDTO.getIdInterno());
            test.setFecha(CommonTools.getStringAsDate(testDTO.getTestDate().getExactDateTime()));
            test.setTipoFecha(testDTO.getTestDate().getType());
            if (testDTO.getResultadoTest() != null) {
                test.setValorObtenido(testDTO.getResultadoTest().getValue());
                test.setUnidadesObtenido(testDTO.getResultadoTest().getUnits());
            }
            if (testDTO.getNormalResult() != null) {
                test.setValorNormal(testDTO.getNormalResult().getValue());
                test.setUnidadesNormal(testDTO.getNormalResult().getUnits());
            }
            String[] otraInfor = testDTO.getDescripcion().getText().split("#");
            test.setTipoTest(otraInfor[0]);
            if (otraInfor.length == 2) {
                test.setObservaciones(otraInfor[1]);
            }
            this.resultadosTest.add(test);
        }
    }

    public String getIdInterno() {
        return this.idInterno;
    }

    public void setIdInterno(String idInterno) {
        this.idInterno = idInterno;
    }

    public String getTipoAnalisis() {
        return this.tipoAnalisis;
    }

    public void setTipoAnalisis(String tipoAnalisis) {
        this.tipoAnalisis = tipoAnalisis;
    }

    public ArrayList<ResultadoTest> getResultadosTest() {
        return this.resultadosTest;
    }

    public void setResultadosTest(ArrayList<ResultadoTest> resultadosTest) {
        this.resultadosTest = resultadosTest;
    }

    public void insertNewResultTest(ResultadoTest test) {
        this.resultadosTest.add(test);
    }

    public String toString() {
        String datos = "ANALISIS";
        for (ResultadoTest test : this.resultadosTest) {
            datos = datos + test.toString();
        }
        return datos;
    }

    public void addView(AnalisisView view) {
        this.views.add(view);
    }

    public void updateAllViews() {
        Iterator<AnalisisView> it = this.views.iterator();
        while (it.hasNext()) {
            it.next().updateView();
        }
    }
}

