/*
 * Decompiled with CFR 0.152.
 */
package Application.Modelos;

import Application.Modelos.Analisis;
import Application.Modelos.Medicamento;
import Application.Modelos.Problemas;
import Application.Modelos.SocialHistory;
import Application.Vistas.Interfaces.PacienteView;
import DataManager.GoogleHealthManager.DTOs.AnalisisDTO;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import DataManager.GoogleHealthManager.DTOs.PacienteDTO;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import DataManager.GoogleHealthManager.DTOs.SocialHistoryDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paciente {
    private ArrayList<PacienteView> views;
    private String id;
    private String nombre;
    private String apellidos;
    private SocialHistory fechaNacimiento;
    private SocialHistory sexo;
    private SocialHistory telefono1;
    private SocialHistory telefono2;
    private SocialHistory direccion;
    private SocialHistory localidad;
    private SocialHistory email;
    private ArrayList<Analisis> peso;
    private ArrayList<Analisis> altura;
    private ArrayList<Analisis> imc;
    private ArrayList<Analisis> listaFondoOjos;
    private ArrayList<Analisis> listaGlucemias;
    private ArrayList<Analisis> listaInsulinasInyectadas;
    private ArrayList<Analisis> listaCuerposCetonicos;
    private ArrayList<Analisis> listaComidas;
    private Hashtable<Date, Analisis> tablaAnaliticas;
    private Problemas diabetes;
    private Hashtable<String, Problemas> tablaEnfermedades;
    private ArrayList<Problemas> listaOtrasEnfermedades;
    private ArrayList<Medicamento> listaMedicamentos;
    private ArrayList<Medicamento> listaInsulinas;

    public Paciente(PacienteDTO pacienteDTO, String nombrePaciente) {
        this.id = pacienteDTO.getId();
        this.inicializarArrayList();
        if (nombrePaciente.contains(",")) {
            this.apellidos = nombrePaciente.split(",")[0];
            this.nombre = nombrePaciente.split(",")[1];
        } else {
            this.nombre = nombrePaciente;
        }
        if (pacienteDTO.getSocialHistories() != null) {
            for (SocialHistoryDTO socialHistory : pacienteDTO.getSocialHistories()) {
                if (socialHistory.getDescription().getText().equalsIgnoreCase("Telefono1")) {
                    this.telefono1 = new SocialHistory(socialHistory);
                    continue;
                }
                if (socialHistory.getDescription().getText().equalsIgnoreCase("Telefono2")) {
                    this.telefono2 = new SocialHistory(socialHistory);
                    continue;
                }
                if (socialHistory.getDescription().getText().equalsIgnoreCase("Direccion")) {
                    this.direccion = new SocialHistory(socialHistory);
                    continue;
                }
                if (socialHistory.getDescription().getText().equalsIgnoreCase("Localidad")) {
                    this.localidad = new SocialHistory(socialHistory);
                    continue;
                }
                if (socialHistory.getDescription().getText().equalsIgnoreCase("Email")) {
                    this.email = new SocialHistory(socialHistory);
                    continue;
                }
                if (socialHistory.getDescription().getText().equalsIgnoreCase("Sexo")) {
                    this.sexo = new SocialHistory(socialHistory);
                    continue;
                }
                if (!socialHistory.getDescription().getText().equalsIgnoreCase("FechaNacimiento")) continue;
                this.fechaNacimiento = new SocialHistory(socialHistory);
            }
        }
        if (pacienteDTO.getAnalisis() != null) {
            for (AnalisisDTO analisisDTO : pacienteDTO.getAnalisis()) {
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Glucemia")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.listaGlucemias);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Insulina")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.listaInsulinasInyectadas);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Analitica")) {
                    this.insertarNuevoElemEnTabla(new Analisis(analisisDTO), this.tablaAnaliticas);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Peso")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.peso);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Altura")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.altura);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("IMC")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.imc);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Fondo de Ojo")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.listaFondoOjos);
                    continue;
                }
                if (analisisDTO.getDescripcion().getText().equalsIgnoreCase("Cuerpos Cetonicos")) {
                    this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.listaCuerposCetonicos);
                    continue;
                }
                if (!analisisDTO.getDescripcion().getText().equalsIgnoreCase("Comidas")) continue;
                this.insertarNuevoElemEnLista(new Analisis(analisisDTO), this.listaComidas);
            }
        }
        if (pacienteDTO.getProblemas() != null) {
            for (ProblemsDTO problemDTO : pacienteDTO.getProblemas()) {
                if (problemDTO.getDescription().getText().contains("Diabetes")) {
                    this.diabetes = new Problemas(problemDTO);
                    continue;
                }
                if (this.isEnfermedades(problemDTO.getDescription().getText())) {
                    this.tablaEnfermedades.put(problemDTO.getDescription().getText(), new Problemas(problemDTO));
                    continue;
                }
                this.listaOtrasEnfermedades.add(new Problemas(problemDTO));
            }
        }
        if (pacienteDTO.getMedicamentos() != null) {
            for (MedicamentoDTO medicamentoDTO : pacienteDTO.getMedicamentos()) {
                if (this.esTipoInsulina(medicamentoDTO.getListaProductos().get(0).getProductName())) {
                    this.listaInsulinas.add(new Medicamento(medicamentoDTO));
                    continue;
                }
                this.listaMedicamentos.add(new Medicamento(medicamentoDTO));
            }
        }
    }

    private void inicializarArrayList() {
        this.peso = new ArrayList();
        this.altura = new ArrayList();
        this.setImc(new ArrayList<Analisis>());
        this.listaFondoOjos = new ArrayList();
        this.listaGlucemias = new ArrayList();
        this.listaInsulinasInyectadas = new ArrayList();
        this.listaCuerposCetonicos = new ArrayList();
        this.listaComidas = new ArrayList();
        this.tablaAnaliticas = new Hashtable();
        this.tablaEnfermedades = new Hashtable();
        this.listaOtrasEnfermedades = new ArrayList();
        this.listaMedicamentos = new ArrayList();
        this.listaInsulinas = new ArrayList();
        this.setViews(new ArrayList<PacienteView>());
    }

    public String getNombre() {
        return this.nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getApellidos() {
        return this.apellidos;
    }

    public void setApellidos(String apellidos) {
        this.apellidos = apellidos;
    }

    public SocialHistory getTelefono1() {
        return this.telefono1;
    }

    public void setTelefono1(SocialHistory telefono1) {
        this.telefono1 = telefono1;
    }

    public SocialHistory getTelefono2() {
        return this.telefono2;
    }

    public void setTelefono2(SocialHistory telefono2) {
        this.telefono2 = telefono2;
    }

    public SocialHistory getDireccion() {
        return this.direccion;
    }

    public void setDireccion(SocialHistory direccion) {
        this.direccion = direccion;
    }

    public SocialHistory getLocalidad() {
        return this.localidad;
    }

    public void setLocalidad(SocialHistory localidad) {
        this.localidad = localidad;
    }

    public SocialHistory getEmail() {
        return this.email;
    }

    public void setEmail(SocialHistory email) {
        this.email = email;
    }

    public ArrayList<Analisis> getPeso() {
        return this.peso;
    }

    public void setPeso(ArrayList<Analisis> peso) {
        this.peso = peso;
    }

    public void addPeso(Analisis peso) {
        this.peso.add(peso);
    }

    public ArrayList<Analisis> getAltura() {
        return this.altura;
    }

    public void setAltura(ArrayList<Analisis> altura) {
        this.altura = altura;
    }

    public void addAltura(Analisis altura) {
        this.altura.add(altura);
    }

    public Problemas getDiabetes() {
        return this.diabetes;
    }

    public void setDiabetes(Problemas diabetes) {
        this.diabetes = diabetes;
    }

    public Hashtable<String, Problemas> getEnfermedades() {
        return this.tablaEnfermedades;
    }

    public Problemas getEnfermedades(String enfermedad) {
        return this.tablaEnfermedades.get(enfermedad);
    }

    public void setEnfermedades(String id, Problemas enfermedad) {
        this.removeEnfermedades(id);
        this.tablaEnfermedades.put(id, enfermedad);
    }

    public ArrayList<Problemas> getOtrasEnfermedades() {
        return this.listaOtrasEnfermedades;
    }

    public void setOtrasEnfermedades(ArrayList<Problemas> otrasEnfermedades) {
        this.listaOtrasEnfermedades = otrasEnfermedades;
    }

    public ArrayList<Medicamento> getListaMedicamentos() {
        return this.listaMedicamentos;
    }

    public ArrayList<Medicamento> getListaInsulinas() {
        return this.listaInsulinas;
    }

    public void setListaMedicamentos(ArrayList<Medicamento> medicamentos) {
        this.listaMedicamentos = medicamentos;
    }

    public void addMedicamentoToListaMedicamentos(Medicamento medicamento) {
        if (this.listaMedicamentos == null) {
            this.listaMedicamentos = new ArrayList();
        }
        this.listaMedicamentos.add(medicamento);
    }

    public ArrayList<Medicamento> getInsulina() {
        return this.listaInsulinas;
    }

    public void setInsulina(ArrayList<Medicamento> insulina) {
        this.listaInsulinas = insulina;
    }

    public void setInsulina(Medicamento insulina) {
        this.listaInsulinas.add(insulina);
    }

    public ArrayList<Analisis> getListaFondoOjos() {
        return this.listaFondoOjos;
    }

    public void setFondoOjos(ArrayList<Analisis> fondoOjos) {
        this.listaFondoOjos = fondoOjos;
    }

    public ArrayList<Analisis> getListaGlucemias() {
        return this.listaGlucemias;
    }

    public void setListaGlucemias(ArrayList<Analisis> glucemias) {
        this.listaGlucemias = glucemias;
    }

    public ArrayList<Analisis> getListaCuerposCetonicos() {
        return this.listaCuerposCetonicos;
    }

    public void setCuerposCetonicos(ArrayList<Analisis> cuerposCetonicos) {
        this.listaCuerposCetonicos = cuerposCetonicos;
    }

    public void setCuerposCetonicos(Analisis cuerpoCetonico) {
        this.listaCuerposCetonicos.add(cuerpoCetonico);
    }

    public ArrayList<Analisis> getComidas() {
        return this.listaComidas;
    }

    public void setComidas(ArrayList<Analisis> comidas) {
        this.listaComidas = comidas;
    }

    public void addComida(Analisis comida) {
        this.listaComidas.add(comida);
    }

    public ArrayList<Analisis> getInsulinasInyectadas() {
        return this.listaInsulinasInyectadas;
    }

    public void setInsulinasInyectadas(ArrayList<Analisis> insulinasInyectadas) {
        this.listaInsulinasInyectadas = insulinasInyectadas;
    }

    public Hashtable<Date, Analisis> getTablaAnaliticas() {
        return this.tablaAnaliticas;
    }

    public void setTablaAnaliticas(Hashtable<Date, Analisis> tablaAnaliticas) {
        this.tablaAnaliticas = tablaAnaliticas;
    }

    public void insertarNuevoElemEnTabla(Analisis analisis, Hashtable<Date, Analisis> tabla) {
        Date fechaDeAnalitica = analisis.getResultadosTest().get(0).getFecha();
        if (!tabla.containsKey(fechaDeAnalitica)) {
            tabla.put(fechaDeAnalitica, analisis);
        } else {
            tabla.get(fechaDeAnalitica).insertNewResultTest(analisis.getResultadosTest().get(0));
        }
    }

    public void insertarNuevoElemEnLista(Analisis analisis, ArrayList<Analisis> lista) {
        this.insertarNuevoElemEnLista(analisis, lista, 0, lista.size());
    }

    private void insertarNuevoElemEnLista(Analisis analisis, ArrayList<Analisis> lista, int min, int max) {
        if (lista.isEmpty()) {
            lista.add(analisis);
            return;
        }
        if (min >= max) {
            if (lista.size() <= min) {
                lista.add(min, analisis);
                return;
            }
            Date fechaMin = lista.get(min).getResultadosTest().get(0).getFecha();
            Date fechaAmeter = analisis.getResultadosTest().get(0).getFecha();
            if (fechaMin.getDate() == fechaAmeter.getDate() && fechaMin.getMonth() == fechaAmeter.getMonth() && fechaMin.getYear() == fechaAmeter.getYear()) {
                lista.get(min).insertNewResultTest(analisis.getResultadosTest().get(0));
            } else {
                lista.add(min, analisis);
            }
            return;
        }
        int posAux = (min + max) / 2;
        Date fechaPivote = lista.get(posAux).getResultadosTest().get(0).getFecha();
        Date fechaAmeter = analisis.getResultadosTest().get(0).getFecha();
        if (fechaPivote.getDate() == fechaAmeter.getDate() && fechaPivote.getMonth() == fechaAmeter.getMonth() && fechaPivote.getYear() == fechaAmeter.getYear()) {
            lista.get(posAux).insertNewResultTest(analisis.getResultadosTest().get(0));
            return;
        }
        if (fechaPivote.before(fechaAmeter)) {
            this.insertarNuevoElemEnLista(analisis, lista, posAux + 1, max);
        } else {
            this.insertarNuevoElemEnLista(analisis, lista, min, posAux - 1);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void removeEnfermedades(String enfermedad) {
        this.tablaEnfermedades.remove(enfermedad);
    }

    private boolean isEnfermedades(String enfermedadName) {
        return enfermedadName.equalsIgnoreCase("Obesidad/Sobrepeso") || enfermedadName.equalsIgnoreCase("Hipertension_arterial") || enfermedadName.equalsIgnoreCase("Hipercolesterolemia") || enfermedadName.equalsIgnoreCase("Hipertrigliceridemia") || enfermedadName.equalsIgnoreCase("Tabaquismo") || enfermedadName.equalsIgnoreCase("Enfermedad_celiaca") || enfermedadName.equalsIgnoreCase("Alteracion_tiroidea") || enfermedadName.equalsIgnoreCase("Fallo_ovarico_precoz") || enfermedadName.equalsIgnoreCase("Insuficiencia_suprarrenal") || enfermedadName.equalsIgnoreCase("Neuropatia_periferica") || enfermedadName.equalsIgnoreCase("Cardiopatia_isquemica") || enfermedadName.equalsIgnoreCase("Neuropatia_autonomica") || enfermedadName.equalsIgnoreCase("Retinopatia") || enfermedadName.equalsIgnoreCase("Claudicacion_intermitente") || enfermedadName.equalsIgnoreCase("Accidente_cerebrovascular") || enfermedadName.equalsIgnoreCase("Refropatia");
    }

    public void removeOtrasEnfermedades(String enfermedad) {
        for (int i = 0; i < this.listaOtrasEnfermedades.size(); ++i) {
            Problemas p = this.listaOtrasEnfermedades.get(i);
            String descripcion = p.getDescripcionProblema().getText();
            if (!descripcion.equalsIgnoreCase(enfermedad)) continue;
            this.listaOtrasEnfermedades.remove(i);
        }
    }

    public boolean isOtrasEnfermedades(String otraEnfermedad) {
        for (int i = 0; i < this.listaOtrasEnfermedades.size(); ++i) {
            Problemas p = this.listaOtrasEnfermedades.get(i);
            String descripcion = p.getDescripcionProblema().getText();
            if (!descripcion.equalsIgnoreCase(otraEnfermedad)) continue;
            return true;
        }
        return false;
    }

    public Problemas getOtrasEnfermedades(String otraEnfermedad) {
        for (int i = 0; i < this.listaOtrasEnfermedades.size(); ++i) {
            Problemas p = this.listaOtrasEnfermedades.get(i);
            String descripcion = p.getDescripcionProblema().getText();
            if (!descripcion.equalsIgnoreCase(otraEnfermedad)) continue;
            return p;
        }
        return null;
    }

    public void addNewOtrasEnfermedades(Problemas otraEnfermedad) {
        this.listaOtrasEnfermedades.add(otraEnfermedad);
    }

    public void updateOtrasEnfermedades(Problemas otraEnfermedad) {
        for (int i = 0; i < this.listaOtrasEnfermedades.size(); ++i) {
            Problemas p = this.listaOtrasEnfermedades.get(i);
            String descripcion = p.getDescripcionProblema().getText();
            if (!descripcion.equalsIgnoreCase(otraEnfermedad.getDescripcionProblema().getText())) continue;
            p.setFechaInicio(otraEnfermedad.getFechaInicio());
            p.setFechaFin(otraEnfermedad.getFechaFin());
        }
    }

    public int addView(PacienteView view) {
        this.getViews().add(view);
        return this.getViews().size() - 1;
    }

    public void updateAllViews() {
        Iterator<PacienteView> it = this.getViews().iterator();
        while (it.hasNext()) {
            it.next().updateView();
        }
    }

    public PacienteView removeView(PacienteView view) {
        return this.getViews().remove(view.getIdVista());
    }

    private boolean esTipoInsulina(String productName) {
        return productName.equalsIgnoreCase("ACCI\u00d3N RAPIDA") || productName.equalsIgnoreCase("ACCION BREVE") || productName.equalsIgnoreCase("INTERMEDIA") || productName.equalsIgnoreCase("ACCION PROLONGADA") || productName.equalsIgnoreCase("PREMEZCLA") || productName.equalsIgnoreCase("INHALADA");
    }

    public void setMedicamentos(Medicamento medicamento) {
        this.listaMedicamentos.add(medicamento);
    }

    public ArrayList<PacienteView> getViews() {
        return this.views;
    }

    public void setViews(ArrayList<PacienteView> views) {
        this.views = views;
    }

    public SocialHistory getSexo() {
        return this.sexo;
    }

    public void setSexo(SocialHistory sexo) {
        this.sexo = sexo;
    }

    public SocialHistory getFechaNacimiento() {
        return this.fechaNacimiento;
    }

    public void setFechaNacimiento(SocialHistory fechaNacimiento) {
        this.fechaNacimiento = fechaNacimiento;
    }

    public ArrayList<Analisis> getImc() {
        return this.imc;
    }

    public void setImc(ArrayList<Analisis> imc) {
        this.imc = imc;
    }
}

