/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorAnalisisView;
import Application.Herramientas.CommonTools;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Interfaces.AnalisisView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class DialogoDetallesCuerposCetonicos
extends JDialog
implements AnalisisView {
    ControladorAnalisisView controlador;
    boolean saved;
    private JButton buttonAceptar;
    private JButton buttonCancelar;
    private JDateChooser dateChooserFechaToma;
    private JLabel labelComentario;
    private JLabel labelFecha;
    private JLabel labelHora;
    private JLabel labelPregunta;
    private JLabel labelUnidades;
    private JLabel labelValor;
    private JSpinner spinnerCuerposCetonicos;
    private JSpinner spinnerHora;
    private TextArea textAreaComentario;

    private DialogoDetallesCuerposCetonicos(Frame parent, boolean modal, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.controlador = new ControladorAnalisisView(idPacienteOwner, new Analisis());
        this.saved = false;
        CommonTools.centrarVentana(this);
    }

    private DialogoDetallesCuerposCetonicos(Frame parent, boolean modal, Analisis modelo, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        this.controlador = new ControladorAnalisisView(idPacienteOwner, modelo);
        this.saved = true;
        this.buttonAceptar.setVisible(false);
        this.dateChooserFechaToma.getDateEditor().setEnabled(false);
        this.spinnerHora.setEnabled(false);
        this.spinnerCuerposCetonicos.setEnabled(false);
        this.textAreaComentario.setEditable(false);
        this.rellenarValores();
        CommonTools.centrarVentana(this);
    }

    private void rellenarValores() {
        this.dateChooserFechaToma.setDate(this.controlador.getModelo().getResultadosTest().get(0).getFecha());
        this.spinnerHora.setValue(this.controlador.getModelo().getResultadosTest().get(0).getFecha());
        this.spinnerCuerposCetonicos.setValue(Double.parseDouble(this.controlador.getModelo().getResultadosTest().get(0).getValorObtenido()));
        this.textAreaComentario.setText(this.controlador.getModelo().getResultadosTest().get(0).getObservaciones());
    }

    public static Analisis showDialogNuevoCuerpoCetonico(String idPacienteOwner) {
        DialogoDetallesCuerposCetonicos dialog = new DialogoDetallesCuerposCetonicos(null, true, idPacienteOwner);
        return dialog.getCuerpoCetonico();
    }

    public static void showDialogDetallesCuerpoCetonico(String idPacienteOwner, Analisis analisis) {
        new DialogoDetallesCuerposCetonicos(null, true, analisis, idPacienteOwner);
    }

    private Analisis getCuerpoCetonico() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    private void initComponents() {
        this.labelValor = new JLabel();
        this.dateChooserFechaToma = new JDateChooser();
        this.spinnerCuerposCetonicos = new JSpinner();
        this.labelFecha = new JLabel();
        this.labelComentario = new JLabel();
        this.labelHora = new JLabel();
        this.textAreaComentario = new TextArea();
        this.spinnerHora = new JSpinner();
        this.buttonCancelar = new JButton();
        this.buttonAceptar = new JButton();
        this.labelUnidades = new JLabel();
        this.labelPregunta = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Medida de cuerpos cet\u00f3nicos");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(351, 241));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.labelValor.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelValor.setText("Valor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 1, 0);
        this.getContentPane().add((Component)this.labelValor, gridBagConstraints);
        this.dateChooserFechaToma.setMinimumSize(new Dimension(150, 20));
        this.dateChooserFechaToma.setOpaque(false);
        this.dateChooserFechaToma.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 50, 1, 8);
        this.getContentPane().add((Component)this.dateChooserFechaToma, gridBagConstraints);
        this.spinnerCuerposCetonicos.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        this.spinnerCuerposCetonicos.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 50, 1, 8);
        this.getContentPane().add((Component)this.spinnerCuerposCetonicos, gridBagConstraints);
        this.labelFecha.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelFecha.setText("Fecha");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 9, 1, 0);
        this.getContentPane().add((Component)this.labelFecha, gridBagConstraints);
        this.labelComentario.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelComentario.setText("Comentario:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 8, 1, 0);
        this.getContentPane().add((Component)this.labelComentario, gridBagConstraints);
        this.labelHora.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelHora.setText("Hora");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 1, 0);
        this.getContentPane().add((Component)this.labelHora, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 6);
        this.getContentPane().add((Component)this.textAreaComentario, gridBagConstraints);
        this.spinnerHora.setModel(new SpinnerDateModel(new Date(), null, null, 12));
        this.spinnerHora.setToolTipText("Hora de la ingesta");
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinnerHora.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(new SimpleDateFormat("hh:00 a"));
        this.spinnerHora.setMinimumSize(new Dimension(70, 20));
        this.spinnerHora.setOpaque(false);
        this.spinnerHora.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 50, 1, 8);
        this.getContentPane().add((Component)this.spinnerHora, gridBagConstraints);
        this.buttonCancelar.setBackground(new Color(255, 255, 255));
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonCancelar.setText("Cerrar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.setHorizontalAlignment(2);
        this.buttonCancelar.setMaximumSize(new Dimension(90, 24));
        this.buttonCancelar.setMinimumSize(new Dimension(90, 24));
        this.buttonCancelar.setPreferredSize(new Dimension(90, 24));
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesCuerposCetonicos.this.buttonCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 12, 8, 8);
        this.getContentPane().add((Component)this.buttonCancelar, gridBagConstraints);
        this.buttonAceptar.setBackground(new Color(255, 255, 255));
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.setHorizontalAlignment(2);
        this.buttonAceptar.setMaximumSize(new Dimension(90, 24));
        this.buttonAceptar.setMinimumSize(new Dimension(90, 24));
        this.buttonAceptar.setPreferredSize(new Dimension(90, 24));
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesCuerposCetonicos.this.buttonAceptarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 0, 8, 101);
        this.getContentPane().add((Component)this.buttonAceptar, gridBagConstraints);
        this.labelUnidades.setText("(mmol/L) ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 107, 0, 0);
        this.getContentPane().add((Component)this.labelUnidades, gridBagConstraints);
        this.labelPregunta.setBackground(new Color(0, 153, 255));
        this.labelPregunta.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelPregunta.setForeground(new Color(255, 255, 255));
        this.labelPregunta.setText("Medida de cuerpos cet\u00f3nicos");
        this.labelPregunta.setMaximumSize(new Dimension(400, 40));
        this.labelPregunta.setMinimumSize(new Dimension(400, 40));
        this.labelPregunta.setOpaque(true);
        this.labelPregunta.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.labelPregunta, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        String erroresEncontrados = this.comprobarDatos();
        if (erroresEncontrados == null) {
            if (this.controlador.insertarAnalisis()) {
                this.saved = true;
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Error al guardar la nueva comida, por favor, vuelva a intentarlo", "Atenci\u00f3n, error al guardar", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + erroresEncontrados, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        if (!this.saved) {
            int option = JOptionPane.showConfirmDialog(this, "No se han guardado los cambios, \u00bfSeguro que desea cerrar sin guardar?", "\u00a1Atenci\u00f3n, cambios no guardados!", 2);
            if (option == 0) {
                this.saved = false;
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private String comprobarDatos() {
        if (this.dateChooserFechaToma.getDate() != null) {
            Date fechaToma = this.dateChooserFechaToma.getDate();
            this.controlador.getModelo().setTipoAnalisis("Cuerpos Cetonicos");
            fechaToma.setHours(((Date)this.spinnerHora.getValue()).getHours());
            fechaToma.setMinutes(((Date)this.spinnerHora.getValue()).getMinutes());
            ResultadoTest res = new ResultadoTest();
            res.setFecha(fechaToma);
            res.setTipoFecha("Collection start date");
            res.setUnidadesObtenido("mmol/l");
            res.setValorNormal("");
            res.setTipoTest("Cuerpos Cetonicos");
            if ((Double)this.spinnerCuerposCetonicos.getValue() <= 0.0) {
                return "\tValor de cuerpos cet\u00f3nicos err\u00f3neo o en blanco. \n";
            }
            res.setValorObtenido("" + (Double)this.spinnerCuerposCetonicos.getValue());
            res.setObservaciones(this.textAreaComentario.getText());
            this.controlador.getModelo().insertNewResultTest(res);
            return null;
        }
        return "\tFecha err\u00f3nea o en blanco. \n";
    }

    public void updateView() {
        this.rellenarValores();
    }
}

