/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Modelos.Problemas;
import Application.Vistas.Dialogos.DialogoDetallesEnfermedad;
import Application.Vistas.Interfaces.PacienteView;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelComorbilidades
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    ArrayList<String> resul = null;
    int idVista;
    private JButton buttonAplicar;
    private JButton buttonCancelar;
    private JButton buttonEditar;
    private JButton buttonEliminar;
    private JButton buttonInsertarNuevaEnfermedad;
    private JButton buttonVerDetalles;
    private JCheckBox checkBoxAccidenteCerebroVascular;
    private JCheckBox checkBoxCardiopatiaIsquemica;
    private JCheckBox checkBoxCeliaco;
    private JCheckBox checkBoxClaudicacionIntermitente;
    private JCheckBox checkBoxFalloOvarico;
    private JCheckBox checkBoxHiperColesterol;
    private JCheckBox checkBoxHipertension;
    private JCheckBox checkBoxHipertrigliceridemia;
    private JCheckBox checkBoxInsuSuprarrenal;
    private JCheckBox checkBoxNeuropatiaAutonomica;
    private JCheckBox checkBoxNeuropatiaPeriferica;
    private JCheckBox checkBoxObesidad;
    private JCheckBox checkBoxRefropatia;
    private JCheckBox checkBoxRetinopatia;
    private JCheckBox checkBoxTabaco;
    private JCheckBox checkBoxTiroides;
    private JScrollPane jScrollPane5;
    private JLabel labelPregunta;
    private JLabel labelPregunta1;
    private JLabel labelPregunta2;
    private JLabel labelTituloOtrasEnfermedades;
    private JList listaOtrasEnfermedades;
    private JPanel panelComplicaciones;
    private JPanel panelEnfermedades;
    private JPanel panelEnfermedadesAuto;
    private JPanel panelFactoresRiesgoCardio;
    private JPanel panelOtrasEnfermedades;

    public PanelComorbilidades() {
        this.initComponents();
    }

    public PanelComorbilidades(ControladorPacienteView controlador) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.buttonAplicar.setVisible(false);
        this.buttonCancelar.setVisible(false);
        this.rellenarDatosPanelEnfermedades();
        this.rellenarDatosPanelOtrasEnfermedades();
    }

    private void rellenarDatosPanelEnfermedades() {
        Status a;
        if (this.controlador.getModelo().getEnfermedades().containsKey("Obesidad/Sobrepeso") && (a = this.controlador.getModelo().getEnfermedades().get("Obesidad/Sobrepeso").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxObesidad.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Hipertension_arterial") && (a = this.controlador.getModelo().getEnfermedades().get("Hipertension_arterial").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxHipertension.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Hipercolesterolemia") && (a = this.controlador.getModelo().getEnfermedades().get("Hipercolesterolemia").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxHiperColesterol.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Hipertrigliceridemia") && (a = this.controlador.getModelo().getEnfermedades().get("Hipertrigliceridemia").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxHipertrigliceridemia.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Tabaquismo") && (a = this.controlador.getModelo().getEnfermedades().get("Tabaquismo").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxTabaco.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Enfermedad_celiaca") && (a = this.controlador.getModelo().getEnfermedades().get("Enfermedad_celiaca").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxCeliaco.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Alteracion_tiroidea") && (a = this.controlador.getModelo().getEnfermedades().get("Alteracion_tiroidea").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxTiroides.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Fallo_ovarico_precoz") && (a = this.controlador.getModelo().getEnfermedades().get("Fallo_ovarico_precoz").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxFalloOvarico.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Insuficiencia_suprarrenal") && (a = this.controlador.getModelo().getEnfermedades().get("Insuficiencia_suprarrenal").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxInsuSuprarrenal.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Neuropatia_periferica") && (a = this.controlador.getModelo().getEnfermedades().get("Neuropatia_periferica").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxNeuropatiaPeriferica.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Cardiopatia_isquemica") && (a = this.controlador.getModelo().getEnfermedades().get("Cardiopatia_isquemica").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxCardiopatiaIsquemica.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Neuropatia_autonomica") && (a = this.controlador.getModelo().getEnfermedades().get("Neuropatia_autonomica").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxNeuropatiaAutonomica.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Retinopatia") && (a = this.controlador.getModelo().getEnfermedades().get("Retinopatia").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxRetinopatia.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Claudicacion_intermitente") && (a = this.controlador.getModelo().getEnfermedades().get("Claudicacion_intermitente").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxClaudicacionIntermitente.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Accidente_cerebrovascular") && (a = this.controlador.getModelo().getEnfermedades().get("Accidente_cerebrovascular").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxAccidenteCerebroVascular.setSelected(true);
        }
        if (this.controlador.getModelo().getEnfermedades().containsKey("Refropatia") && (a = this.controlador.getModelo().getEnfermedades().get("Refropatia").getStatus()).getEstado().equalsIgnoreCase("activo")) {
            this.checkBoxRefropatia.setSelected(true);
        }
    }

    private void switchModoEditar(boolean modo) {
        this.buttonAplicar.setVisible(modo);
        this.buttonCancelar.setVisible(modo);
        this.buttonEditar.setVisible(!modo);
        this.checkBoxObesidad.setEnabled(modo);
        this.checkBoxHipertension.setEnabled(modo);
        this.checkBoxHiperColesterol.setEnabled(modo);
        this.checkBoxHipertrigliceridemia.setEnabled(modo);
        this.checkBoxTabaco.setEnabled(modo);
        this.checkBoxCeliaco.setEnabled(modo);
        this.checkBoxTiroides.setEnabled(modo);
        this.checkBoxFalloOvarico.setEnabled(modo);
        this.checkBoxInsuSuprarrenal.setEnabled(modo);
        this.checkBoxNeuropatiaPeriferica.setEnabled(modo);
        this.checkBoxCardiopatiaIsquemica.setEnabled(modo);
        this.checkBoxNeuropatiaAutonomica.setEnabled(modo);
        this.checkBoxRetinopatia.setEnabled(modo);
        this.checkBoxClaudicacionIntermitente.setEnabled(modo);
        this.checkBoxAccidenteCerebroVascular.setEnabled(modo);
        this.checkBoxRefropatia.setEnabled(modo);
    }

    public void updateView() {
        this.rellenarDatosPanelEnfermedades();
        this.rellenarDatosPanelOtrasEnfermedades();
    }

    public int getIdVista() {
        return this.idVista;
    }

    private void initComponents() {
        this.panelEnfermedades = new JPanel();
        this.panelFactoresRiesgoCardio = new JPanel();
        this.checkBoxObesidad = new JCheckBox();
        this.checkBoxHipertension = new JCheckBox();
        this.checkBoxHiperColesterol = new JCheckBox();
        this.checkBoxHipertrigliceridemia = new JCheckBox();
        this.checkBoxTabaco = new JCheckBox();
        this.labelPregunta = new JLabel();
        this.panelEnfermedadesAuto = new JPanel();
        this.checkBoxCeliaco = new JCheckBox();
        this.checkBoxTiroides = new JCheckBox();
        this.checkBoxFalloOvarico = new JCheckBox();
        this.checkBoxInsuSuprarrenal = new JCheckBox();
        this.labelPregunta1 = new JLabel();
        this.panelComplicaciones = new JPanel();
        this.checkBoxNeuropatiaPeriferica = new JCheckBox();
        this.checkBoxCardiopatiaIsquemica = new JCheckBox();
        this.checkBoxNeuropatiaAutonomica = new JCheckBox();
        this.checkBoxRetinopatia = new JCheckBox();
        this.checkBoxClaudicacionIntermitente = new JCheckBox();
        this.checkBoxAccidenteCerebroVascular = new JCheckBox();
        this.checkBoxRefropatia = new JCheckBox();
        this.labelPregunta2 = new JLabel();
        this.panelOtrasEnfermedades = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.listaOtrasEnfermedades = new JList();
        this.buttonInsertarNuevaEnfermedad = new JButton();
        this.buttonVerDetalles = new JButton();
        this.buttonEliminar = new JButton();
        this.labelTituloOtrasEnfermedades = new JLabel();
        this.buttonCancelar = new JButton();
        this.buttonEditar = new JButton();
        this.buttonAplicar = new JButton();
        this.setMinimumSize(new Dimension(739, 541));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(739, 541));
        this.setLayout(new GridBagLayout());
        this.panelEnfermedades.setMaximumSize(new Dimension(230, 493));
        this.panelEnfermedades.setMinimumSize(new Dimension(230, 493));
        this.panelEnfermedades.setOpaque(false);
        this.panelEnfermedades.setPreferredSize(new Dimension(230, 493));
        this.panelEnfermedades.setLayout(new BoxLayout(this.panelEnfermedades, 1));
        this.panelFactoresRiesgoCardio.setBackground(new Color(255, 255, 255));
        this.panelFactoresRiesgoCardio.setMaximumSize(new Dimension(230, 156));
        this.panelFactoresRiesgoCardio.setMinimumSize(new Dimension(230, 156));
        this.panelFactoresRiesgoCardio.setOpaque(false);
        this.panelFactoresRiesgoCardio.setPreferredSize(new Dimension(230, 156));
        this.panelFactoresRiesgoCardio.setLayout(new GridBagLayout());
        this.checkBoxObesidad.setText("Obesidad/Sobrepeso");
        this.checkBoxObesidad.setEnabled(false);
        this.checkBoxObesidad.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelFactoresRiesgoCardio.add((Component)this.checkBoxObesidad, gridBagConstraints);
        this.checkBoxHipertension.setText("Hipertensi\u00f3n arterial");
        this.checkBoxHipertension.setEnabled(false);
        this.checkBoxHipertension.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelFactoresRiesgoCardio.add((Component)this.checkBoxHipertension, gridBagConstraints);
        this.checkBoxHiperColesterol.setText("Hipercolesterolemia ");
        this.checkBoxHiperColesterol.setEnabled(false);
        this.checkBoxHiperColesterol.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelFactoresRiesgoCardio.add((Component)this.checkBoxHiperColesterol, gridBagConstraints);
        this.checkBoxHipertrigliceridemia.setText("Hipertrigliceridemia");
        this.checkBoxHipertrigliceridemia.setEnabled(false);
        this.checkBoxHipertrigliceridemia.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.panelFactoresRiesgoCardio.add((Component)this.checkBoxHipertrigliceridemia, gridBagConstraints);
        this.checkBoxTabaco.setText("Tabaquismo");
        this.checkBoxTabaco.setEnabled(false);
        this.checkBoxTabaco.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.panelFactoresRiesgoCardio.add((Component)this.checkBoxTabaco, gridBagConstraints);
        this.labelPregunta.setBackground(new Color(0, 153, 255));
        this.labelPregunta.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelPregunta.setForeground(new Color(255, 255, 255));
        this.labelPregunta.setText("Factores de riesgo cardiovascular");
        this.labelPregunta.setMaximumSize(new Dimension(400, 40));
        this.labelPregunta.setMinimumSize(new Dimension(400, 40));
        this.labelPregunta.setOpaque(true);
        this.labelPregunta.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelFactoresRiesgoCardio.add((Component)this.labelPregunta, gridBagConstraints);
        this.panelEnfermedades.add(this.panelFactoresRiesgoCardio);
        this.panelEnfermedadesAuto.setMaximumSize(new Dimension(230, 133));
        this.panelEnfermedadesAuto.setMinimumSize(new Dimension(230, 133));
        this.panelEnfermedadesAuto.setOpaque(false);
        this.panelEnfermedadesAuto.setPreferredSize(new Dimension(230, 133));
        this.panelEnfermedadesAuto.setLayout(new GridBagLayout());
        this.checkBoxCeliaco.setText("Enfermedad celiaca");
        this.checkBoxCeliaco.setEnabled(false);
        this.checkBoxCeliaco.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelEnfermedadesAuto.add((Component)this.checkBoxCeliaco, gridBagConstraints);
        this.checkBoxTiroides.setText("Alteraci\u00f3n tiroidea");
        this.checkBoxTiroides.setEnabled(false);
        this.checkBoxTiroides.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.panelEnfermedadesAuto.add((Component)this.checkBoxTiroides, gridBagConstraints);
        this.checkBoxFalloOvarico.setText("Fallo ov\u00e1rico precoz");
        this.checkBoxFalloOvarico.setEnabled(false);
        this.checkBoxFalloOvarico.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelEnfermedadesAuto.add((Component)this.checkBoxFalloOvarico, gridBagConstraints);
        this.checkBoxInsuSuprarrenal.setText("Insuficiencia suprarrenal");
        this.checkBoxInsuSuprarrenal.setEnabled(false);
        this.checkBoxInsuSuprarrenal.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelEnfermedadesAuto.add((Component)this.checkBoxInsuSuprarrenal, gridBagConstraints);
        this.labelPregunta1.setBackground(new Color(0, 153, 255));
        this.labelPregunta1.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelPregunta1.setForeground(new Color(255, 255, 255));
        this.labelPregunta1.setText("Enfermedades autoinmunes");
        this.labelPregunta1.setMaximumSize(new Dimension(400, 40));
        this.labelPregunta1.setMinimumSize(new Dimension(400, 40));
        this.labelPregunta1.setOpaque(true);
        this.labelPregunta1.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelEnfermedadesAuto.add((Component)this.labelPregunta1, gridBagConstraints);
        this.panelEnfermedades.add(this.panelEnfermedadesAuto);
        this.panelComplicaciones.setMaximumSize(new Dimension(230, 203));
        this.panelComplicaciones.setMinimumSize(new Dimension(230, 203));
        this.panelComplicaciones.setOpaque(false);
        this.panelComplicaciones.setPreferredSize(new Dimension(230, 203));
        this.panelComplicaciones.setLayout(new GridBagLayout());
        this.checkBoxNeuropatiaPeriferica.setText("Neuropat\u00eda  perif\u00e9rica");
        this.checkBoxNeuropatiaPeriferica.setEnabled(false);
        this.checkBoxNeuropatiaPeriferica.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxNeuropatiaPeriferica, gridBagConstraints);
        this.checkBoxCardiopatiaIsquemica.setText("Cardiopat\u00eda isqu\u00e9mica");
        this.checkBoxCardiopatiaIsquemica.setEnabled(false);
        this.checkBoxCardiopatiaIsquemica.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxCardiopatiaIsquemica, gridBagConstraints);
        this.checkBoxNeuropatiaAutonomica.setText("Neuropat\u00eda auton\u00f3mica");
        this.checkBoxNeuropatiaAutonomica.setEnabled(false);
        this.checkBoxNeuropatiaAutonomica.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxNeuropatiaAutonomica, gridBagConstraints);
        this.checkBoxRetinopatia.setText("Retinopat\u00eda ");
        this.checkBoxRetinopatia.setEnabled(false);
        this.checkBoxRetinopatia.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxRetinopatia, gridBagConstraints);
        this.checkBoxClaudicacionIntermitente.setText("Claudicaci\u00f3n intermitente");
        this.checkBoxClaudicacionIntermitente.setEnabled(false);
        this.checkBoxClaudicacionIntermitente.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxClaudicacionIntermitente, gridBagConstraints);
        this.checkBoxAccidenteCerebroVascular.setText("Accidente cerebrovascular");
        this.checkBoxAccidenteCerebroVascular.setEnabled(false);
        this.checkBoxAccidenteCerebroVascular.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxAccidenteCerebroVascular, gridBagConstraints);
        this.checkBoxRefropatia.setText("Refropat\u00eda ");
        this.checkBoxRefropatia.setEnabled(false);
        this.checkBoxRefropatia.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.panelComplicaciones.add((Component)this.checkBoxRefropatia, gridBagConstraints);
        this.labelPregunta2.setBackground(new Color(0, 153, 255));
        this.labelPregunta2.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelPregunta2.setForeground(new Color(255, 255, 255));
        this.labelPregunta2.setText("Enfermedades autoinmunes");
        this.labelPregunta2.setMaximumSize(new Dimension(400, 40));
        this.labelPregunta2.setMinimumSize(new Dimension(400, 40));
        this.labelPregunta2.setOpaque(true);
        this.labelPregunta2.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelComplicaciones.add((Component)this.labelPregunta2, gridBagConstraints);
        this.panelEnfermedades.add(this.panelComplicaciones);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panelEnfermedades, gridBagConstraints);
        this.panelOtrasEnfermedades.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.panelOtrasEnfermedades.setMinimumSize(new Dimension(405, 493));
        this.panelOtrasEnfermedades.setOpaque(false);
        this.panelOtrasEnfermedades.setPreferredSize(new Dimension(405, 493));
        this.panelOtrasEnfermedades.setLayout(new GridBagLayout());
        this.listaOtrasEnfermedades.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelComorbilidades.this.listaOtrasEnfermedadesValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.listaOtrasEnfermedades);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.panelOtrasEnfermedades.add((Component)this.jScrollPane5, gridBagConstraints);
        this.buttonInsertarNuevaEnfermedad.setBackground(new Color(255, 255, 255));
        this.buttonInsertarNuevaEnfermedad.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonInsertarNuevaEnfermedad.setForeground(new Color(0, 102, 255));
        this.buttonInsertarNuevaEnfermedad.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonInsertarNuevaEnfermedad.setText("A\u00f1adir otra enfermedad");
        this.buttonInsertarNuevaEnfermedad.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonInsertarNuevaEnfermedad.setContentAreaFilled(false);
        this.buttonInsertarNuevaEnfermedad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelComorbilidades.this.buttonInsertarNuevaEnfermedadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.panelOtrasEnfermedades.add((Component)this.buttonInsertarNuevaEnfermedad, gridBagConstraints);
        this.buttonVerDetalles.setBackground(new Color(255, 255, 255));
        this.buttonVerDetalles.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonVerDetalles.setForeground(new Color(0, 102, 255));
        this.buttonVerDetalles.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/search 24x24.png")));
        this.buttonVerDetalles.setText("Ver detalles");
        this.buttonVerDetalles.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonVerDetalles.setContentAreaFilled(false);
        this.buttonVerDetalles.setEnabled(false);
        this.buttonVerDetalles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelComorbilidades.this.buttonVerDetallesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 31, 0, 0);
        this.panelOtrasEnfermedades.add((Component)this.buttonVerDetalles, gridBagConstraints);
        this.buttonEliminar.setBackground(new Color(255, 255, 255));
        this.buttonEliminar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonEliminar.setForeground(new Color(0, 102, 255));
        this.buttonEliminar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/recycle_bin 24x24.png")));
        this.buttonEliminar.setText("Eliminar Enfermedad");
        this.buttonEliminar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonEliminar.setContentAreaFilled(false);
        this.buttonEliminar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelComorbilidades.this.buttonEliminarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.panelOtrasEnfermedades.add((Component)this.buttonEliminar, gridBagConstraints);
        this.labelTituloOtrasEnfermedades.setBackground(new Color(0, 153, 255));
        this.labelTituloOtrasEnfermedades.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelTituloOtrasEnfermedades.setForeground(new Color(255, 255, 255));
        this.labelTituloOtrasEnfermedades.setText("Otras enfermedades");
        this.labelTituloOtrasEnfermedades.setMaximumSize(new Dimension(400, 40));
        this.labelTituloOtrasEnfermedades.setMinimumSize(new Dimension(400, 40));
        this.labelTituloOtrasEnfermedades.setOpaque(true);
        this.labelTituloOtrasEnfermedades.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelOtrasEnfermedades.add((Component)this.labelTituloOtrasEnfermedades, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelOtrasEnfermedades, gridBagConstraints);
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorderPainted(false);
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelComorbilidades.this.buttonCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.buttonCancelar, gridBagConstraints);
        this.buttonEditar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonEditar.setForeground(new Color(0, 102, 255));
        this.buttonEditar.setText("Editar Datos");
        this.buttonEditar.setBorderPainted(false);
        this.buttonEditar.setContentAreaFilled(false);
        this.buttonEditar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelComorbilidades.this.buttonEditarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.buttonEditar, gridBagConstraints);
        this.buttonAplicar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAplicar.setForeground(new Color(0, 102, 255));
        this.buttonAplicar.setText("Aplicar");
        this.buttonAplicar.setBorderPainted(false);
        this.buttonAplicar.setContentAreaFilled(false);
        this.buttonAplicar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelComorbilidades.this.buttonAplicarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 90);
        this.add((Component)this.buttonAplicar, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("Jpanel1");
    }

    private void buttonEditarActionPerformed(ActionEvent evt) {
        this.switchModoEditar(true);
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        this.rellenarDatosPanelEnfermedades();
        this.rellenarDatosPanelOtrasEnfermedades();
        this.switchModoEditar(false);
    }

    private void buttonAplicarActionPerformed(ActionEvent evt) {
        this.controlador.insertOrUpdateEnfermedades("Obesidad/Sobrepeso", this.checkBoxObesidad.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Hipertension_arterial", this.checkBoxHipertension.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Hipercolesterolemia", this.checkBoxHiperColesterol.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Hipertrigliceridemia", this.checkBoxHipertrigliceridemia.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Tabaquismo", this.checkBoxTabaco.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Enfermedad_celiaca", this.checkBoxCeliaco.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Alteracion_tiroidea", this.checkBoxTiroides.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Fallo_ovarico_precoz", this.checkBoxFalloOvarico.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Insuficiencia_suprarrenal", this.checkBoxInsuSuprarrenal.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Neuropatia_periferica", this.checkBoxNeuropatiaPeriferica.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Cardiopatia_isquemica", this.checkBoxCardiopatiaIsquemica.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Neuropatia_autonomica", this.checkBoxNeuropatiaAutonomica.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Retinopatia", this.checkBoxRetinopatia.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Claudicacion_intermitente", this.checkBoxClaudicacionIntermitente.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Accidente_cerebrovascular", this.checkBoxAccidenteCerebroVascular.isSelected());
        this.controlador.insertOrUpdateEnfermedades("Refropatia", this.checkBoxRefropatia.isSelected());
        this.controlador.updateModelo();
        this.switchModoEditar(false);
    }

    private void buttonInsertarNuevaEnfermedadActionPerformed(ActionEvent evt) {
        Problemas newEnfermedad = DialogoDetallesEnfermedad.insertarNuevaEnfermedad(this.controlador.getModelo().getId());
        if (newEnfermedad != null) {
            this.controlador.insertNewEnfermedad(newEnfermedad);
            this.controlador.updateModelo();
        }
    }

    private void rellenarDatosPanelOtrasEnfermedades() {
        int longitud = this.controlador.getModelo().getOtrasEnfermedades().size();
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        for (int i = 0; i < longitud; ++i) {
            String otraEnfermedad = this.controlador.getModelo().getOtrasEnfermedades().get(i).getDescripcionProblema().getText();
            dlm.add(i, otraEnfermedad);
        }
        this.listaOtrasEnfermedades.setModel(dlm);
        this.listaOtrasEnfermedades.repaint();
    }

    private void buttonEliminarActionPerformed(ActionEvent evt) {
        String otraEnfermedad = (String)this.listaOtrasEnfermedades.getSelectedValue();
        if (otraEnfermedad != null) {
            this.controlador.deleteOtrasEnfermedades(otraEnfermedad, false);
            this.rellenarDatosPanelOtrasEnfermedades();
        } else {
            JOptionPane.showMessageDialog(this, "debe seleccionar una enfermedad");
        }
    }

    private void buttonVerDetallesActionPerformed(ActionEvent evt) {
        Problemas problem;
        String nombre = (String)this.listaOtrasEnfermedades.getSelectedValue();
        if (nombre != null && (problem = this.controlador.getModelo().getOtrasEnfermedades(nombre)) != null) {
            new DialogoDetallesEnfermedad(null, true, problem, this.controlador.getModelo().getId());
        }
    }

    private void listaOtrasEnfermedadesValueChanged(ListSelectionEvent evt) {
        this.buttonVerDetalles.setEnabled(!this.listaOtrasEnfermedades.isSelectionEmpty());
    }
}

