/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Herramientas.CellRenderComidas;
import Application.Herramientas.CommonTools;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Dialogos.DialogoNuevaComida;
import Application.Vistas.Interfaces.PacienteView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelDietas
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    Date fechaInicial;
    int idVista;
    String[][] comentarios;
    private JButton buttonNuevaComida;
    private JComboBox comboBoxIntervalo;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JScrollPane jScrollPane6;
    private JPanel panelHerramientas;
    private JScrollPane scrollPaneTextAreaComentario;
    private JTable tablaMedidas;
    private JTextArea textAreaComentario;

    public PanelDietas(ControladorPacienteView controlador, String rol) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.fechaInicial = new Date();
        this.fechaInicial.setTime(this.fechaInicial.getTime() - 604800000L);
        this.fechaInicial.setHours(0);
        this.fechaInicial.setMinutes(0);
        this.fechaInicial.setSeconds(0);
        this.comentarios = new String[8][7];
        this.tablaMedidas.setRowHeight(30);
        this.rellenarDatos();
        if (rol.equalsIgnoreCase("Medico")) {
            this.buttonNuevaComida.setVisible(false);
        }
    }

    private void rellenarDatos() {
        for (int i = this.tablaMedidas.getRowCount(); i > 0; --i) {
            ((DefaultTableModel)this.tablaMedidas.getModel()).removeRow(i - 1);
        }
        ArrayList<Analisis> comidas = this.controlador.getModelo().getComidas();
        Date fechaActual = new Date();
        int posVectorComidas = this.posPrimerAnalisisIntervalo(comidas, this.fechaInicial, fechaActual);
        Date fechaAux = (Date)this.fechaInicial.clone();
        Date fechaComida = null;
        while (!fechaAux.after(fechaActual)) {
            fechaComida = null;
            if (posVectorComidas != -1 && posVectorComidas < comidas.size()) {
                fechaComida = comidas.get(posVectorComidas).getResultadosTest().get(0).getFecha();
            }
            if (fechaComida == null) {
                this.rellenarVaciaHasta(fechaAux, fechaActual);
            } else {
                this.rellenarVaciaHasta(fechaAux, fechaComida);
            }
            if (fechaComida != null && fechaAux.getDate() == fechaComida.getDate() && fechaAux.getMonth() == fechaComida.getMonth() && fechaAux.getYear() == fechaComida.getYear()) {
                this.insertarNuevoDatoTabla(comidas.get(posVectorComidas));
                ++posVectorComidas;
            }
            fechaAux.setTime(fechaAux.getTime() + 86400000L);
        }
    }

    private int posPrimerAnalisisIntervalo(ArrayList<Analisis> fuente, Date fechaInicial, Date fechaFinal) {
        for (int i = 0; i < fuente.size(); ++i) {
            Date fechaAnalisis = fuente.get(i).getResultadosTest().get(0).getFecha();
            if (fechaInicial.before(fechaAnalisis) && fechaFinal.after(fechaAnalisis)) {
                return i;
            }
            if (fechaInicial.getDate() == fechaAnalisis.getDate() && fechaInicial.getMonth() == fechaAnalisis.getMonth() && fechaInicial.getYear() == fechaAnalisis.getYear()) {
                return i;
            }
            if (fechaFinal.getDate() != fechaAnalisis.getDate() || fechaFinal.getMonth() != fechaAnalisis.getMonth() || fechaFinal.getYear() != fechaAnalisis.getYear()) continue;
            return i;
        }
        return -1;
    }

    private void insertarNuevoDatoTabla(Analisis analisis) {
        String valorAntesDesayuno = null;
        String comentarioAntesDesayuno = null;
        String valorDesayuno = null;
        String comentarioDesayuno = null;
        String valorMediaManana = null;
        String comentarioMediaManana = null;
        String valorComida = null;
        String comentarioComida = null;
        String valorMerienda = null;
        String comentarioMerienda = null;
        String valorCena = null;
        String comentarioCena = null;
        String valorAntesDormir = null;
        String comentarioAntesDormir = null;
        for (ResultadoTest res : analisis.getResultadosTest()) {
            int hora = res.getFecha().getHours();
            if (hora < 7) {
                valorAntesDesayuno = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioAntesDesayuno = res.getObservaciones();
                continue;
            }
            if (hora >= 7 && hora < 10) {
                valorDesayuno = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioDesayuno = res.getObservaciones();
                continue;
            }
            if (hora >= 10 && hora < 13) {
                valorMediaManana = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioMediaManana = res.getObservaciones();
                continue;
            }
            if (hora >= 13 && hora < 16) {
                valorComida = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioComida = res.getObservaciones();
                continue;
            }
            if (hora >= 16 && hora < 21) {
                valorMerienda = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioMerienda = res.getObservaciones();
                continue;
            }
            if (hora >= 21 && hora < 23) {
                valorCena = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioCena = res.getObservaciones();
                continue;
            }
            if (hora < 23) continue;
            valorAntesDormir = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
            comentarioAntesDormir = res.getObservaciones();
        }
        this.comentarios[this.tablaMedidas.getRowCount()] = new String[]{comentarioAntesDesayuno, comentarioDesayuno, comentarioMediaManana, comentarioComida, comentarioMerienda, comentarioCena, comentarioAntesDormir};
        ((DefaultTableModel)this.tablaMedidas.getModel()).addRow(new Object[]{CommonTools.getDateAsString(analisis.getResultadosTest().get(0).getFecha()), valorAntesDesayuno, valorDesayuno, valorMediaManana, valorComida, valorMerienda, valorCena, valorAntesDormir});
    }

    private void rellenarVaciaHasta(Date fechaInicial, Date fechaFinal) {
        while (fechaInicial.getDate() != fechaFinal.getDate() || fechaInicial.getMonth() != fechaFinal.getMonth() || fechaInicial.getYear() != fechaFinal.getYear()) {
            this.comentarios[this.tablaMedidas.getRowCount()] = null;
            ((DefaultTableModel)this.tablaMedidas.getModel()).addRow(new Object[]{CommonTools.getDateAsString(fechaInicial), null, null, null, null, null, null, null});
            fechaInicial.setTime(fechaInicial.getTime() + 86400000L);
        }
    }

    private void buttonNuevaComidaActionPerformed(ActionEvent evt) {
        Analisis analisis = DialogoNuevaComida.showDialogNuevaComida(this.controlador.getModelo().getId());
        if (analisis != null) {
            this.controlador.insertNewAnalisis(analisis);
            this.controlador.updateModelo();
        }
    }

    private void comboBoxIntervaloActionPerformed(ActionEvent evt) {
        long valor;
        this.fechaInicial = new Date();
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("7 d\u00edas")) {
            this.fechaInicial.setTime(this.fechaInicial.getTime() - 604800000L);
            this.comentarios = new String[8][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("14 d\u00edas")) {
            this.fechaInicial.setTime(this.fechaInicial.getTime() - 1209600000L);
            this.comentarios = new String[15][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("1 mes")) {
            valor = Long.parseLong("2419200000");
            this.fechaInicial.setTime(this.fechaInicial.getTime() - valor);
            this.comentarios = new String[32][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("2 meses")) {
            valor = Long.parseLong("4838400000");
            this.fechaInicial.setTime(this.fechaInicial.getTime() - valor);
            this.comentarios = new String[63][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("Ver todos")) {
            // empty if block
        }
        this.fechaInicial.setHours(0);
        this.fechaInicial.setMinutes(0);
        this.fechaInicial.setSeconds(0);
        this.rellenarDatos();
    }

    private void tablaMedidasMouseClicked(MouseEvent evt) {
        int row;
        int column = this.tablaMedidas.getSelectedColumn();
        if (column > 0 && this.comentarios[row = this.tablaMedidas.getSelectedRow()] != null && this.comentarios[row][column - 1] != null && !this.comentarios[row][column - 1].isEmpty()) {
            this.textAreaComentario.setText(this.comentarios[row][column - 1]);
            this.scrollPaneTextAreaComentario.setVisible(true);
            SwingUtilities.updateComponentTreeUI(this);
            return;
        }
        this.scrollPaneTextAreaComentario.setVisible(false);
        SwingUtilities.updateComponentTreeUI(this);
    }

    @Override
    public void updateView() {
        this.rellenarDatos();
    }

    @Override
    public int getIdVista() {
        return this.idVista;
    }

    private void initComponents() {
        this.panelHerramientas = new JPanel();
        this.buttonNuevaComida = new JButton();
        this.jLabel10 = new JLabel();
        this.comboBoxIntervalo = new JComboBox();
        this.jScrollPane6 = new JScrollPane();
        this.tablaMedidas = new JTable();
        this.scrollPaneTextAreaComentario = new JScrollPane();
        this.textAreaComentario = new JTextArea();
        this.jLabel1 = new JLabel();
        this.setMinimumSize(new Dimension(936, 500));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.panelHerramientas.setBackground(new Color(0, 153, 255));
        this.panelHerramientas.setMaximumSize(new Dimension(860, 36));
        this.panelHerramientas.setMinimumSize(new Dimension(860, 36));
        this.panelHerramientas.setPreferredSize(new Dimension(860, 36));
        this.panelHerramientas.setLayout(new GridBagLayout());
        this.buttonNuevaComida.setBackground(new Color(255, 255, 255));
        this.buttonNuevaComida.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonNuevaComida.setForeground(new Color(0, 102, 255));
        this.buttonNuevaComida.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonNuevaComida.setText("Nueva medida de comida");
        this.buttonNuevaComida.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonNuevaComida.setContentAreaFilled(false);
        this.buttonNuevaComida.setCursor(new Cursor(12));
        this.buttonNuevaComida.setOpaque(true);
        this.buttonNuevaComida.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelDietas.this.buttonNuevaComidaActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelHerramientas.add((Component)this.buttonNuevaComida, gridBagConstraints);
        this.jLabel10.setFont(new Font("Trebuchet MS", 1, 14));
        this.jLabel10.setForeground(new Color(255, 255, 255));
        this.jLabel10.setText("Ver los datos de los \u00faltimos");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panelHerramientas.add((Component)this.jLabel10, gridBagConstraints);
        this.comboBoxIntervalo.setModel(new DefaultComboBoxModel<String>(new String[]{"7 d\u00edas", "14 d\u00edas", "1 mes", "2 meses", "Ver todos"}));
        this.comboBoxIntervalo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelDietas.this.comboBoxIntervaloActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 8.0;
        this.panelHerramientas.add((Component)this.comboBoxIntervalo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panelHerramientas, gridBagConstraints);
        this.tablaMedidas.setModel(new DefaultTableModel(new Object[0][], new String[]{"Fecha", "Antes Desayunar", "Desayuno", "MediaMa\u00f1ana", "Comida", "Merienda", "Cena", "Antes de dormir"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablaMedidas.setColumnSelectionAllowed(true);
        this.tablaMedidas.setFillsViewportHeight(true);
        this.tablaMedidas.getTableHeader().setReorderingAllowed(false);
        this.tablaMedidas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelDietas.this.tablaMedidasMouseClicked(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.tablaMedidas);
        this.tablaMedidas.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.tablaMedidas.setDefaultRenderer(Object.class, new CellRenderComidas());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane6, gridBagConstraints);
        this.textAreaComentario.setColumns(20);
        this.textAreaComentario.setEditable(false);
        this.textAreaComentario.setFont(new Font("Trebuchet MS", 0, 12));
        this.textAreaComentario.setLineWrap(true);
        this.textAreaComentario.setRows(10);
        this.textAreaComentario.setTabSize(5);
        this.textAreaComentario.setWrapStyleWord(true);
        this.textAreaComentario.setBorder(BorderFactory.createTitledBorder("Observaciones"));
        this.textAreaComentario.setMinimumSize(new Dimension(20, 20));
        this.scrollPaneTextAreaComentario.setViewportView(this.textAreaComentario);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 69;
        this.add((Component)this.scrollPaneTextAreaComentario, gridBagConstraints);
        this.jLabel1.setText("Para ver las observaciones correspondientes a un valor, haga click sobre la celda correspondiente a dicho valor.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }
}

