/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Modelos.Medicamento;
import Application.Vistas.Dialogos.DialogoDetallesMedicamento;
import Application.Vistas.Interfaces.PacienteView;
import DataManager.GoogleHealthManager.DAOs.MedicamentosDAOGH;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelTratamiento
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    int idVista;
    private JComboBox ComboBoxInsulina;
    private JButton buttonA\u00f1adir;
    private JButton buttonEliminarInsulinaSeleccionada;
    private JButton buttonInsertarNuevoMedicamento;
    private JButton buttonVerDetalles;
    private JLabel jLabel37;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JLabel labelConectese;
    private JLabel labelConectese1;
    private JList listaInsulinas;
    private JList listaMedicamentos;
    private JPanel panelInsulinas;
    private JPanel panelMedicamentos;
    private JPanel panelNuevaInsulina;

    public PanelTratamiento(ControladorPacienteView controlador) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.rellenarListaInsulinas();
        this.rellenarListaMedicamentos();
    }

    private void rellenarListaMedicamentos() {
        DefaultListModel model = (DefaultListModel)this.listaMedicamentos.getModel();
        for (Medicamento med : this.controlador.getModelo().getListaMedicamentos()) {
            model.addElement(med);
        }
    }

    private void rellenarListaInsulinas() {
        DefaultListModel model = (DefaultListModel)this.listaInsulinas.getModel();
        for (Medicamento ins : this.controlador.getModelo().getListaInsulinas()) {
            String productName = ins.getListaProductos().get(0).getProductName();
            model.addElement(productName);
        }
    }

    public void updateView() {
        this.rellenarListaInsulinas();
        this.rellenarListaMedicamentos();
        this.panelNuevaInsulina.setVisible(false);
    }

    public int getIdVista() {
        return this.idVista;
    }

    private void initComponents() {
        this.panelInsulinas = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.listaInsulinas = new JList();
        this.panelNuevaInsulina = new JPanel();
        this.jLabel37 = new JLabel();
        this.ComboBoxInsulina = new JComboBox();
        this.buttonA\u00f1adir = new JButton();
        this.labelConectese = new JLabel();
        this.buttonEliminarInsulinaSeleccionada = new JButton();
        this.panelMedicamentos = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.listaMedicamentos = new JList();
        this.buttonInsertarNuevoMedicamento = new JButton();
        this.buttonVerDetalles = new JButton();
        this.labelConectese1 = new JLabel();
        this.setMinimumSize(new Dimension(746, 501));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(746, 501));
        this.setLayout(new GridBagLayout());
        this.panelInsulinas.setMaximumSize(new Dimension(301, 501));
        this.panelInsulinas.setMinimumSize(new Dimension(301, 501));
        this.panelInsulinas.setOpaque(false);
        this.panelInsulinas.setPreferredSize(new Dimension(301, 501));
        this.panelInsulinas.setLayout(new GridBagLayout());
        this.listaInsulinas.setModel(new DefaultListModel());
        this.listaInsulinas.setSelectionMode(0);
        this.listaInsulinas.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelTratamiento.this.listaInsulinasValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.listaInsulinas);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.panelInsulinas.add((Component)this.jScrollPane4, gridBagConstraints);
        this.panelNuevaInsulina.setOpaque(false);
        this.panelNuevaInsulina.setLayout(new GridBagLayout());
        this.jLabel37.setText("Insertar nueva insulina de tipo ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.panelNuevaInsulina.add((Component)this.jLabel37, gridBagConstraints);
        this.ComboBoxInsulina.setModel(new DefaultComboBoxModel<String>(new String[]{"ACCI\u00d3N RAPIDA", "ACCION BREVE", "INTERMEDIA", "ACCION PROLONGADA", "PREMEZCLA", "INHALADA"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.panelNuevaInsulina.add((Component)this.ComboBoxInsulina, gridBagConstraints);
        this.buttonA\u00f1adir.setFont(new Font("Trebuchet MS", 0, 12));
        this.buttonA\u00f1adir.setForeground(new Color(0, 102, 255));
        this.buttonA\u00f1adir.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonA\u00f1adir.setText("Insertar");
        this.buttonA\u00f1adir.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonA\u00f1adir.setContentAreaFilled(false);
        this.buttonA\u00f1adir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelTratamiento.this.buttonA\u00f1adirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelNuevaInsulina.add((Component)this.buttonA\u00f1adir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 3);
        this.panelInsulinas.add((Component)this.panelNuevaInsulina, gridBagConstraints);
        this.labelConectese.setBackground(new Color(0, 153, 255));
        this.labelConectese.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelConectese.setForeground(new Color(255, 255, 255));
        this.labelConectese.setText("Insulinas");
        this.labelConectese.setBorder(new LineBorder(new Color(0, 153, 255), 3, true));
        this.labelConectese.setMaximumSize(new Dimension(10000, 10000));
        this.labelConectese.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelInsulinas.add((Component)this.labelConectese, gridBagConstraints);
        this.buttonEliminarInsulinaSeleccionada.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonEliminarInsulinaSeleccionada.setForeground(new Color(0, 102, 255));
        this.buttonEliminarInsulinaSeleccionada.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonEliminarInsulinaSeleccionada.setText("Eliminar seleccionada");
        this.buttonEliminarInsulinaSeleccionada.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonEliminarInsulinaSeleccionada.setContentAreaFilled(false);
        this.buttonEliminarInsulinaSeleccionada.setEnabled(false);
        this.buttonEliminarInsulinaSeleccionada.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelTratamiento.this.buttonEliminarInsulinaSeleccionadaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 7, 4);
        this.panelInsulinas.add((Component)this.buttonEliminarInsulinaSeleccionada, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panelInsulinas, gridBagConstraints);
        this.panelMedicamentos.setMaximumSize(new Dimension(445, 501));
        this.panelMedicamentos.setMinimumSize(new Dimension(445, 501));
        this.panelMedicamentos.setOpaque(false);
        this.panelMedicamentos.setPreferredSize(new Dimension(445, 501));
        this.panelMedicamentos.setLayout(new GridBagLayout());
        this.listaMedicamentos.setModel(new DefaultListModel());
        this.listaMedicamentos.setSelectionMode(0);
        this.listaMedicamentos.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelTratamiento.this.listaMedicamentosValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listaMedicamentos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 12);
        this.panelMedicamentos.add((Component)this.jScrollPane3, gridBagConstraints);
        this.buttonInsertarNuevoMedicamento.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonInsertarNuevoMedicamento.setForeground(new Color(0, 102, 255));
        this.buttonInsertarNuevoMedicamento.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonInsertarNuevoMedicamento.setText("Insertar otro medicamento");
        this.buttonInsertarNuevoMedicamento.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonInsertarNuevoMedicamento.setContentAreaFilled(false);
        this.buttonInsertarNuevoMedicamento.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelTratamiento.this.buttonInsertarNuevoMedicamentoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 124);
        this.panelMedicamentos.add((Component)this.buttonInsertarNuevoMedicamento, gridBagConstraints);
        this.buttonVerDetalles.setBackground(new Color(0, 102, 255));
        this.buttonVerDetalles.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonVerDetalles.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/search 24x24.png")));
        this.buttonVerDetalles.setText("Ver detalles");
        this.buttonVerDetalles.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonVerDetalles.setContentAreaFilled(false);
        this.buttonVerDetalles.setEnabled(false);
        this.buttonVerDetalles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelTratamiento.this.buttonVerDetallesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 0, 7, 10);
        this.panelMedicamentos.add((Component)this.buttonVerDetalles, gridBagConstraints);
        this.labelConectese1.setBackground(new Color(0, 153, 255));
        this.labelConectese1.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelConectese1.setForeground(new Color(255, 255, 255));
        this.labelConectese1.setText("Otros medicamentos");
        this.labelConectese1.setBorder(new LineBorder(new Color(0, 153, 255), 3, true));
        this.labelConectese1.setMaximumSize(new Dimension(10000, 10000));
        this.labelConectese1.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 18;
        this.panelMedicamentos.add((Component)this.labelConectese1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelMedicamentos, gridBagConstraints);
    }

    private void buttonInsertarNuevoMedicamentoActionPerformed(ActionEvent evt) {
        Medicamento newMedicamento = DialogoDetallesMedicamento.insertarNuevoMedicamento(this.controlador.getModelo().getId());
        if (newMedicamento != null) {
            this.controlador.insertNewMedicamento(newMedicamento);
            this.controlador.updateModelo();
        }
    }

    private void listaMedicamentosValueChanged(ListSelectionEvent evt) {
        if (this.listaMedicamentos.isSelectionEmpty()) {
            this.buttonVerDetalles.setEnabled(false);
        } else {
            this.buttonVerDetalles.setEnabled(true);
        }
    }

    private void buttonVerDetallesActionPerformed(ActionEvent evt) {
        new DialogoDetallesMedicamento(null, true, (Medicamento)this.listaMedicamentos.getSelectedValue(), this.controlador.getModelo().getId());
    }

    private void listaInsulinasValueChanged(ListSelectionEvent evt) {
        this.buttonEliminarInsulinaSeleccionada.setEnabled(!this.listaInsulinas.isSelectionEmpty());
    }

    private void buttonA\u00f1adirActionPerformed(ActionEvent evt) {
        String estado = "activo";
        String productName = (String)this.ComboBoxInsulina.getSelectedItem();
        boolean insulinaYaInsertada = false;
        for (Medicamento insulina : this.controlador.getModelo().getInsulina()) {
            if (!insulina.getNombre().equalsIgnoreCase(productName)) continue;
            insulinaYaInsertada = true;
            break;
        }
        if (!insulinaYaInsertada) {
            this.controlador.insertNewMedicationInsulina(productName, estado, null, null);
            this.controlador.updateModelo();
            DefaultListModel model = (DefaultListModel)this.listaInsulinas.getModel();
            model.addElement(productName);
        }
    }

    private void buttonEliminarInsulinaSeleccionadaActionPerformed(ActionEvent evt) {
        if (!this.listaInsulinas.isSelectionEmpty()) {
            String insulinaSelected = (String)this.listaInsulinas.getSelectedValue();
            for (Medicamento insulina : this.controlador.getModelo().getInsulina()) {
                if (!insulina.getNombre().equalsIgnoreCase(insulinaSelected) || !new MedicamentosDAOGH().removeMedication(insulina.getIdInterno(), this.controlador.getModelo().getId())) continue;
                this.controlador.updateModelo();
                break;
            }
        }
    }
}

