/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.ClasesAuxiliares;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Cantidad;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import com.google.code.ccr4j.DateTimeType;
import com.google.code.ccr4j.MeasureType;
import com.google.code.ccr4j.OrderRxHistoryType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FulfillmentHistory {
    private ArrayList<Cantidad> cantidad;
    private DateTime fechaRellenado;

    public FulfillmentHistory() {
        this.cantidad = new ArrayList();
    }

    public FulfillmentHistory(String fechaRellenado, String valor, String unidades) {
        this.fechaRellenado = new DateTime(fechaRellenado, "Dispense date");
        if (valor != null || unidades != null) {
            this.cantidad = new ArrayList();
            Cantidad c = new Cantidad();
            if (valor != null) {
                c.setValor(valor);
            }
            if (unidades != null) {
                c.setUnidades(unidades);
            }
            this.cantidad.add(c);
        }
    }

    public static FulfillmentHistory getFulfillmentHistory(OrderRxHistoryType fulfillmentH) {
        List dateTimeList = fulfillmentH.getDateTimeList();
        Iterator it = dateTimeList.iterator();
        FulfillmentHistory resultado = new FulfillmentHistory();
        while (it.hasNext()) {
            DateTimeType f = (DateTimeType)it.next();
            DateTime fecha = DateTime.getDate(f);
            if (!fecha.getType().equals("Dispense date")) continue;
            resultado.setFechaRellenado(fecha);
        }
        List quantityList = fulfillmentH.getQuantityList();
        for (MeasureType m : quantityList) {
            Cantidad c = new Cantidad();
            c.setValor(m.getValue());
            if (m.getUnits() != null) {
                c.setUnidades(m.getUnits().getUnit());
            }
            resultado.getCantidad().add(c);
        }
        return resultado;
    }

    public ArrayList<Cantidad> getCantidad() {
        return this.cantidad;
    }

    public void setCantidad(ArrayList<Cantidad> cantidad) {
        this.cantidad = cantidad;
    }

    public DateTime getFechaRellenado() {
        return this.fechaRellenado;
    }

    public void setFechaRellenado(DateTime fechaRellenado) {
        this.fechaRellenado = fechaRellenado;
    }
}

