/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DAOs;

import DataManager.GoogleHealthManager.Conector;
import DataManager.GoogleHealthManager.DAOs.AnalisisDAOGH;
import DataManager.GoogleHealthManager.DAOs.Interfaces.FunctionalStatusDAO;
import DataManager.GoogleHealthManager.DTOs.FunctionalStatusDTO;
import DataManager.GoogleHealthManager.Interpreters.FunctionalStatusInterpreter;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalStatusDAOGH
implements FunctionalStatusDAO {
    @Override
    public ArrayList<FunctionalStatusDTO> getAllFunctionalStatus(String idPaciente) {
        try {
            String XMLData = Conector.getConector().getProfileData(idPaciente);
            ArrayList<FunctionalStatusDTO> lista = new FunctionalStatusInterpreter().translateCCRtoDTO(XMLData);
            System.out.println("Functional Status retrieved successfully");
            return lista;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (XmlException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR AL CONVERTIR EL CCR EN DTO");
        }
        System.err.println("Functional Status retrieval failed");
        return null;
    }

    @Override
    public String insertFunctionalStatus(FunctionalStatusDTO functionalStatus, String identificador) {
        try {
            String XMLCode = new FunctionalStatusInterpreter().translateDTOtoCCR(functionalStatus);
            return Conector.getConector().insert(identificador, XMLCode);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        return null;
    }

    @Override
    public boolean removeFunctionalStatus(String idFunctionalStatus, String idPaciente) {
        try {
            Conector.getConector().remove(idPaciente, idFunctionalStatus);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public boolean updateFunctionalStatus(FunctionalStatusDTO functionalStatus, String idPaciente) {
        String XMLCode = new FunctionalStatusInterpreter().translateDTOtoCCR(functionalStatus);
        try {
            Conector.getConector().update(idPaciente, XMLCode, functionalStatus.getIdInterno());
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(FunctionalStatusDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

