/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DTOs;

import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.DTOs.ResultadoTestDTO;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalisisDTO {
    String idObjeto;
    Description descripcion;
    DateTime fechaAnalisis;
    Source datosMedico;
    ArrayList<ResultadoTestDTO> resultadosDelAnalisis = new ArrayList();

    public AnalisisDTO() {
        this.resultadosDelAnalisis = new ArrayList();
    }

    public AnalisisDTO(Analisis analisis) {
        this.idObjeto = analisis.getIdInterno();
        this.descripcion = new Description();
        this.descripcion.setText(analisis.getTipoAnalisis());
        this.resultadosDelAnalisis = new ArrayList();
        for (ResultadoTest test : analisis.getResultadosTest()) {
            this.resultadosDelAnalisis.add(new ResultadoTestDTO(test));
        }
    }

    public String getIdObjeto() {
        return this.idObjeto;
    }

    public void setIdObjeto(String idObjeto) {
        this.idObjeto = idObjeto;
    }

    public Source getDatosMedico() {
        return this.datosMedico;
    }

    public void setDatosMedico(Source datosMedico) {
        this.datosMedico = datosMedico;
    }

    public Description getDescripcion() {
        return this.descripcion;
    }

    public void setDescripcion(Description descripcion) {
        this.descripcion = descripcion;
    }

    public DateTime getFechaAnalisis() {
        return this.fechaAnalisis;
    }

    public void setFechaAnalisis(DateTime fechaAnalisis) {
        this.fechaAnalisis = fechaAnalisis;
    }

    public ArrayList<ResultadoTestDTO> getResultadosDelAnalisis() {
        return this.resultadosDelAnalisis;
    }

    public void setResultadosDelAnalisis(ArrayList<ResultadoTestDTO> resultadosDelAnalisis) {
        this.resultadosDelAnalisis = resultadosDelAnalisis;
    }

    public void insertarNuevoResultado(ResultadoTestDTO res) {
        this.resultadosDelAnalisis.add(res);
    }

    public String toString() {
        String datos = "ANALISIS";
        if (this.fechaAnalisis != null) {
            datos = datos + "TOMADO CON FECHA DE " + this.fechaAnalisis.getExactDateTime();
        }
        datos = datos + "\nOrdenado por " + this.datosMedico.toString();
        datos = datos + "\nResultados Obtenidos: \n";
        for (ResultadoTestDTO res : this.resultadosDelAnalisis) {
            datos = datos + res.toString();
        }
        return datos;
    }
}

